/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign;

import feign.Contract;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactivefeign.ReactiveContract;
import reactivefeign.ReactiveFeignBuilder;
import reactivefeign.ReactiveInvocationHandler;
import reactivefeign.ReactiveOptions;
import reactivefeign.ReactiveRetryPolicy;
import reactivefeign.client.InterceptorReactiveHttpClient;
import reactivefeign.client.LoggerReactiveHttpClient;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpClientFactory;
import reactivefeign.client.ReactiveHttpRequestInterceptor;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.ResponseMappers;
import reactivefeign.client.StatusHandlerReactiveHttpClient;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.client.statushandler.ReactiveStatusHandlers;
import reactivefeign.methodhandler.DefaultMethodHandler;
import reactivefeign.methodhandler.MethodHandler;
import reactivefeign.methodhandler.MethodHandlerFactory;
import reactivefeign.publisher.FluxPublisherHttpClient;
import reactivefeign.publisher.FluxRetryPublisherHttpClient;
import reactivefeign.publisher.MonoPublisherHttpClient;
import reactivefeign.publisher.MonoRetryPublisherHttpClient;
import reactivefeign.publisher.PublisherClientFactory;
import reactivefeign.publisher.PublisherHttpClient;
import reactivefeign.utils.FeignUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFeign {
    private final Contract contract;
    private final MethodHandlerFactory methodHandlerFactory;
    private final InvocationHandlerFactory invocationHandlerFactory;

    protected ReactiveFeign(Contract contract, MethodHandlerFactory methodHandlerFactory, InvocationHandlerFactory invocationHandlerFactory) {
        this.contract = contract;
        this.methodHandlerFactory = methodHandlerFactory;
        this.invocationHandlerFactory = invocationHandlerFactory;
    }

    public <T> T newInstance(Target<T> target) {
        Map<String, MethodHandler> nameToHandler = this.targetToHandlersByName(target);
        LinkedHashMap<Method, InvocationHandlerFactory.MethodHandler> methodToHandler = new LinkedHashMap<Method, InvocationHandlerFactory.MethodHandler>();
        LinkedList<DefaultMethodHandler> defaultMethodHandlers = new LinkedList<DefaultMethodHandler>();
        for (Method method2 : target.type().getMethods()) {
            if (Util.isDefault(method2)) {
                DefaultMethodHandler handler = new DefaultMethodHandler(method2);
                defaultMethodHandlers.add(handler);
                methodToHandler.put(method2, handler);
                continue;
            }
            methodToHandler.put(method2, nameToHandler.get(Feign.configKey(target.type(), method2)));
        }
        InvocationHandler handler = this.invocationHandlerFactory.create(target, methodToHandler);
        Object proxy = Proxy.newProxyInstance(target.type().getClassLoader(), new Class[]{target.type()}, handler);
        for (DefaultMethodHandler defaultMethodHandler : defaultMethodHandlers) {
            defaultMethodHandler.bindTo(proxy);
        }
        return (T)proxy;
    }

    Map<String, MethodHandler> targetToHandlersByName(Target target) {
        Map<String, MethodMetadata> metadata = this.contract.parseAndValidatateMetadata(target.type()).stream().collect(Collectors.toMap(MethodMetadata::configKey, md -> md));
        Map<String, Method> configKeyToMethod = Stream.of(target.type().getMethods()).collect(Collectors.toMap(method2 -> Feign.configKey(target.type(), method2), method2 -> method2));
        LinkedHashMap<String, MethodHandler> result = new LinkedHashMap<String, MethodHandler>();
        this.methodHandlerFactory.target(target);
        for (Map.Entry<String, Method> entry : configKeyToMethod.entrySet()) {
            String configKey = entry.getKey();
            MethodMetadata md2 = metadata.get(configKey);
            MethodHandler methodHandler = md2 != null ? this.methodHandlerFactory.create(md2) : this.methodHandlerFactory.createDefault(entry.getValue());
            result.put(configKey, methodHandler);
        }
        return result;
    }

    public static abstract class Builder<T>
    implements ReactiveFeignBuilder<T> {
        protected Contract contract;
        protected ReactiveHttpClientFactory clientFactory;
        protected ReactiveHttpRequestInterceptor requestInterceptor;
        protected BiFunction<MethodMetadata, ReactiveHttpResponse, ReactiveHttpResponse> responseMapper;
        protected ReactiveStatusHandler statusHandler = ReactiveStatusHandlers.defaultFeign(new ErrorDecoder.Default());
        protected InvocationHandlerFactory invocationHandlerFactory = new ReactiveInvocationHandler.Factory();
        protected boolean decode404 = false;
        private Function<Flux<Throwable>, Flux<Throwable>> retryFunction;

        protected Builder() {
            this.contract(new Contract.Default());
        }

        public abstract Builder<T> options(ReactiveOptions var1);

        protected Builder<T> clientFactory(ReactiveHttpClientFactory clientFactory) {
            this.clientFactory = clientFactory;
            return this;
        }

        @Override
        public Builder<T> contract(Contract contract) {
            this.contract = new ReactiveContract(contract);
            return this;
        }

        @Override
        public Builder<T> requestInterceptor(ReactiveHttpRequestInterceptor requestInterceptor) {
            this.requestInterceptor = requestInterceptor;
            return this;
        }

        @Override
        public Builder<T> decode404() {
            this.decode404 = true;
            return this;
        }

        @Override
        public Builder<T> statusHandler(ReactiveStatusHandler statusHandler) {
            this.statusHandler = statusHandler;
            return this;
        }

        @Override
        public Builder<T> responseMapper(BiFunction<MethodMetadata, ReactiveHttpResponse, ReactiveHttpResponse> responseMapper) {
            this.responseMapper = responseMapper;
            return this;
        }

        @Override
        public Builder<T> retryWhen(Function<Flux<Throwable>, Flux<Throwable>> retryFunction) {
            this.retryFunction = retryFunction;
            return this;
        }

        public Builder<T> retryWhen(ReactiveRetryPolicy retryPolicy) {
            return this.retryWhen((Function)retryPolicy.toRetryFunction());
        }

        @Override
        public Contract contract() {
            return this.contract;
        }

        @Override
        public InvocationHandlerFactory invocationHandlerFactory() {
            return this.invocationHandlerFactory;
        }

        @Override
        public PublisherClientFactory buildReactiveClientFactory() {
            return new PublisherClientFactory(){

                @Override
                public void target(Target target) {
                    clientFactory.target(target);
                }

                @Override
                public PublisherHttpClient create(MethodMetadata methodMetadata) {
                    Util.checkNotNull(clientFactory, "clientFactory wasn't provided in ReactiveFeign builder", new Object[0]);
                    ReactiveHttpClient reactiveClient = clientFactory.create(methodMetadata);
                    if (requestInterceptor != null) {
                        reactiveClient = InterceptorReactiveHttpClient.intercept(reactiveClient, requestInterceptor);
                    }
                    reactiveClient = LoggerReactiveHttpClient.log(reactiveClient, methodMetadata);
                    if (responseMapper != null) {
                        reactiveClient = ResponseMappers.mapResponse(reactiveClient, methodMetadata, responseMapper);
                    }
                    if (decode404) {
                        reactiveClient = ResponseMappers.mapResponse(reactiveClient, methodMetadata, ResponseMappers.ignore404());
                    }
                    if (statusHandler != null) {
                        reactiveClient = StatusHandlerReactiveHttpClient.handleStatus(reactiveClient, methodMetadata, statusHandler);
                    }
                    PublisherHttpClient publisherClient = this.toPublisher(reactiveClient, methodMetadata);
                    if (retryFunction != null) {
                        publisherClient = this.retry(publisherClient, methodMetadata, retryFunction);
                    }
                    return publisherClient;
                }
            };
        }

        protected PublisherHttpClient retry(PublisherHttpClient publisherClient, MethodMetadata methodMetadata, Function<Flux<Throwable>, Flux<Throwable>> retryFunction) {
            Class returnPublisherType = FeignUtils.returnPublisherType(methodMetadata);
            if (returnPublisherType == Mono.class) {
                return new MonoRetryPublisherHttpClient((MonoPublisherHttpClient)publisherClient, methodMetadata, retryFunction);
            }
            if (returnPublisherType == Flux.class) {
                return new FluxRetryPublisherHttpClient((FluxPublisherHttpClient)publisherClient, methodMetadata, retryFunction);
            }
            throw new IllegalArgumentException("Unknown returnPublisherType: " + returnPublisherType);
        }

        protected PublisherHttpClient toPublisher(ReactiveHttpClient reactiveHttpClient, MethodMetadata methodMetadata) {
            Class returnPublisherType = FeignUtils.returnPublisherType(methodMetadata);
            if (returnPublisherType == Mono.class) {
                return new MonoPublisherHttpClient(reactiveHttpClient);
            }
            if (returnPublisherType == Flux.class) {
                return new FluxPublisherHttpClient(reactiveHttpClient);
            }
            throw new IllegalArgumentException("Unknown returnPublisherType: " + returnPublisherType);
        }
    }
}

