/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class WebSessionArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    public WebSessionArgumentResolver(ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.checkParameterType(parameter, WebSession.class::isAssignableFrom);
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext context, ServerWebExchange exchange2) {
        Mono<WebSession> session = exchange2.getSession();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(parameter.getParameterType());
        return adapter != null ? Mono.just(adapter.fromPublisher(session)) : Mono.from(session);
    }
}

