/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.UnsupportedMediaTypeException;
import reactor.core.publisher.Mono;

public abstract class BodyInserters {
    private static final ResolvableType RESOURCE_TYPE = ResolvableType.forClass(Resource.class);
    private static final ResolvableType SSE_TYPE = ResolvableType.forClass(ServerSentEvent.class);
    private static final ResolvableType FORM_DATA_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, String.class, String.class);
    private static final ResolvableType MULTIPART_DATA_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, String.class, Object.class);
    private static final BodyInserter<Void, ReactiveHttpOutputMessage> EMPTY_INSERTER = (response, context) -> response.setComplete();

    public static <T> BodyInserter<T, ReactiveHttpOutputMessage> empty() {
        return EMPTY_INSERTER;
    }

    public static <T> BodyInserter<T, ReactiveHttpOutputMessage> fromObject(T body2) {
        return (message, context) -> BodyInserters.writeWithMessageWriters(message, context, Mono.just(body2), ResolvableType.forInstance(body2));
    }

    public static <T, P extends Publisher<T>> BodyInserter<P, ReactiveHttpOutputMessage> fromPublisher(P publisher, Class<T> elementClass) {
        Assert.notNull(publisher, "Publisher must not be null");
        Assert.notNull(elementClass, "Element Class must not be null");
        return (message, context) -> BodyInserters.writeWithMessageWriters(message, context, publisher, ResolvableType.forClass(elementClass));
    }

    public static <T, P extends Publisher<T>> BodyInserter<P, ReactiveHttpOutputMessage> fromPublisher(P publisher, ParameterizedTypeReference<T> typeReference) {
        Assert.notNull(publisher, "Publisher must not be null");
        Assert.notNull(typeReference, "ParameterizedTypeReference must not be null");
        return (message, context) -> BodyInserters.writeWithMessageWriters(message, context, publisher, ResolvableType.forType(typeReference.getType()));
    }

    public static <T extends Resource> BodyInserter<T, ReactiveHttpOutputMessage> fromResource(T resource) {
        Assert.notNull(resource, "Resource must not be null");
        return (outputMessage, context) -> {
            ResolvableType elementType = RESOURCE_TYPE;
            HttpMessageWriter writer = BodyInserters.findWriter(context, elementType, null);
            return BodyInserters.write(Mono.just(resource), elementType, null, outputMessage, context, writer);
        };
    }

    public static <T, S extends Publisher<ServerSentEvent<T>>> BodyInserter<S, ServerHttpResponse> fromServerSentEvents(S eventsPublisher) {
        Assert.notNull(eventsPublisher, "Publisher must not be null");
        return (serverResponse, context) -> {
            ResolvableType elementType = SSE_TYPE;
            MediaType mediaType = MediaType.TEXT_EVENT_STREAM;
            HttpMessageWriter writer = BodyInserters.findWriter(context, elementType, mediaType);
            return BodyInserters.write(eventsPublisher, elementType, mediaType, serverResponse, context, writer);
        };
    }

    public static FormInserter<String> fromFormData(MultiValueMap<String, String> formData) {
        return new DefaultFormInserter().with(formData);
    }

    public static FormInserter<String> fromFormData(String name, String value) {
        Assert.notNull((Object)name, "'name' must not be null");
        Assert.notNull((Object)value, "'value' must not be null");
        return new DefaultFormInserter().with(name, value);
    }

    public static MultipartInserter fromMultipartData(MultiValueMap<String, ?> multipartData) {
        Assert.notNull(multipartData, "'multipartData' must not be null");
        return new DefaultMultipartInserter().withInternal(multipartData);
    }

    public static MultipartInserter fromMultipartData(String name, Object value) {
        Assert.notNull((Object)name, "'name' must not be null");
        Assert.notNull(value, "'value' must not be null");
        return new DefaultMultipartInserter().with(name, value);
    }

    public static <T, P extends Publisher<T>> MultipartInserter fromMultipartAsyncData(String name, P publisher, Class<T> elementClass) {
        return new DefaultMultipartInserter().withPublisher(name, publisher, elementClass);
    }

    public static <T, P extends Publisher<T>> MultipartInserter fromMultipartAsyncData(String name, P publisher, ParameterizedTypeReference<T> typeReference) {
        return new DefaultMultipartInserter().withPublisher(name, publisher, typeReference);
    }

    public static <T extends Publisher<DataBuffer>> BodyInserter<T, ReactiveHttpOutputMessage> fromDataBuffers(T publisher) {
        Assert.notNull(publisher, "Publisher must not be null");
        return (outputMessage, context) -> outputMessage.writeWith(publisher);
    }

    private static <P extends Publisher<?>, M extends ReactiveHttpOutputMessage> Mono<Void> writeWithMessageWriters(M outputMessage, BodyInserter.Context context, P body2, ResolvableType bodyType) {
        MediaType mediaType = outputMessage.getHeaders().getContentType();
        return context.messageWriters().stream().filter(messageWriter -> messageWriter.canWrite(bodyType, mediaType)).findFirst().map(BodyInserters::cast).map(writer -> BodyInserters.write(body2, bodyType, mediaType, outputMessage, context, writer)).orElseGet(() -> Mono.error(BodyInserters.unsupportedError(bodyType, context, mediaType)));
    }

    private static UnsupportedMediaTypeException unsupportedError(ResolvableType bodyType, BodyInserter.Context context, @Nullable MediaType mediaType) {
        List<MediaType> supportedMediaTypes = context.messageWriters().stream().flatMap(reader -> reader.getWritableMediaTypes().stream()).collect(Collectors.toList());
        return new UnsupportedMediaTypeException(mediaType, supportedMediaTypes, bodyType);
    }

    private static <T> Mono<Void> write(Publisher<? extends T> input, ResolvableType type, @Nullable MediaType mediaType, ReactiveHttpOutputMessage message, BodyInserter.Context context, HttpMessageWriter<T> writer) {
        return context.serverRequest().map(request -> {
            ServerHttpResponse response = (ServerHttpResponse)message;
            return writer.write(input, type, type, mediaType, (ServerHttpRequest)request, response, context.hints());
        }).orElseGet(() -> writer.write(input, type, mediaType, message, context.hints()));
    }

    private static <T> HttpMessageWriter<T> findWriter(BodyInserter.Context context, ResolvableType elementType, @Nullable MediaType mediaType) {
        return context.messageWriters().stream().filter(messageWriter -> messageWriter.canWrite(elementType, mediaType)).findFirst().map(BodyInserters::cast).orElseThrow(() -> new IllegalStateException("No HttpMessageWriter for \"" + mediaType + "\" and \"" + elementType + "\""));
    }

    private static <T> HttpMessageWriter<T> cast(HttpMessageWriter<?> messageWriter) {
        return messageWriter;
    }

    private static class DefaultMultipartInserter
    implements MultipartInserter {
        private final MultipartBodyBuilder builder = new MultipartBodyBuilder();

        private DefaultMultipartInserter() {
        }

        public MultipartInserter with(String key, Object value) {
            this.builder.part(key, value);
            return this;
        }

        public MultipartInserter with(MultiValueMap<String, Object> values) {
            return this.withInternal(values);
        }

        private MultipartInserter withInternal(MultiValueMap<String, ?> values) {
            values.forEach((key, valueList) -> {
                for (Object value : valueList) {
                    this.builder.part((String)key, value);
                }
            });
            return this;
        }

        @Override
        public <T, P extends Publisher<T>> MultipartInserter withPublisher(String name, P publisher, Class<T> elementClass) {
            this.builder.asyncPart(name, publisher, elementClass);
            return this;
        }

        @Override
        public <T, P extends Publisher<T>> MultipartInserter withPublisher(String name, P publisher, ParameterizedTypeReference<T> typeReference) {
            this.builder.asyncPart(name, publisher, typeReference);
            return this;
        }

        @Override
        public Mono<Void> insert(ClientHttpRequest outputMessage, BodyInserter.Context context) {
            HttpMessageWriter messageWriter = BodyInserters.findWriter(context, MULTIPART_DATA_TYPE, MediaType.MULTIPART_FORM_DATA);
            MultiValueMap<String, HttpEntity<?>> body2 = this.builder.build();
            return messageWriter.write(Mono.just(body2), MULTIPART_DATA_TYPE, MediaType.MULTIPART_FORM_DATA, outputMessage, context.hints());
        }
    }

    private static class DefaultFormInserter
    implements FormInserter<String> {
        private final MultiValueMap<String, String> data = new LinkedMultiValueMap<String, String>();

        private DefaultFormInserter() {
        }

        @Override
        public FormInserter<String> with(String key, @Nullable String value) {
            this.data.add(key, value);
            return this;
        }

        @Override
        public FormInserter<String> with(MultiValueMap<String, String> values) {
            this.data.addAll(values);
            return this;
        }

        @Override
        public Mono<Void> insert(ClientHttpRequest outputMessage, BodyInserter.Context context) {
            HttpMessageWriter messageWriter = BodyInserters.findWriter(context, FORM_DATA_TYPE, MediaType.APPLICATION_FORM_URLENCODED);
            return messageWriter.write(Mono.just(this.data), FORM_DATA_TYPE, MediaType.APPLICATION_FORM_URLENCODED, outputMessage, context.hints());
        }
    }

    public static interface MultipartInserter
    extends FormInserter<Object> {
        public <T, P extends Publisher<T>> MultipartInserter withPublisher(String var1, P var2, Class<T> var3);

        public <T, P extends Publisher<T>> MultipartInserter withPublisher(String var1, P var2, ParameterizedTypeReference<T> var3);
    }

    public static interface FormInserter<T>
    extends BodyInserter<MultiValueMap<String, T>, ClientHttpRequest> {
        public FormInserter<T> with(String var1, T var2);

        public FormInserter<T> with(MultiValueMap<String, T> var1);
    }
}

