/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.io.EOFException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.CompletableCallback;

public class HttpReceiverOverHTTP
extends HttpReceiver
implements HttpParser.ResponseHandler {
    private final HttpParser parser;
    private ByteBuffer buffer;
    private boolean shutdown;
    private boolean complete;

    public HttpReceiverOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
        this.parser = new HttpParser((HttpParser.ResponseHandler)this, -1, channel.getHttpDestination().getHttpClient().getHttpCompliance());
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    private HttpConnectionOverHTTP getHttpConnection() {
        return this.getHttpChannel().getHttpConnection();
    }

    protected ByteBuffer getResponseBuffer() {
        return this.buffer;
    }

    public void receive() {
        if (this.buffer == null) {
            this.acquireBuffer();
        }
        this.process();
    }

    private void acquireBuffer() {
        HttpClient client = this.getHttpDestination().getHttpClient();
        ByteBufferPool bufferPool = client.getByteBufferPool();
        this.buffer = bufferPool.acquire(client.getResponseBufferSize(), true);
    }

    private void releaseBuffer() {
        if (this.buffer == null) {
            throw new IllegalStateException();
        }
        if (BufferUtil.hasContent(this.buffer)) {
            throw new IllegalStateException();
        }
        HttpClient client = this.getHttpDestination().getHttpClient();
        ByteBufferPool bufferPool = client.getByteBufferPool();
        bufferPool.release(this.buffer);
        this.buffer = null;
    }

    protected ByteBuffer onUpgradeFrom() {
        if (BufferUtil.hasContent(this.buffer)) {
            ByteBuffer upgradeBuffer = ByteBuffer.allocate(this.buffer.remaining());
            upgradeBuffer.put(this.buffer).flip();
            return upgradeBuffer;
        }
        return null;
    }

    private void process() {
        try {
            int read;
            block10: {
                HttpConnectionOverHTTP connection = this.getHttpConnection();
                EndPoint endPoint = connection.getEndPoint();
                do {
                    boolean upgraded;
                    boolean bl = upgraded = connection != endPoint.getConnection();
                    if (connection.isClosed() || upgraded) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} {}", connection, upgraded ? "upgraded" : "closed");
                        }
                        this.releaseBuffer();
                        return;
                    }
                    if (this.parse()) {
                        return;
                    }
                    read = endPoint.fill(this.buffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Read {} bytes {} from {}", read, BufferUtil.toDetailString(this.buffer), endPoint);
                    }
                    if (read <= 0) break block10;
                    connection.addBytesIn(read);
                } while (!this.parse());
                return;
            }
            if (read == 0) {
                this.releaseBuffer();
                this.fillInterested();
                return;
            }
            this.releaseBuffer();
            this.shutdown();
            return;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            BufferUtil.clear(this.buffer);
            if (this.buffer != null) {
                this.releaseBuffer();
            }
            this.failAndClose(x);
            return;
        }
    }

    private boolean parse() {
        boolean complete;
        do {
            boolean handle = this.parser.parseNext(this.buffer);
            complete = this.complete;
            this.complete = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsed {}, remaining {} {}", handle, this.buffer.remaining(), this.parser);
            }
            if (handle) {
                return true;
            }
            if (this.buffer.hasRemaining()) continue;
            return false;
        } while (!complete);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discarding unexpected content after response: {}", BufferUtil.toDetailString(this.buffer));
        }
        BufferUtil.clear(this.buffer);
        return false;
    }

    protected void fillInterested() {
        this.getHttpConnection().fillInterested();
    }

    private void shutdown() {
        this.shutdown = true;
        this.parser.atEOF();
        this.parser.parseNext(BufferUtil.EMPTY_BUFFER);
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public int getHeaderCacheSize() {
        return 4096;
    }

    @Override
    public boolean startResponse(HttpVersion version, int status, String reason) {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            return false;
        }
        String method2 = exchange2.getRequest().getMethod();
        this.parser.setHeadResponse(HttpMethod.HEAD.is(method2) || HttpMethod.CONNECT.is(method2) && status == 200);
        exchange2.getResponse().version(version).status(status).reason(reason);
        return !this.responseBegin(exchange2);
    }

    @Override
    public void parsedHeader(HttpField field) {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            return;
        }
        this.responseHeader(exchange2, field);
    }

    @Override
    public boolean headerComplete() {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            return false;
        }
        return !this.responseHeaders(exchange2);
    }

    @Override
    public boolean content(ByteBuffer buffer) {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            return false;
        }
        CompletableCallback callback = new CompletableCallback(){

            @Override
            public void resume() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content consumed asynchronously, resuming processing", new Object[0]);
                }
                HttpReceiverOverHTTP.this.process();
            }

            @Override
            public void abort(Throwable x) {
                HttpReceiverOverHTTP.this.failAndClose(x);
            }
        };
        boolean proceed = this.responseContent(exchange2, buffer, callback);
        boolean async = callback.tryComplete();
        return !proceed || async;
    }

    @Override
    public boolean contentComplete() {
        return false;
    }

    @Override
    public void parsedTrailer(HttpField trailer) {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            return;
        }
        exchange2.getResponse().trailer(trailer);
    }

    @Override
    public boolean messageComplete() {
        boolean proceed;
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 == null) {
            return false;
        }
        int status = exchange2.getResponse().getStatus();
        if (status != 100) {
            this.complete = true;
        }
        if (!(proceed = this.responseSuccess(exchange2))) {
            return true;
        }
        if (status == 101) {
            return true;
        }
        return HttpMethod.CONNECT.is(exchange2.getRequest().getMethod()) && status == 200;
    }

    @Override
    public void earlyEOF() {
        HttpExchange exchange2 = this.getHttpExchange();
        HttpConnectionOverHTTP connection = this.getHttpConnection();
        if (exchange2 == null) {
            connection.close();
        } else {
            this.failAndClose(new EOFException(String.valueOf(connection)));
        }
    }

    @Override
    public void badMessage(BadMessageException failure) {
        HttpExchange exchange2 = this.getHttpExchange();
        if (exchange2 != null) {
            HttpResponse response = exchange2.getResponse();
            response.status(failure.getCode()).reason(failure.getReason());
            this.failAndClose(new HttpResponseException("HTTP protocol violation: bad response on " + this.getHttpConnection(), response, failure));
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.parser.reset();
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.parser.close();
    }

    private void failAndClose(Throwable failure) {
        if (this.responseFailure(failure)) {
            this.getHttpConnection().close(failure);
        }
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.parser);
    }
}

