/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;

public enum ConditionalHelpers implements Helper<Object>
{
    eq{

        @Override
        public Object apply(Object a, Options options) throws IOException {
            Object b = options.param(0, null);
            boolean result = new EqualsBuilder().append(a, b).isEquals();
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    neq{

        @Override
        public Object apply(Object a, Options options) throws IOException {
            boolean result;
            Object b = options.param(0, null);
            boolean bl = result = !new EqualsBuilder().append(a, b).isEquals();
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    gt{

        @Override
        public Object apply(Object a, Options options) throws IOException {
            boolean result;
            boolean bl = result = this.cmp(a, options.param(0, null)) > 0;
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    gte{

        @Override
        public Object apply(Object a, Options options) throws IOException {
            boolean result;
            boolean bl = result = this.cmp(a, options.param(0, null)) >= 0;
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    lt{

        @Override
        public Object apply(Object a, Options options) throws IOException {
            boolean result;
            boolean bl = result = this.cmp(a, options.param(0, null)) < 0;
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    lte{

        @Override
        public Object apply(Object a, Options options) throws IOException {
            boolean result;
            boolean bl = result = this.cmp(a, options.param(0, null)) <= 0;
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    and{

        @Override
        public Object apply(Object context, Options options) throws IOException {
            boolean result;
            boolean bl = result = !Handlebars.Utils.isEmpty(context);
            if (result) {
                for (int i = 0; i < options.params.length && result; ++i) {
                    result = !Handlebars.Utils.isEmpty(options.params[i]);
                }
            }
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    or{

        @Override
        public Object apply(Object context, Options options) throws IOException {
            boolean result;
            boolean bl = result = !Handlebars.Utils.isEmpty(context);
            if (!result) {
                int i = 0;
                while (!result && i < options.params.length) {
                    result = !Handlebars.Utils.isEmpty(options.params[i++]);
                }
            }
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    }
    ,
    not{

        @Override
        public Object apply(Object context, Options options) throws IOException {
            boolean result = Handlebars.Utils.isEmpty(context);
            if (options.tagType == TagType.SECTION) {
                return result ? options.fn() : options.inverse();
            }
            return result ? options.hash("yes", true) : options.hash("no", false);
        }
    };


    protected int cmp(Object a, Object b) {
        Validate.isTrue(a instanceof Comparable, "Not a comparable: " + a, new Object[0]);
        Validate.isTrue(b instanceof Comparable, "Not a comparable: " + b, new Object[0]);
        return ((Comparable)a).compareTo(b);
    }
}

