/*
 * Decompiled with CFR 0.152.
 */
package com.playlyfe.sdk;

import com.auth0.jwt.Algorithm;
import com.auth0.jwt.JWTSigner;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Playlyfe {
    private String version;
    private String client_id;
    private String client_secret;
    private String type;
    private String redirect_uri;
    private String code;
    private PersistAccessToken pac;
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient client = new OkHttpClient();
    private final Gson gson = new Gson();

    public static String createJWT(String client_id, String client_secret, String player_id, String[] scopes, int expires) {
        JWTSigner signer = new JWTSigner(client_secret);
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("player_id", player_id);
        claims.put("scopes", scopes);
        String token = signer.sign(claims, new JWTSigner.Options().setExpirySeconds(Integer.valueOf(expires)).setAlgorithm(Algorithm.HS256));
        token = client_id + ':' + token;
        return token;
    }

    public Playlyfe(String client_id, String client_secret, PersistAccessToken pac, String version) {
        this.client_id = client_id;
        this.client_secret = client_secret;
        this.type = "client";
        this.pac = pac;
        this.version = version;
        this.client.setConnectTimeout(10L, TimeUnit.SECONDS);
        this.client.setWriteTimeout(10L, TimeUnit.SECONDS);
        this.client.setReadTimeout(30L, TimeUnit.SECONDS);
    }

    public Playlyfe(String client_id, String client_secret, PersistAccessToken pac) {
        this(client_id, client_secret, pac, "v2");
    }

    public Playlyfe(String client_id, String client_secret, String redirect_uri, PersistAccessToken pac) {
        this(client_id, client_secret, redirect_uri, pac, "v2");
    }

    public Playlyfe(String client_id, String client_secret, String redirect_uri, PersistAccessToken pac, String version) {
        this.client_id = client_id;
        this.client_secret = client_secret;
        this.redirect_uri = redirect_uri;
        this.type = "code";
        this.pac = pac;
        this.version = version;
    }

    public void getAccessTokenAsync(final Callback cb) {
        System.out.println("Getting Access Token");
        JsonObject json = new JsonObject();
        json.addProperty("client_id", this.client_id);
        json.addProperty("client_secret", this.client_secret);
        if (this.type.equals("client")) {
            json.addProperty("grant_type", "client_credentials");
        } else {
            json.addProperty("grant_type", "authorization_code");
            json.addProperty("code", this.code);
            json.addProperty("redirect_uri", this.redirect_uri);
        }
        Request request = new Request.Builder().url("https://playlyfe.com/auth/token").post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)json.toString())).build();
        this.client.newCall(request).enqueue(new com.squareup.okhttp.Callback(){

            public void onResponse(Response response) throws IOException {
                try {
                    final Map token = (Map)Playlyfe.this.parseJson(response.body().string());
                    Long expires_at = System.currentTimeMillis() + ((Double)token.get("expires_in")).longValue() * 1000L;
                    token.remove("expires_in");
                    token.put("expires_at", expires_at);
                    if (Playlyfe.this.pac == null) {
                        Playlyfe.this.pac = new PersistAccessToken(){

                            @Override
                            public void store(Map<String, Object> token2) {
                                System.out.println("Storing Access Token");
                            }

                            @Override
                            public Map<String, Object> load() {
                                return token;
                            }
                        };
                    }
                    Playlyfe.this.pac.store(token);
                    cb.onSuccess(null);
                }
                catch (PlaylyfeException e) {
                    cb.onPlaylyfeError(e);
                }
            }

            public void onFailure(Request request, IOException e) {
                cb.onIOError(e);
            }
        });
    }

    public void getAccessToken() throws IOException, PlaylyfeException {
        System.out.println("Getting Access Token");
        JsonObject json = new JsonObject();
        json.addProperty("client_id", this.client_id);
        json.addProperty("client_secret", this.client_secret);
        if (this.type.equals("client")) {
            json.addProperty("grant_type", "client_credentials");
        } else {
            json.addProperty("grant_type", "authorization_code");
            json.addProperty("code", this.code);
            json.addProperty("redirect_uri", this.redirect_uri);
        }
        Request request = new Request.Builder().url("https://playlyfe.com/auth/token").post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)json.toString())).build();
        Response response = this.client.newCall(request).execute();
        final Map token = (Map)this.parseJson(response.body().string());
        Long expires_at = System.currentTimeMillis() + ((Double)token.get("expires_in")).longValue() * 1000L;
        token.remove("expires_in");
        token.put("expires_at", expires_at);
        if (this.pac == null) {
            this.pac = new PersistAccessToken(){

                @Override
                public void store(Map<String, Object> token2) {
                    System.out.println("Storing Access Token");
                }

                @Override
                public Map<String, Object> load() {
                    return token;
                }
            };
        }
        this.pac.store(token);
    }

    public Object api(String method, String route, Map<String, String> query, Object body, boolean raw) throws IOException, PlaylyfeException {
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme("https").host("api.playlyfe.com").encodedPath("/" + this.version + route);
        if (query != null) {
            for (Map.Entry<String, String> entry : query.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        Map<String, Object> token = null;
        if (this.pac != null) {
            token = this.pac.load();
        }
        if (this.pac == null || token == null || System.currentTimeMillis() >= (Long)token.get("expires_at")) {
            this.getAccessToken();
            token = this.pac.load();
        }
        urlBuilder.addQueryParameter("access_token", token.get("access_token").toString());
        HttpUrl url = urlBuilder.build();
        String req_body = "";
        if (body != null) {
            req_body = this.gson.toJson(body);
        }
        Request request = method.equalsIgnoreCase("GET") ? new Request.Builder().url(url).build() : (method.equalsIgnoreCase("POST") ? new Request.Builder().url(url).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)req_body)).build() : (method.equalsIgnoreCase("PUT") ? new Request.Builder().url(url).put(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)req_body)).build() : (method.equalsIgnoreCase("PATCH") ? new Request.Builder().url(url).patch(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)req_body)).build() : (method.equalsIgnoreCase("Delete") ? new Request.Builder().url(url).delete().build() : new Request.Builder().url(url).build()))));
        Response response = this.client.newCall(request).execute();
        if (raw) {
            return response.body().bytes();
        }
        return this.parseJson(response.body().string());
    }

    public void apiAsync(final String method, final String route, final Map<String, String> query, final Object body, final boolean raw, final Callback cb) {
        Map<String, Object> token = null;
        if (this.pac != null) {
            token = this.pac.load();
        }
        if (this.pac == null || token == null || System.currentTimeMillis() >= (Long)token.get("expires_at")) {
            this.getAccessTokenAsync(new Callback(){

                @Override
                public void onSuccess(Object data) {
                    Playlyfe.this.makeRequestAsync(Playlyfe.this.pac.load(), method, route, query, body, raw, cb);
                }

                @Override
                public void onPlaylyfeError(PlaylyfeException e) {
                    cb.onPlaylyfeError(e);
                }

                @Override
                public void onIOError(IOException e) {
                    cb.onIOError(e);
                }
            });
        } else {
            this.makeRequestAsync(token, method, route, query, body, raw, cb);
        }
    }

    public void makeRequestAsync(Map<String, Object> token, String method, String route, Map<String, String> query, Object body, final boolean raw, final Callback cb) {
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme("https").host("api.playlyfe.com").encodedPath("/" + this.version + route);
        if (query != null) {
            for (Map.Entry<String, String> entry : query.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        urlBuilder.addQueryParameter("access_token", token.get("access_token").toString());
        HttpUrl url = urlBuilder.build();
        String req_body = "";
        if (body != null) {
            req_body = this.gson.toJson(body);
        }
        Request request = method.equalsIgnoreCase("GET") ? new Request.Builder().url(url).build() : (method.equalsIgnoreCase("POST") ? new Request.Builder().url(url).post(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)req_body)).build() : (method.equalsIgnoreCase("PUT") ? new Request.Builder().url(url).put(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)req_body)).build() : (method.equalsIgnoreCase("PATCH") ? new Request.Builder().url(url).patch(RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)req_body)).build() : (method.equalsIgnoreCase("Delete") ? new Request.Builder().url(url).delete().build() : new Request.Builder().url(url).build()))));
        this.client.newCall(request).enqueue(new com.squareup.okhttp.Callback(){

            public void onResponse(Response response) throws IOException {
                if (raw) {
                    cb.onSuccess(response.body().bytes());
                } else {
                    try {
                        Object data = Playlyfe.this.parseJson(response.body().string());
                        cb.onSuccess(data);
                    }
                    catch (PlaylyfeException e) {
                        cb.onPlaylyfeError(e);
                    }
                }
            }

            public void onFailure(Request request, IOException e) {
                cb.onIOError(e);
            }
        });
    }

    public Object get(String route, Map<String, String> query) throws IOException, PlaylyfeException {
        return this.api("GET", route, query, null, false);
    }

    public byte[] getRaw(String route, Map<String, String> query) throws IOException, PlaylyfeException {
        return (byte[])this.api("GET", route, query, null, true);
    }

    public Object post(String route, Map<String, String> query, Object body) throws IOException, PlaylyfeException {
        return this.api("POST", route, query, body, false);
    }

    public Object put(String route, Map<String, String> query, Object body) throws IOException, PlaylyfeException {
        return this.api("PUT", route, query, body, false);
    }

    public Object patch(String route, Map<String, String> query, Object body) throws IOException, PlaylyfeException {
        return this.api("PATCH", route, query, body, false);
    }

    public Object delete(String route, Map<String, String> query) throws IOException, PlaylyfeException {
        return this.api("DELETE", route, query, null, false);
    }

    public void getAsync(String route, Map<String, String> query, Callback cb) {
        this.apiAsync("GET", route, query, null, false, cb);
    }

    public void getRawAsync(String route, Map<String, String> query, Callback cb) {
        this.apiAsync("GET", route, query, null, true, cb);
    }

    public void postAsync(String route, Map<String, String> query, Object body, Callback cb) {
        this.apiAsync("POST", route, query, body, false, cb);
    }

    public void putAsync(String route, Map<String, String> query, Object body, Callback cb) {
        this.apiAsync("PUT", route, query, body, false, cb);
    }

    public void patchAsync(String route, Map<String, String> query, Object body, Callback cb) {
        this.apiAsync("PATCH", route, query, body, false, cb);
    }

    public void deleteAsync(String route, Map<String, String> query, Callback cb) {
        this.apiAsync("DELETE", route, query, null, false, cb);
    }

    private Object parseJson(String content) throws PlaylyfeException {
        if (content.contains("error") && content.contains("error_description")) {
            Map errors = (Map)this.gson.fromJson(content, Object.class);
            throw new PlaylyfeException((String)errors.get("error"), (String)errors.get("error_description"));
        }
        return this.gson.fromJson(content, Object.class);
    }

    public String get_login_url() throws URISyntaxException {
        return "https://playlyfe.com/auth?response_type=code&client_id=" + this.client_id + "&redirect_uri=" + this.redirect_uri;
    }

    public void exchange_code(String code) throws IOException, PlaylyfeException {
        this.code = code;
    }

    public static interface Callback {
        public void onSuccess(Object var1);

        public void onPlaylyfeError(PlaylyfeException var1);

        public void onIOError(IOException var1);
    }

    public static interface PersistAccessToken {
        public void store(Map<String, Object> var1);

        public Map<String, Object> load();
    }

    public static class PlaylyfeException
    extends Exception {
        private String name;

        public PlaylyfeException(String name, String message) {
            super(message);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

