/*
 * Decompiled with CFR 0.152.
 */
package com.pkrete.xrd4j.rest.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtil {
    private static final String REMOVE_WHITE_SPACE_PATTERN = "\\r\\n|\\r|\\n";
    private static final Logger logger = LoggerFactory.getLogger(ClientUtil.class);

    private ClientUtil() {
    }

    public static String getResponseString(HttpEntity entity) {
        StringBuilder builder = new StringBuilder();
        if (entity != null) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(entity.getContent()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    builder.append(inputLine);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return builder.toString();
    }

    public static String buildTargetURL(String url, Map<String, ?> params) {
        logger.debug("Target URL : \"{}\".", (Object)url);
        if (params == null || params.isEmpty()) {
            logger.debug("URL parameters list is null or empty. Nothing to do here. Return target URL.");
            return url;
        }
        String processedUrl = ClientUtil.processResourceId(url, params);
        if (!processedUrl.contains("?") && !params.isEmpty()) {
            processedUrl = processedUrl + "?";
        } else if (processedUrl.contains("?") && !params.isEmpty() && !processedUrl.endsWith("?") && !processedUrl.endsWith("&")) {
            processedUrl = processedUrl + "&";
        }
        String finalUrl = processedUrl + ClientUtil.buildQueryString(params);
        logger.debug("Request parameters added to URL : \"{}\".", (Object)finalUrl);
        return finalUrl;
    }

    private static String processResourceId(String url, Map<String, ?> params) {
        String resourceIdStr = "resourceId";
        if (params.containsKey(resourceIdStr)) {
            String resourceId = params.get(resourceIdStr) instanceof List ? (String)((List)params.get(resourceIdStr)).get(0) : (String)params.get(resourceIdStr);
            resourceId = resourceId.replaceAll(REMOVE_WHITE_SPACE_PATTERN, "").trim();
            logger.debug("Resource ID found from parameters map. Resource ID value : \"{}\".", (Object)resourceId);
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + resourceId;
            params.remove(resourceIdStr);
            logger.debug("Resource ID added to URL : \"{}\".", (Object)url);
        }
        return url;
    }

    private static String buildQueryString(Map<String, ?> params) {
        StringBuilder paramsString = new StringBuilder();
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            if (entry.getValue() instanceof List) {
                for (String value : (List)entry.getValue()) {
                    ClientUtil.processParameter(paramsString, entry.getKey(), value);
                }
                continue;
            }
            ClientUtil.processParameter(paramsString, entry.getKey(), (String)entry.getValue());
        }
        return paramsString.toString();
    }

    private static void processParameter(StringBuilder paramsString, String name, String value) {
        if (paramsString.length() > 0) {
            paramsString.append("&");
        }
        value = value.replaceAll(REMOVE_WHITE_SPACE_PATTERN, "").trim();
        paramsString.append(name).append("=").append(value);
        logger.debug("Parameter : \"{}\"=\"{}\"", (Object)name, (Object)value);
    }
}

