/*
 * Decompiled with CFR 0.152.
 */
package com.pkrete.xrd4j.rest.converter;

import com.pkrete.xrd4j.rest.converter.Converter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLToJSONConverter
implements Converter {
    private static final String ARRAY = "array";
    private static final Logger logger = LoggerFactory.getLogger(XMLToJSONConverter.class);

    @Override
    public String convert(String data) {
        logger.debug("CONVERTING " + data);
        try {
            JSONObject asJson = XML.toJSONObject((String)data);
            if (asJson.has(ARRAY)) {
                JSONArray jsonArray = asJson.getJSONArray(ARRAY);
                logger.debug("RETURN ARRAY " + jsonArray.toString());
                return jsonArray.toString();
            }
            this.normalizeObject(asJson);
            String jsonStr = asJson.toString();
            jsonStr = jsonStr.replaceAll("\"__at__(.+?\"\\s*:)", "\"@$1");
            logger.debug("NORMALIZED TO " + jsonStr);
            return jsonStr;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.warn("Converting XML to JSON failed! An empty String is returned.");
            return "";
        }
    }

    protected JSONObject normalizeObject(JSONObject obj) {
        logger.debug("NORM: " + obj.toString());
        for (String key : JSONObject.getNames((JSONObject)obj)) {
            JSONObject subtree = obj.optJSONObject(key);
            if (subtree == null) continue;
            if (subtree.has(ARRAY)) {
                JSONArray subarray = subtree.getJSONArray(ARRAY);
                obj.put(key, (Object)subarray);
                logger.debug("recurse with {}: {}", (Object)key, (Object)subtree.toString());
            }
            this.normalizeObject(subtree);
        }
        return obj;
    }
}

