/*
 * Decompiled with CFR 0.152.
 */
package com.pkrete.xrd4j.rest.converter;

import com.pkrete.xrd4j.rest.converter.Converter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONToXMLConverter
implements Converter {
    private static final Logger logger = LoggerFactory.getLogger(JSONToXMLConverter.class);

    @Override
    public String convert(String data) {
        try {
            String asXML;
            logger.debug("CONVERTING " + data);
            if (data.startsWith("{")) {
                JSONObject asJson = new JSONObject(data);
                if (asJson.has("array")) {
                    logger.error("Data violation: Invalid key \"array\"");
                    return "<error>Invalid key \"array\"</error>";
                }
                asXML = XML.toString((Object)asJson);
            } else {
                asXML = XML.toString((Object)new JSONArray(data));
            }
            asXML = asXML.replaceAll("<(/{0,1})@", "<$1__at__");
            logger.debug("RETURN XML " + asXML);
            return asXML;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.warn("Converting JSON to XML failed! An empty string is returned.");
            return "";
        }
    }
}

