/*
 * Decompiled with CFR 0.152.
 */
package com.pkrete.xrd4j.rest.client;

import com.pkrete.xrd4j.rest.client.DeleteClient;
import com.pkrete.xrd4j.rest.client.GetClient;
import com.pkrete.xrd4j.rest.client.PostClient;
import com.pkrete.xrd4j.rest.client.PutClient;
import com.pkrete.xrd4j.rest.client.RESTClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(RESTClientFactory.class);

    private RESTClientFactory() {
    }

    public static RESTClient createRESTClient(String httpVerb) {
        if (httpVerb == null || httpVerb.isEmpty()) {
            logger.warn("HTTP verb can't be null or empty. Null is returned.");
            return null;
        }
        logger.trace("Create new REST client.");
        if ("get".equalsIgnoreCase(httpVerb)) {
            logger.debug("New GET client created.");
            return new GetClient();
        }
        if ("post".equalsIgnoreCase(httpVerb)) {
            logger.debug("New POST client created.");
            return new PostClient();
        }
        if ("put".equalsIgnoreCase(httpVerb)) {
            logger.debug("New PUT client created.");
            return new PutClient();
        }
        if ("delete".equalsIgnoreCase(httpVerb)) {
            logger.debug("New DELETE client created.");
            return new DeleteClient();
        }
        logger.warn("Unable to create a new REST client. Invalid HTTP verb : \"{}\". Null is returned.", (Object)httpVerb);
        return null;
    }
}

