/*
 * Decompiled with CFR 0.152.
 */
package com.pkrete.xrd4j.rest.client;

import com.pkrete.xrd4j.rest.ClientResponse;
import com.pkrete.xrd4j.rest.client.RESTClient;
import com.pkrete.xrd4j.rest.util.ClientUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements RESTClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractClient.class);

    protected abstract HttpUriRequest buildtHttpRequest(String var1, String var2, Map<String, String> var3);

    @Override
    public ClientResponse send(String url, String requestBody, Map<String, ?> params, Map<String, String> headers) {
        url = ClientUtil.buildTargetURL(url, params);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpUriRequest request = this.buildtHttpRequest(url, requestBody, headers);
        logger.info("Starting HTTP {} operation.", (Object)request.getMethod());
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                logger.debug("Add header : \"{}\" = \"{}\"", (Object)entry.getKey(), (Object)entry.getValue());
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            CloseableHttpResponse response = httpClient.execute(request);
            Header[] contentTypeHeader = response.getHeaders("Content-Type");
            String contentType = null;
            if (contentTypeHeader != null && contentTypeHeader.length > 0) {
                contentType = contentTypeHeader[0].getValue();
            }
            int statusCode = response.getStatusLine().getStatusCode();
            String reasonPhrase = response.getStatusLine().getReasonPhrase();
            String responseStr = ClientUtil.getResponseString(response.getEntity());
            response.close();
            httpClient.close();
            logger.debug("REST response content type: \"{}\".", (Object)contentType);
            logger.debug("REST response status code: \"{}\".", (Object)statusCode);
            logger.debug("REST response reason phrase: \"{}\".", (Object)reasonPhrase);
            logger.debug("REST response : \"{}\".", (Object)responseStr);
            logger.info("HTTP {} operation completed.", (Object)request.getMethod());
            return new ClientResponse(responseStr, contentType, statusCode, reasonPhrase);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.warn("HTTP {} operation failed. An empty string is returned.", (Object)request.getMethod());
            return null;
        }
    }
}

