/*
 * Decompiled with CFR 0.152.
 */
package com.pkrete.xrd4j.rest.client;

import com.pkrete.xrd4j.rest.client.AbstractClient;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBodyHandler
extends AbstractClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBodyHandler.class);

    protected StringEntity buildRequestEntity(String requestBody, Map<String, String> headers) {
        String contentTypeHeader = "Content-Type";
        logger.debug("Build new request entity.");
        if (requestBody != null && !requestBody.isEmpty()) {
            logger.debug("Request body found.");
            String reqContentType = "application/xml";
            if (headers != null && !headers.isEmpty()) {
                if (headers.get(contentTypeHeader) != null && !headers.get(contentTypeHeader).isEmpty()) {
                    reqContentType = headers.get(contentTypeHeader);
                } else {
                    logger.warn("\"Content-Type\" header is missing. Use \"application/xml\" as default.");
                    headers.put(contentTypeHeader, reqContentType);
                }
            }
            return new StringEntity(requestBody, ContentType.create((String)reqContentType, (Charset)Consts.UTF_8));
        }
        logger.debug("No request body found for request. Null is returned");
        return null;
    }
}

