/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.rule.engine.core.api;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000eJ\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0002J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u000eJ\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010$\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010%\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000eJ\f\u0010&\u001a\u00020\u000e*\u00020\u000eH\u0002R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig;", "", "indentStyle", "Lorg/ec4j/core/model/PropertyType$IndentStyleValue;", "tabWidth", "", "(Lorg/ec4j/core/model/PropertyType$IndentStyleValue;I)V", "Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig$IndentStyle;", "(Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig$IndentStyle;I)V", "disabled", "", "getDisabled", "()Z", "indent", "", "getIndent", "()Ljava/lang/String;", "indentChar", "", "getIndentStyle", "()Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig$IndentStyle;", "getTabWidth", "()I", "unexpectedIndentChar", "unexpectedIndentCharDescription", "getUnexpectedIndentCharDescription", "childIndentOf", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "containsUnexpectedIndentChar", "indentText", "getTextAfterLastNewLine", "text", "indentLevelFrom", "indexOfFirstUnexpectedIndentChar", "parentIndentOf", "siblingIndentOf", "toNormalizedIndent", "replaceTabWithSpaces", "Companion", "IndentStyle", "ktlint-rule-engine-core"})
@SourceDebugExtension(value={"SMAP\nIndentConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndentConfig.kt\ncom/pinterest/ktlint/rule/engine/core/api/IndentConfig\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,172:1\n163#2,6:173\n151#2,6:179\n*S KotlinDebug\n*F\n+ 1 IndentConfig.kt\ncom/pinterest/ktlint/rule/engine/core/api/IndentConfig\n*L\n126#1:173,6\n154#1:179,6\n*E\n"})
public final class IndentConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndentStyle indentStyle;
    private final int tabWidth;
    private final char indentChar;
    private final char unexpectedIndentChar;
    @NotNull
    private final String indent;
    @NotNull
    private final String unexpectedIndentCharDescription;
    @NotNull
    private static final Regex TABS_AND_SPACES = new Regex("[ \t]*");
    @NotNull
    private static final IndentConfig DEFAULT_INDENT_CONFIG = new IndentConfig(IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY().getDefaultValue(), ((Number)IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY().getDefaultValue()).intValue());

    public IndentConfig(@NotNull IndentStyle indentStyle, int tabWidth) {
        String string;
        String string2;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)((Object)indentStyle), (String)"indentStyle");
        this.indentStyle = indentStyle;
        this.tabWidth = tabWidth;
        switch (WhenMappings.$EnumSwitchMapping$1[this.indentStyle.ordinal()]) {
            case 1: {
                n2 = 9;
                break;
            }
            case 2: {
                n2 = 32;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.indentChar = (char)n2;
        switch (WhenMappings.$EnumSwitchMapping$1[this.indentStyle.ordinal()]) {
            case 1: {
                n = 32;
                break;
            }
            case 2: {
                n = 9;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.unexpectedIndentChar = (char)n;
        if (this.getDisabled()) {
            string2 = "";
        } else {
            switch (WhenMappings.$EnumSwitchMapping$1[this.indentStyle.ordinal()]) {
                case 1: {
                    string2 = String.valueOf(this.indentChar);
                    break;
                }
                case 2: {
                    string2 = StringsKt.repeat((CharSequence)String.valueOf(this.indentChar), (int)this.tabWidth);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        this.indent = string2;
        switch (WhenMappings.$EnumSwitchMapping$1[this.indentStyle.ordinal()]) {
            case 2: {
                string = "tab";
                break;
            }
            case 1: {
                string = "space";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.unexpectedIndentCharDescription = string;
    }

    @NotNull
    public final IndentStyle getIndentStyle() {
        return this.indentStyle;
    }

    public final int getTabWidth() {
        return this.tabWidth;
    }

    public IndentConfig(@NotNull PropertyType.IndentStyleValue indentStyle, int tabWidth) {
        IndentStyle indentStyle2;
        Intrinsics.checkNotNullParameter((Object)indentStyle, (String)"indentStyle");
        switch (WhenMappings.$EnumSwitchMapping$0[indentStyle.ordinal()]) {
            case 1: {
                indentStyle2 = IndentStyle.TAB;
                break;
            }
            case 2: {
                indentStyle2 = IndentStyle.SPACE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this(indentStyle2, tabWidth);
    }

    public final boolean getDisabled() {
        return this.tabWidth <= 0;
    }

    @NotNull
    public final String getIndent() {
        return this.indent;
    }

    @NotNull
    public final String childIndentOf(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return ASTNodeExtensionKt.indent$default(node, false, 1, null) + this.indent;
    }

    @NotNull
    public final String siblingIndentOf(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.parentIndentOf(node) + this.indent;
    }

    @NotNull
    public final String parentIndentOf(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ASTNode aSTNode = node.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getTreeParent(...)");
        return ASTNodeExtensionKt.indent$default(aSTNode, false, 1, null);
    }

    @NotNull
    public final String toNormalizedIndent(@NotNull String text) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String indent = this.getTextAfterLastNewLine(text);
        CharSequence charSequence = indent;
        if (!TABS_AND_SPACES.matches(charSequence)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$1[this.indentStyle.ordinal()]) {
            case 2: {
                string = this.replaceTabWithSpaces(indent);
                break;
            }
            case 1: {
                string = StringsKt.repeat((CharSequence)"\t", (int)this.indentLevelFrom(indent));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String getTextAfterLastNewLine(String text) {
        String string;
        int index;
        block4: {
            int n;
            CharSequence $this$indexOfLast$iv = text;
            boolean $i$f$indexOfLast = false;
            int n2 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n2) {
                do {
                    int index$iv = n2--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it == '\n')) continue;
                    n = index$iv;
                    break block4;
                } while (0 <= n2);
            }
            n = index = -1;
        }
        if (index == -1) {
            string = text;
        } else {
            String string2 = text.substring(index + 1, text.length());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        String indent = string;
        return indent;
    }

    private final String replaceTabWithSpaces(String $this$replaceTabWithSpaces) {
        return StringsKt.replace$default((String)$this$replaceTabWithSpaces, (String)"\t", (String)StringsKt.repeat((CharSequence)" ", (int)this.tabWidth), (boolean)false, (int)4, null);
    }

    public final int indentLevelFrom(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String indent = this.getTextAfterLastNewLine(text);
        CharSequence charSequence = indent;
        if (!TABS_AND_SPACES.matches(charSequence)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.replaceTabWithSpaces(indent).length() / this.tabWidth;
    }

    public final boolean containsUnexpectedIndentChar(@NotNull String indentText) {
        Intrinsics.checkNotNullParameter((Object)indentText, (String)"indentText");
        return StringsKt.contains$default((CharSequence)indentText, (char)this.unexpectedIndentChar, (boolean)false, (int)2, null);
    }

    public final int indexOfFirstUnexpectedIndentChar(@NotNull String indentText) {
        int n;
        block1: {
            Intrinsics.checkNotNullParameter((Object)indentText, (String)"indentText");
            CharSequence $this$indexOfFirst$iv = indentText;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it == this.unexpectedIndentChar)) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        return n;
    }

    @NotNull
    public final String getUnexpectedIndentCharDescription() {
        return this.unexpectedIndentCharDescription;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndentConfig)) {
            return false;
        }
        IndentConfig indentConfig = (IndentConfig)other;
        if (this.indentStyle != indentConfig.indentStyle) {
            return false;
        }
        return this.tabWidth == indentConfig.tabWidth;
    }

    public int hashCode() {
        int result = this.indentStyle.hashCode();
        result = result * 31 + this.tabWidth;
        return result;
    }

    @NotNull
    public String toString() {
        return "IndentConfig(indentStyle=" + (Object)((Object)this.indentStyle) + ", tabWidth=" + this.tabWidth + ')';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig$Companion;", "", "()V", "DEFAULT_INDENT_CONFIG", "Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig;", "getDEFAULT_INDENT_CONFIG", "()Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig;", "TABS_AND_SPACES", "Lkotlin/text/Regex;", "ktlint-rule-engine-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IndentConfig getDEFAULT_INDENT_CONFIG() {
            return DEFAULT_INDENT_CONFIG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig$IndentStyle;", "", "(Ljava/lang/String;I)V", "SPACE", "TAB", "ktlint-rule-engine-core"})
    public static final class IndentStyle
    extends Enum<IndentStyle> {
        public static final /* enum */ IndentStyle SPACE = new IndentStyle();
        public static final /* enum */ IndentStyle TAB = new IndentStyle();
        private static final /* synthetic */ IndentStyle[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static IndentStyle[] values() {
            return (IndentStyle[])$VALUES.clone();
        }

        public static IndentStyle valueOf(String value) {
            return Enum.valueOf(IndentStyle.class, value);
        }

        @NotNull
        public static EnumEntries<IndentStyle> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = indentStyleArray = new IndentStyle[]{IndentStyle.SPACE, IndentStyle.TAB};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PropertyType.IndentStyleValue.values().length];
            try {
                nArray[PropertyType.IndentStyleValue.tab.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PropertyType.IndentStyleValue.space.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IndentStyle.values().length];
            try {
                nArray[IndentStyle.TAB.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentStyle.SPACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

