/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.internal;

import com.pinterest.ktlint.cli.internal.CodeStyleValueConverter;
import com.pinterest.ktlint.cli.internal.GenerateEditorConfigSubCommand;
import com.pinterest.ktlint.cli.internal.GenerateEditorConfigSubCommandKt;
import com.pinterest.ktlint.cli.internal.KtlintCommandLine;
import com.pinterest.ktlint.cli.internal.KtlintVersionProvider;
import com.pinterest.ktlint.cli.internal.PrintCommandLineHelpOrVersionUsageKt;
import com.pinterest.ktlint.rule.engine.api.EditorConfigOverride;
import com.pinterest.ktlint.rule.engine.api.KtLintRuleEngine;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleValue;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=KtlintVersionProvider.class, mixinStandardHelpOptions=true, description={"Generate kotlin style section for '.editorconfig' file. Output should be copied manually to the '.editorconfig' file."})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/pinterest/ktlint/cli/internal/GenerateEditorConfigSubCommand;", "Ljava/lang/Runnable;", "()V", "codeStyle", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;", "getCodeStyle", "()Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;", "setCodeStyle", "(Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;)V", "commandSpec", "Lpicocli/CommandLine$Model$CommandSpec;", "ktlintCommand", "Lcom/pinterest/ktlint/cli/internal/KtlintCommandLine;", "run", "", "Companion", "ktlint-cli"})
public final class GenerateEditorConfigSubCommand
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @CommandLine.Parameters(description={"Code style to be used when generating the '.editorconfig'. Value should be one of 'ktlint_official' (recommended), 'intellij_idea' or 'android_studio'."}, arity="1", paramLabel="code-style", converter={CodeStyleValueConverter.class})
    @Nullable
    private CodeStyleValue codeStyle;
    @CommandLine.ParentCommand
    private KtlintCommandLine ktlintCommand;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec commandSpec;
    @NotNull
    public static final String COMMAND_NAME = "generateEditorConfig";

    @Nullable
    public final CodeStyleValue getCodeStyle() {
        return this.codeStyle;
    }

    public final void setCodeStyle(@Nullable CodeStyleValue codeStyleValue) {
        this.codeStyle = codeStyleValue;
    }

    @Override
    public void run() {
        CommandLine.Model.CommandSpec commandSpec = this.commandSpec;
        if (commandSpec == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandSpec");
            commandSpec = null;
        }
        CommandLine commandLine = commandSpec.commandLine();
        Intrinsics.checkNotNullExpressionValue((Object)commandLine, (String)"commandLine(...)");
        PrintCommandLineHelpOrVersionUsageKt.printCommandLineHelpOrVersionUsage$default(commandLine, 0, 1, null);
        KtlintCommandLine ktlintCommandLine = this.ktlintCommand;
        if (ktlintCommandLine == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ktlintCommand");
            ktlintCommandLine = null;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY(), (Object)this.codeStyle)};
        KtLintRuleEngine ktLintRuleEngine = new KtLintRuleEngine(ktlintCommandLine.ruleProviders$ktlint_cli(), null, EditorConfigOverride.Companion.from(pairArray), true, null, 18, null);
        Path path2 = Paths.get(".", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        String generatedEditorConfig = ktLintRuleEngine.generateKotlinEditorConfigSection(path2);
        if (!StringsKt.isBlank((CharSequence)generatedEditorConfig)) {
            System.out.println((Object)("[*.{kt,kts}]\n" + generatedEditorConfig));
        } else {
            GenerateEditorConfigSubCommandKt.access$getLOGGER$p().info((Function0)run.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pinterest/ktlint/cli/internal/GenerateEditorConfigSubCommand$Companion;", "", "()V", "COMMAND_NAME", "", "ktlint-cli"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

