/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.reporter.html;

import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.cli.reporter.core.api.ReporterV2;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0016\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u0016\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u0016\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u0016\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u0016\u0010\u001b\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0016\u0010\u001f\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\f\u0010 \u001a\u00020\b*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/pinterest/ktlint/cli/reporter/html/HtmlReporter;", "Lcom/pinterest/ktlint/cli/reporter/core/api/ReporterV2;", "out", "Ljava/io/PrintStream;", "<init>", "(Ljava/io/PrintStream;)V", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "issueCount", "", "correctedCount", "onLintError", "", "file", "ktlintCliError", "afterAll", "html", "body", "Lkotlin/Function0;", "head", "h1", "h3", "text", "value", "ul", "item", "cssLink", "link", "paragraph", "escapeHTMLAttrValue", "ktlint-cli-reporter-html"})
@SourceDebugExtension(value={"SMAP\nHtmlReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlReporter.kt\ncom/pinterest/ktlint/cli/reporter/html/HtmlReporter\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,163:1\n72#2,2:164\n1#3:166\n1869#4,2:167\n216#5,2:169\n*S KotlinDebug\n*F\n+ 1 HtmlReporter.kt\ncom/pinterest/ktlint/cli/reporter/html/HtmlReporter\n*L\n46#1:164,2\n46#1:166\n81#1:167,2\n78#1:169,2\n*E\n"})
public final class HtmlReporter
implements ReporterV2 {
    @NotNull
    private final PrintStream out;
    @NotNull
    private final ConcurrentHashMap<String, List<KtlintCliError>> acc;
    private int issueCount;
    private int correctedCount;

    public HtmlReporter(@NotNull PrintStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
        this.acc = new ConcurrentHashMap();
    }

    public void onLintError(@NotNull String file, @NotNull KtlintCliError ktlintCliError) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)ktlintCliError, (String)"ktlintCliError");
        if (ktlintCliError.getStatus() != KtlintCliError.Status.FORMAT_IS_AUTOCORRECTED) {
            ++this.issueCount;
            ConcurrentMap $this$getOrPut$iv = this.acc;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(file);
            if (object == null) {
                boolean bl = false;
                List default$iv = new ArrayList();
                boolean bl2 = false;
                object = $this$getOrPut$iv.putIfAbsent(file, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            ((List)object).add(ktlintCliError);
        } else {
            ++this.correctedCount;
        }
    }

    public void afterAll() {
        this.html((Function0<Unit>)((Function0)() -> HtmlReporter.afterAll$lambda$12(this)));
    }

    private final void html(Function0<Unit> body) {
        this.out.println("<html>");
        body.invoke();
        this.out.println("</html>");
    }

    private final void head(Function0<Unit> body) {
        this.out.println("<head>");
        body.invoke();
        this.out.println("</head>");
    }

    private final void body(Function0<Unit> body) {
        this.out.println("<body>");
        body.invoke();
        this.out.println("</body>");
    }

    private final void h1(Function0<Unit> body) {
        this.out.print("<h1>");
        body.invoke();
        this.out.println("</h1>");
    }

    private final void h3(Function0<Unit> body) {
        this.out.print("<h3>");
        body.invoke();
        this.out.println("</h3>");
    }

    private final void text(String value) {
        this.out.print(value);
    }

    private final void ul(Function0<Unit> body) {
        this.out.println("<ul>");
        body.invoke();
        this.out.println("</ul>");
    }

    private final void item(String value) {
        this.out.print("<li>");
        this.text(this.escapeHTMLAttrValue(value));
        this.out.println("</li>");
    }

    private final void cssLink(String link) {
        this.out.print("<link href=\"");
        this.out.print(link);
        this.out.println("\" rel=\"stylesheet\" />");
    }

    private final void paragraph(Function0<Unit> body) {
        this.out.print("<p>");
        body.invoke();
        this.out.println("</p>");
    }

    private final String escapeHTMLAttrValue(String $this$escapeHTMLAttrValue) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeHTMLAttrValue, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"\"", (String)"&quot;", (boolean)false, (int)4, null), (String)"'", (String)"&apos;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null);
    }

    public void beforeAll() {
        ReporterV2.DefaultImpls.beforeAll((ReporterV2)this);
    }

    public void before(@NotNull String file) {
        ReporterV2.DefaultImpls.before((ReporterV2)this, (String)file);
    }

    public void after(@NotNull String file) {
        ReporterV2.DefaultImpls.after((ReporterV2)this, (String)file);
    }

    private static final Unit afterAll$lambda$12$lambda$1(HtmlReporter this$0) {
        this$0.cssLink("https://fonts.googleapis.com/css?family=Source+Code+Pro");
        this$0.text("<meta http-equiv=\"Content-Type\" Content=\"text/html; Charset=UTF-8\">" + System.lineSeparator());
        this$0.text("<style>" + System.lineSeparator());
        this$0.text("body {" + System.lineSeparator());
        this$0.text("    font-family: 'Source Code Pro', monospace;" + System.lineSeparator());
        this$0.text('}' + System.lineSeparator());
        this$0.text("h3 {" + System.lineSeparator());
        this$0.text("    font-size: 12pt;" + System.lineSeparator());
        this$0.text("}");
        this$0.text("</style>" + System.lineSeparator());
        return Unit.INSTANCE;
    }

    private static final Unit afterAll$lambda$12$lambda$11$lambda$2(HtmlReporter this$0) {
        this$0.text("Overview");
        return Unit.INSTANCE;
    }

    private static final Unit afterAll$lambda$12$lambda$11$lambda$3(HtmlReporter this$0) {
        this$0.text("Issues found: " + this$0.issueCount);
        return Unit.INSTANCE;
    }

    private static final Unit afterAll$lambda$12$lambda$11$lambda$4(HtmlReporter this$0) {
        this$0.text("Issues corrected: " + this$0.correctedCount);
        return Unit.INSTANCE;
    }

    private static final Unit afterAll$lambda$12$lambda$11$lambda$9$lambda$5(HtmlReporter this$0, String $file) {
        this$0.text($file);
        return Unit.INSTANCE;
    }

    private static final Unit afterAll$lambda$12$lambda$11$lambda$9$lambda$8(List $ktlintCliErrors, HtmlReporter this$0) {
        Iterable $this$forEach$iv = $ktlintCliErrors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtlintCliError err = (KtlintCliError)element$iv;
            boolean bl = false;
            KtlintCliError $this$afterAll_u24lambda_u2412_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246 = err;
            boolean bl2 = false;
            this$0.item("" + '(' + $this$afterAll_u24lambda_u2412_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246.getLine() + ", " + $this$afterAll_u24lambda_u2412_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246.getCol() + "): " + $this$afterAll_u24lambda_u2412_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246.getDetail() + "  (" + $this$afterAll_u24lambda_u2412_u24lambda_u2411_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246.getRuleId() + ')');
        }
        return Unit.INSTANCE;
    }

    private static final Unit afterAll$lambda$12$lambda$11$lambda$10(HtmlReporter this$0) {
        this$0.text("Congratulations, no issues found!");
        return Unit.INSTANCE;
    }

    private static final Unit afterAll$lambda$12$lambda$11(HtmlReporter this$0) {
        if (!this$0.acc.isEmpty()) {
            this$0.h1((Function0<Unit>)((Function0)() -> HtmlReporter.afterAll$lambda$12$lambda$11$lambda$2(this$0)));
            this$0.paragraph((Function0<Unit>)((Function0)() -> HtmlReporter.afterAll$lambda$12$lambda$11$lambda$3(this$0)));
            this$0.paragraph((Function0<Unit>)((Function0)() -> HtmlReporter.afterAll$lambda$12$lambda$11$lambda$4(this$0)));
            Map $this$forEach$iv = this$0.acc;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String file = (String)entry.getKey();
                List ktlintCliErrors = (List)entry.getValue();
                this$0.h3((Function0<Unit>)((Function0)() -> HtmlReporter.afterAll$lambda$12$lambda$11$lambda$9$lambda$5(this$0, file)));
                this$0.ul((Function0<Unit>)((Function0)() -> HtmlReporter.afterAll$lambda$12$lambda$11$lambda$9$lambda$8(ktlintCliErrors, this$0)));
            }
        } else {
            this$0.paragraph((Function0<Unit>)((Function0)() -> HtmlReporter.afterAll$lambda$12$lambda$11$lambda$10(this$0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit afterAll$lambda$12(HtmlReporter this$0) {
        this$0.head((Function0<Unit>)((Function0)() -> HtmlReporter.afterAll$lambda$12$lambda$1(this$0)));
        this$0.body((Function0<Unit>)((Function0)() -> HtmlReporter.afterAll$lambda$12$lambda$11(this$0)));
        return Unit.INSTANCE;
    }
}

