/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.reporter.format;

import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.cli.reporter.core.api.ReporterV2;
import com.pinterest.ktlint.cli.reporter.format.Color;
import com.pinterest.ktlint.cli.reporter.format.FormatReporterKt;
import java.io.File;
import java.io.PrintStream;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\f\u0010\u0018\u001a\u00020\r*\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/pinterest/ktlint/cli/reporter/format/FormatReporter;", "Lcom/pinterest/ktlint/cli/reporter/core/api/ReporterV2;", "out", "Ljava/io/PrintStream;", "format", "", "shouldColorOutput", "outputColor", "Lcom/pinterest/ktlint/cli/reporter/format/Color;", "<init>", "(Ljava/io/PrintStream;ZZLcom/pinterest/ktlint/cli/reporter/format/Color;)V", "countAutoCorrectPossibleOrDone", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "countCanNotBeAutoCorrected", "onLintError", "", "file", "ktlintCliError", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "after", "colorFileName", "fileName", "colored", "ktlint-cli-reporter-format"})
public final class FormatReporter
implements ReporterV2 {
    @NotNull
    private final PrintStream out;
    private final boolean format;
    private final boolean shouldColorOutput;
    @NotNull
    private final Color outputColor;
    @NotNull
    private final ConcurrentHashMap<String, Integer> countAutoCorrectPossibleOrDone;
    @NotNull
    private final ConcurrentHashMap<String, Integer> countCanNotBeAutoCorrected;

    public FormatReporter(@NotNull PrintStream out, boolean format, boolean shouldColorOutput, @NotNull Color outputColor) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)((Object)outputColor), (String)"outputColor");
        this.out = out;
        this.format = format;
        this.shouldColorOutput = shouldColorOutput;
        this.outputColor = outputColor;
        this.countAutoCorrectPossibleOrDone = new ConcurrentHashMap();
        this.countCanNotBeAutoCorrected = new ConcurrentHashMap();
    }

    public /* synthetic */ FormatReporter(PrintStream printStream, boolean bl, boolean bl2, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            color = Color.DARK_GRAY;
        }
        this(printStream, bl, bl2, color);
    }

    public void onLintError(@NotNull String file, @NotNull KtlintCliError ktlintCliError) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)ktlintCliError, (String)"ktlintCliError");
        switch (WhenMappings.$EnumSwitchMapping$0[ktlintCliError.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                this.countAutoCorrectPossibleOrDone.putIfAbsent(file, 0);
                Integer n = this.countAutoCorrectPossibleOrDone.replace(file, ((Number)this.countAutoCorrectPossibleOrDone.getOrDefault(file, 0)).intValue() + 1);
                break;
            }
            default: {
                this.countCanNotBeAutoCorrected.putIfAbsent(file, 0);
                Integer n = this.countCanNotBeAutoCorrected.replace(file, ((Number)this.countCanNotBeAutoCorrected.getOrDefault(file, 0)).intValue() + 1);
            }
        }
    }

    public void after(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Integer n = this.countCanNotBeAutoCorrected.getOrDefault(file, 0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
        int canNotBeAutocorrected = ((Number)n).intValue();
        String result = canNotBeAutocorrected == 1 ? (this.format ? "Format not completed (1 violation needs manual fixing)" : "Format required (1 violation needs manual fixing)") : (canNotBeAutocorrected > 1 ? (this.format ? "Format not completed (" + canNotBeAutocorrected + " violations need manual fixing)" : "Format required (" + canNotBeAutocorrected + " violations need manual fixing)") : (((Number)this.countAutoCorrectPossibleOrDone.getOrDefault(file, 0)).intValue() > 0 ? (this.format ? "Format completed (all violations have been fixed)" : "Format required (all violations can be autocorrected)") : "Format not needed (no violations found)"));
        this.out.println(this.colorFileName(file) + this.colored(":") + ' ' + result);
    }

    private final String colorFileName(String fileName) {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String name = StringsKt.substringAfterLast$default((String)fileName, (String)string, null, (int)2, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = fileName.substring(0, fileName.length() - name.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return stringBuilder.append(this.colored(string2)).append(name).toString();
    }

    private final String colored(String $this$colored) {
        return this.shouldColorOutput ? FormatReporterKt.color($this$colored, this.outputColor) : $this$colored;
    }

    public void beforeAll() {
        super.beforeAll();
    }

    public void before(@NotNull String file) {
        super.before(file);
    }

    public void afterAll() {
        super.afterAll();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KtlintCliError.Status.values().length];
            try {
                nArray[KtlintCliError.Status.LINT_CAN_BE_AUTOCORRECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtlintCliError.Status.FORMAT_IS_AUTOCORRECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

