/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.reporter.format;

import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.cli.reporter.core.api.ReporterV2;
import com.pinterest.ktlint.cli.reporter.format.Color;
import com.pinterest.ktlint.cli.reporter.format.FormatReporterKt;
import java.io.File;
import java.io.PrintStream;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0017\u001a\u00020\f*\u00020\fH\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/pinterest/ktlint/cli/reporter/format/FormatReporter;", "Lcom/pinterest/ktlint/cli/reporter/core/api/ReporterV2;", "out", "Ljava/io/PrintStream;", "format", "", "shouldColorOutput", "outputColor", "Lcom/pinterest/ktlint/cli/reporter/format/Color;", "(Ljava/io/PrintStream;ZZLcom/pinterest/ktlint/cli/reporter/format/Color;)V", "countAutoCorrectPossibleOrDone", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "countCanNotBeAutoCorrected", "after", "", "file", "colorFileName", "fileName", "onLintError", "ktlintCliError", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "colored", "ktlint-cli-reporter-format"})
public final class FormatReporter
implements ReporterV2 {
    @NotNull
    private final PrintStream out;
    private final boolean format;
    private final boolean shouldColorOutput;
    @NotNull
    private final Color outputColor;
    @NotNull
    private final ConcurrentHashMap<String, Integer> countAutoCorrectPossibleOrDone;
    @NotNull
    private final ConcurrentHashMap<String, Integer> countCanNotBeAutoCorrected;

    public FormatReporter(@NotNull PrintStream out, boolean format, boolean shouldColorOutput, @NotNull Color outputColor) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)((Object)outputColor), (String)"outputColor");
        this.out = out;
        this.format = format;
        this.shouldColorOutput = shouldColorOutput;
        this.outputColor = outputColor;
        this.countAutoCorrectPossibleOrDone = new ConcurrentHashMap();
        this.countCanNotBeAutoCorrected = new ConcurrentHashMap();
    }

    public /* synthetic */ FormatReporter(PrintStream printStream, boolean bl, boolean bl2, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            color = Color.DARK_GRAY;
        }
        this(printStream, bl, bl2, color);
    }

    public void onLintError(@NotNull String file, @NotNull KtlintCliError ktlintCliError) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)ktlintCliError, (String)"ktlintCliError");
        switch (WhenMappings.$EnumSwitchMapping$0[ktlintCliError.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                this.countAutoCorrectPossibleOrDone.putIfAbsent(file, 0);
                this.countAutoCorrectPossibleOrDone.replace(file, ((Number)this.countAutoCorrectPossibleOrDone.getOrDefault(file, 0)).intValue() + 1);
                break;
            }
            default: {
                this.countCanNotBeAutoCorrected.putIfAbsent(file, 0);
                this.countCanNotBeAutoCorrected.replace(file, ((Number)this.countCanNotBeAutoCorrected.getOrDefault(file, 0)).intValue() + 1);
            }
        }
    }

    public void after(@NotNull String file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Integer n = this.countCanNotBeAutoCorrected.getOrDefault(file, 0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
        int canNotBeAutocorrected = ((Number)n).intValue();
        if (canNotBeAutocorrected == 1) {
            string = this.format ? "Format not completed (1 violation needs manual fixing)" : "Format required (1 violation needs manual fixing)";
        } else if (canNotBeAutocorrected > 1) {
            string = this.format ? "Format not completed (" + canNotBeAutocorrected + " violations need manual fixing)" : "Format required (" + canNotBeAutocorrected + " violations need manual fixing)";
        } else {
            Integer n2 = this.countAutoCorrectPossibleOrDone.getOrDefault(file, 0);
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getOrDefault(...)");
            string = ((Number)n2).intValue() > 0 ? (this.format ? "Format completed (all violations have been fixed)" : "Format required (all violations can be autocorrected)") : "Format not needed (no violations found)";
        }
        String result = string;
        this.out.println(this.colorFileName(file) + this.colored(":") + ' ' + result);
    }

    private final String colorFileName(String fileName) {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String name = StringsKt.substringAfterLast$default((String)fileName, (String)string, null, (int)2, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = fileName.substring(0, fileName.length() - name.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return stringBuilder.append(this.colored(string2)).append(name).toString();
    }

    private final String colored(String $this$colored) {
        return this.shouldColorOutput ? FormatReporterKt.color($this$colored, this.outputColor) : $this$colored;
    }

    public void afterAll() {
        ReporterV2.DefaultImpls.afterAll((ReporterV2)this);
    }

    public void before(@NotNull String file) {
        ReporterV2.DefaultImpls.before((ReporterV2)this, (String)file);
    }

    public void beforeAll() {
        ReporterV2.DefaultImpls.beforeAll((ReporterV2)this);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KtlintCliError.Status.values().length];
            try {
                nArray[KtlintCliError.Status.LINT_CAN_BE_AUTOCORRECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtlintCliError.Status.FORMAT_IS_AUTOCORRECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

