/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.internal;

import com.pinterest.ktlint.cli.internal.GitHookInstallerKt;
import com.pinterest.ktlint.cli.internal.KtlintCommandLineKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0006H\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\u001c\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010J\b\u0010\u0011\u001a\u00020\u0006H\u0002J\u0014\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u000b0\u000b*\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/pinterest/ktlint/cli/internal/GitHookInstaller;", "", "()V", "backupExistingHook", "", "hooksDir", "Ljava/io/File;", "hookFile", "expectedHookContent", "", "gitHookName", "", "getGitDir", "getHooksDirName", "installGitHook", "hookContentProvider", "Lkotlin/Function0;", "resolveGitHooksDir", "toUniqueId", "kotlin.jvm.PlatformType", "ktlint-cli"})
@SourceDebugExtension(value={"SMAP\nGitHookInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHookInstaller.kt\ncom/pinterest/ktlint/cli/internal/GitHookInstaller\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class GitHookInstaller {
    @NotNull
    public static final GitHookInstaller INSTANCE = new GitHookInstaller();

    private GitHookInstaller() {
    }

    public final void installGitHook(@NotNull String gitHookName, @NotNull Function0<byte[]> hookContentProvider) {
        File file;
        Intrinsics.checkNotNullParameter((Object)gitHookName, (String)"gitHookName");
        Intrinsics.checkNotNullParameter(hookContentProvider, (String)"hookContentProvider");
        try {
            file = this.resolveGitHooksDir();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            KtlintCommandLineKt.exitKtLintProcess(1);
            throw new KotlinNothingValueException();
        }
        File gitHooksDir = file;
        File gitHookFile = FilesKt.resolve((File)gitHooksDir, (String)gitHookName);
        byte[] hookContent = (byte[])hookContentProvider.invoke();
        if (gitHookFile.exists()) {
            this.backupExistingHook(gitHooksDir, gitHookFile, hookContent, gitHookName);
        }
        FilesKt.writeBytes((File)gitHookFile, (byte[])hookContent);
        gitHookFile.setExecutable(true);
        GitHookInstallerKt.access$getLOGGER$p().info((Function0)new Function0<Object>(gitHookFile){
            final /* synthetic */ File $gitHookFile;
            {
                this.$gitHookFile = $gitHookFile;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$gitHookFile.getPath() + " is installed. Be aware that this hook assumes to find ktlint on the PATH. Either ensure that ktlint is actually added to the path or expand the ktlint command in the hook with the path.";
            }
        });
    }

    private final File resolveGitHooksDir() throws IOException {
        String gitHooksDirName;
        File gitDir = this.getGitDir();
        File hooksDir = FilesKt.resolve((File)gitDir, (String)(gitHooksDirName = this.getHooksDirName()));
        if (!hooksDir.exists() && !hooksDir.mkdir()) {
            throw new IOException("Failed to create " + hooksDir.getPath() + " folder");
        }
        return hooksDir;
    }

    private final File getGitDir() {
        File file;
        try {
            InputStream inputStream = Runtime.getRuntime().exec("git rev-parse --show-toplevel").getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getRuntime().exec(\"git r\u2026             .inputStream");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            String root = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))))).toString();
            file = FilesKt.resolve((File)new File(root), (String)".git");
        }
        catch (IOException _) {
            file = new File(".git");
        }
        File gitDir = file;
        if (!gitDir.isDirectory()) {
            throw new IOException(".git directory not found. Are you sure you are inside project directory?");
        }
        return gitDir;
    }

    private final String getHooksDirName() {
        Object object;
        try {
            Object object2;
            InputStream inputStream = Runtime.getRuntime().exec("git config --get core.hooksPath").getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getRuntime().exec(\"git c\u2026             .inputStream");
            object = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader((InputStream)object, charset);
            int n = 8192;
            object = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))))).toString();
            if (object.length() == 0) {
                boolean bl = false;
                object2 = "hooks";
            } else {
                object2 = object;
            }
            object = (String)object2;
        }
        catch (IOException _) {
            object = "hooks";
        }
        return object;
    }

    private final void backupExistingHook(File hooksDir, File hookFile, byte[] expectedHookContent, String gitHookName) {
        byte[] actualHookContent = FilesKt.readBytes((File)hookFile);
        if (!(actualHookContent.length == 0) && !Arrays.equals(actualHookContent, expectedHookContent)) {
            File backupFile = FilesKt.resolve((File)hooksDir, (String)(gitHookName + ".ktlint-backup." + this.toUniqueId(actualHookContent)));
            GitHookInstallerKt.access$getLOGGER$p().info((Function0)new Function0<Object>(hookFile, backupFile){
                final /* synthetic */ File $hookFile;
                final /* synthetic */ File $backupFile;
                {
                    this.$hookFile = $hookFile;
                    this.$backupFile = $backupFile;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Existing git hook " + this.$hookFile.getPath() + " is copied to " + this.$backupFile.getPath();
                }
            });
            FilesKt.copyTo$default((File)hookFile, (File)backupFile, (boolean)true, (int)0, (int)4, null);
        }
    }

    private final String toUniqueId(byte[] $this$toUniqueId) {
        byte[] it = MessageDigest.getInstance("SHA-256").digest($this$toUniqueId);
        boolean bl = false;
        return new BigInteger(it).toString(16);
    }
}

