/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint;

import com.pinterest.ktlint.KtlintCommandLine;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.ParseException;
import com.pinterest.ktlint.core.Reporter;
import com.pinterest.ktlint.core.ReporterProvider;
import com.pinterest.ktlint.core.RuleExecutionException;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.core.RuleSetProvider;
import com.pinterest.ktlint.internal.FileUtilsKt;
import com.pinterest.ktlint.internal.IntellijIDEAIntegration;
import com.pinterest.ktlint.internal.KtlintVersionProvider;
import com.pinterest.ktlint.internal.MavenDependencyResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.transfer.TransferEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(headerHeading="An anti-bikeshedding Kotlin linter with built-in formatter\n(https://github.com/pinterest/ktlint).\n\nUsage:\n  ktlint <flags> [patterns]\n  java -jar ktlint <flags> [patterns]\n\nExamples:\n  # check the style of all Kotlin files inside the current dir (recursively)\n  # (hidden folders will be skipped)\n  ktlint\n\n  # check only certain locations (prepend ! to negate the pattern)\n  ktlint \"src/**/*.kt\" \"!src/**/*Test.kt\"\n\n  # auto-correct style violations\n  ktlint -F \"src/**/*.kt\"\n\n  # custom reporter\n  ktlint --reporter=plain?group_by_file\n  # multiple reporters can be specified like this\n  ktlint --reporter=plain \\\n    --reporter=checkstyle,output=ktlint-checkstyle-report.xml\n  # 3rd-party reporter\n  ktlint --reporter=html,artifact=com.github.user:repo:master-SNAPSHOT\n\nFlags:", synopsisHeading="", customSynopsis={""}, sortOptions=false, mixinStandardHelpOptions=true, versionProvider=KtlintVersionProvider.class)
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u000200H\u0002J$\u00101\u001a\u00020.2\f\u00102\u001a\b\u0012\u0004\u0012\u000200032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001205H\u0002J$\u00106\u001a\u0002072\f\u00102\u001a\b\u0012\u0004\u0012\u000200032\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000409H\u0002J\u001c\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120;2\u0006\u0010<\u001a\u00020\u0012H\u0002J\u0006\u0010=\u001a\u00020.J\u001a\u0010>\u001a\u00020.*\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020B0AH\u0002J&\u0010C\u001a\b\u0012\u0004\u0012\u0002HD05\"\u0004\b\u0000\u0010D*\b\u0012\u0004\u0012\u0002HD052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\f\u0010E\u001a\u00020.*\u00020FH\u0002J<\u0010G\u001a\u00020.\"\u0004\b\u0000\u0010D*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HD0I0H2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u0002HD\u0012\u0004\u0012\u00020.0K2\b\b\u0002\u0010L\u001a\u00020\u001eH\u0002J\u0010\u0010M\u001a\u00020N*\u00060Oj\u0002`PH\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\bR\u001e\u0010\u000e\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\bR\u001e\u0010\u0011\u001a\u00020\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001d\u001a\u00020\u001e8B@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\"8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0006\"\u0004\b%\u0010\bR\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120\"8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120\"8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b(\u0010\u0002R\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00120\"8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010*\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010+\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010,\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/pinterest/ktlint/KtlintCommandLine;", "", "()V", "android", "", "getAndroid", "()Z", "setAndroid", "(Z)V", "apply", "applyToProject", "color", "getColor", "setColor", "debug", "getDebug", "setDebug", "disabledRules", "", "getDisabledRules", "()Ljava/lang/String;", "setDisabledRules", "(Ljava/lang/String;)V", "editorConfigPath", "experimental", "forceApply", "forceUpdate", "Ljava/lang/Boolean;", "format", "limit", "", "getLimit", "()I", "patterns", "Ljava/util/ArrayList;", "relative", "getRelative", "setRelative", "reporters", "repositories", "repositories$annotations", "rulesets", "skipClasspathCheck", "stdin", "verbose", "applyToIDEA", "", "buildDependencyResolver", "Lcom/pinterest/ktlint/internal/MavenDependencyResolver;", "loadJARs", "dependencyResolver", "Lkotlin/Lazy;", "artifacts", "", "loadReporter", "Lcom/pinterest/ktlint/core/Reporter;", "tripped", "Lkotlin/Function0;", "parseQuery", "Ljava/util/LinkedHashMap;", "query", "run", "addURLs", "Ljava/net/URLClassLoader;", "url", "", "Ljava/net/URL;", "head", "T", "mkdirsOrFail", "Ljava/io/File;", "parallel", "Lkotlin/sequences/Sequence;", "Ljava/util/concurrent/Callable;", "cb", "Lkotlin/Function1;", "numberOfThreads", "toLintError", "Lcom/pinterest/ktlint/core/LintError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "ktlint"})
public final class KtlintCommandLine {
    @CommandLine.Option(names={"--android", "-a"}, description={"Turn on Android Kotlin Style Guide compatibility"})
    private boolean android;
    @CommandLine.Option(names={"--apply-to-idea"}, description={"Update Intellij IDEA settings (global)"})
    private boolean apply;
    @CommandLine.Option(names={"--apply-to-idea-project"}, description={"Update Intellij IDEA project settings"})
    private boolean applyToProject;
    @CommandLine.Option(names={"--color"}, description={"Make output colorful"})
    private boolean color;
    @CommandLine.Option(names={"--debug"}, description={"Turn on debug output"})
    private boolean debug;
    @CommandLine.Option(names={"--disabled_rules"}, description={"Comma-separated list of rules to globally disable"})
    @NotNull
    private String disabledRules = "";
    @CommandLine.Option(names={"--format", "-F"}, description={"Fix any deviations from the code style"})
    private boolean format;
    @CommandLine.Option(names={"--limit"}, description={"Maximum number of errors to show (default: show all)"})
    private int limit = -1;
    @CommandLine.Option(names={"--relative"}, description={"Print files relative to the working directory (e.g. dir/file.kt instead of /home/user/project/dir/file.kt)"})
    private boolean relative;
    @CommandLine.Option(names={"--reporter"}, description={"A reporter to use (built-in: plain (default), plain?group_by_file, json, checkstyle). To use a third-party reporter specify a path to a JAR file on the filesystem."})
    private ArrayList<String> reporters = new ArrayList();
    @CommandLine.Option(names={"--repository"}, description={"An additional Maven repository (Maven Central/JCenter/JitPack are active by default) (value format: <id>=<url>)"}, hidden=true)
    private ArrayList<String> repositories = new ArrayList();
    @CommandLine.Option(names={"--repository-update", "-U"}, description={"Check remote repositories for updated snapshots"})
    private Boolean forceUpdate;
    @CommandLine.Option(names={"--ruleset", "-R"}, description={"A path to a JAR file containing additional ruleset(s)"})
    private ArrayList<String> rulesets = new ArrayList();
    @CommandLine.Option(names={"--skip-classpath-check"}, description={"Do not check classpath for potential conflicts"})
    private boolean skipClasspathCheck;
    @CommandLine.Option(names={"--stdin"}, description={"Read file from stdin"})
    private boolean stdin;
    @CommandLine.Option(names={"--verbose", "-v"}, description={"Show error codes"})
    private boolean verbose;
    @CommandLine.Option(names={"-y"}, hidden=true)
    private boolean forceApply;
    @CommandLine.Option(names={"--editorconfig"}, description={"Path to .editorconfig"})
    private String editorConfigPath;
    @CommandLine.Option(names={"--experimental"}, description={"Enabled experimental rules (ktlint-ruleset-experimental)"})
    private boolean experimental;
    @CommandLine.Parameters(hidden=true)
    private ArrayList<String> patterns = new ArrayList();

    public final boolean getAndroid() {
        return this.android;
    }

    public final void setAndroid(boolean bl) {
        this.android = bl;
    }

    public final boolean getColor() {
        return this.color;
    }

    public final void setColor(boolean bl) {
        this.color = bl;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    @NotNull
    public final String getDisabledRules() {
        return this.disabledRules;
    }

    public final void setDisabledRules(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.disabledRules = string;
    }

    private final int getLimit() {
        return this.limit < 0 ? Integer.MAX_VALUE : this.limit;
    }

    public final boolean getRelative() {
        return this.relative;
    }

    public final void setRelative(boolean bl) {
        this.relative = bl;
    }

    @Deprecated(message="See https://github.com/pinterest/ktlint/issues/451")
    private static /* synthetic */ void repositories$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public final void run() {
        boolean bl;
        void fileNumber;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Object object;
        Object object2;
        Object object3;
        Iterable $this$mapTo$iv$iv;
        if (this.apply || this.applyToProject) {
            this.applyToIDEA();
            int n = 0;
            boolean bl2 = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        long start = System.currentTimeMillis();
        Lazy dependencyResolver2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<MavenDependencyResolver>(this){
            final /* synthetic */ KtlintCommandLine this$0;

            @NotNull
            public final MavenDependencyResolver invoke() {
                return KtlintCommandLine.access$buildDependencyResolver(this.this$0);
            }
            {
                this.this$0 = ktlintCommandLine;
                super(0);
            }
        }));
        if (!this.rulesets.isEmpty()) {
            this.loadJARs((Lazy<MavenDependencyResolver>)dependencyResolver2, (List<String>)this.rulesets);
        }
        ServiceLoader<com.github.shyiko.ktlint.core.RuleSetProvider> serviceLoader = ServiceLoader.load(com.github.shyiko.ktlint.core.RuleSetProvider.class);
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"ServiceLoader.load(com.g\u2026eSetProvider::class.java)");
        if (CollectionsKt.any((Iterable)serviceLoader)) {
            System.err.println("[ERROR] Cannot load custom ruleset!");
            System.err.println("[ERROR] RuleSetProvider has moved to com.pinterest.ktlint.core.");
            System.err.println("[ERROR] Please rename META-INF/services/com.github.shyiko.ktlint.core.RuleSetProvider to META-INF/services/com.pinterest.ktlint.core.RuleSetProvider");
            int n = 1;
            boolean bl3 = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        ServiceLoader<RuleSetProvider> serviceLoader2 = ServiceLoader.load(RuleSetProvider.class);
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader2, (String)"ServiceLoader.load(RuleSetProvider::class.java)");
        Iterable $this$map$iv = serviceLoader2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object3 = (RuleSetProvider)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl4 = false;
            object = TuplesKt.to((Object)it.get().getId(), (Object)it);
            object2.add(object);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            Pair $dstr$id = (Pair)element$iv$iv;
            boolean bl5 = false;
            String id = (String)$dstr$id.component1();
            if (!(this.experimental || Intrinsics.areEqual((Object)id, (Object)"experimental") ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$filterTo$iv$iv = $this$sortedBy$iv;
        boolean destination$iv$iv2 = false;
        Comparator $i$f$filterTo22 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)a;
                boolean bl2 = false;
                String string = Intrinsics.areEqual((Object)((String)it.getFirst()), (Object)"standard") ? '\u0000' + (String)it.getFirst() : (String)it.getFirst();
                it = (Pair)b;
                Comparable comparable = (Comparable)((Object)string);
                bl2 = false;
                String string2 = Intrinsics.areEqual((Object)((String)it.getFirst()), (Object)"standard") ? '\u0000' + (String)it.getFirst() : (String)it.getFirst();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
            }
        };
        List ruleSetProviders = CollectionsKt.sortedWith((Iterable)$this$filterTo$iv$iv, (Comparator)$i$f$filterTo22);
        if (this.debug) {
            Iterable $this$forEach$iv = ruleSetProviders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it22 = (Pair)element$iv;
                boolean bl6 = false;
                System.err.println("[DEBUG] Discovered ruleset \"" + (String)it22.getFirst() + '\"');
            }
        }
        AtomicBoolean tripped = new AtomicBoolean();
        Reporter reporter2 = this.loadReporter((Lazy<MavenDependencyResolver>)dependencyResolver2, (Function0<Boolean>)((Function0)new Function0<Boolean>(tripped){
            final /* synthetic */ AtomicBoolean $tripped;

            public final boolean invoke() {
                return this.$tripped.get();
            }
            {
                this.$tripped = atomicBoolean;
                super(0);
            }
        }));
        Object[] objectArray = new Pair[2];
        objectArray[0] = TuplesKt.to((Object)"android", (Object)String.valueOf(this.android));
        CharSequence element$iv = this.disabledRules;
        int n = 1;
        object = objectArray;
        object2 = objectArray;
        boolean it22 = false;
        boolean bl7 = !StringsKt.isBlank((CharSequence)element$iv);
        object[n] = bl7 ? TuplesKt.to((Object)"disabled_rules", (Object)this.disabledRules) : null;
        Map userData = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])object2));
        Function2<String, String, List<? extends run.LintErrorWithCorrectionInfo>> $fun$process$2 = new Function2<String, String, List<? extends run.LintErrorWithCorrectionInfo>>(this, ruleSetProviders, userData, tripped){
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ List $ruleSetProviders;
            final /* synthetic */ Map $userData;
            final /* synthetic */ AtomicBoolean $tripped;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<run.LintErrorWithCorrectionInfo> invoke(@NotNull String fileName, @NotNull String fileContent) {
                Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
                Intrinsics.checkParameterIsNotNull((Object)fileContent, (String)"fileContent");
                if (this.this$0.getDebug()) {
                    String fileLocation = Intrinsics.areEqual((Object)fileName, (Object)"<stdin>") ^ true ? FileUtilsKt.location(new File(fileName), this.this$0.getRelative()) : fileName;
                    System.err.println("[DEBUG] Checking " + fileLocation);
                }
                @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000%\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"com/pinterest/ktlint/KtlintCommandLine$run$LintErrorWithCorrectionInfo", "", "err", "Lcom/pinterest/ktlint/core/LintError;", "corrected", "", "(Lcom/pinterest/ktlint/core/LintError;Z)V", "getCorrected", "()Z", "getErr", "()Lcom/pinterest/ktlint/core/LintError;", "component1", "component2", "copy", "(Lcom/pinterest/ktlint/core/LintError;Z)Lcom/pinterest/ktlint/KtlintCommandLine$run$LintErrorWithCorrectionInfo;", "equals", "other", "hashCode", "", "toString", "", "ktlint"})
                public final class LintErrorWithCorrectionInfo {
                    @NotNull
                    private final LintError err;
                    private final boolean corrected;

                    @NotNull
                    public final LintError getErr() {
                        return this.err;
                    }

                    public final boolean getCorrected() {
                        return this.corrected;
                    }

                    public LintErrorWithCorrectionInfo(@NotNull LintError err, boolean corrected) {
                        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                        this.err = err;
                        this.corrected = corrected;
                    }

                    @NotNull
                    public final LintError component1() {
                        return this.err;
                    }

                    public final boolean component2() {
                        return this.corrected;
                    }

                    @NotNull
                    public final LintErrorWithCorrectionInfo copy(@NotNull LintError err, boolean corrected) {
                        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                        return new LintErrorWithCorrectionInfo(err, corrected);
                    }

                    public static /* synthetic */ LintErrorWithCorrectionInfo copy$default(LintErrorWithCorrectionInfo lintErrorWithCorrectionInfo, LintError lintError, boolean bl, int n, Object object) {
                        if ((n & 1) != 0) {
                            lintError = lintErrorWithCorrectionInfo.err;
                        }
                        if ((n & 2) != 0) {
                            bl = lintErrorWithCorrectionInfo.corrected;
                        }
                        return lintErrorWithCorrectionInfo.copy(lintError, bl);
                    }

                    @NotNull
                    public String toString() {
                        return "LintErrorWithCorrectionInfo(err=" + this.err + ", corrected=" + this.corrected + ")";
                    }

                    public int hashCode() {
                        LintError lintError = this.err;
                        int n = (lintError != null ? lintError.hashCode() : 0) * 31;
                        int n2 = (int)(this.corrected ? 1 : 0);
                        if (n2 != 0) {
                            n2 = 1;
                        }
                        return n + n2;
                    }

                    public boolean equals(@Nullable Object object) {
                        block3: {
                            block2: {
                                if (this == object) break block2;
                                if (!(object instanceof LintErrorWithCorrectionInfo)) break block3;
                                LintErrorWithCorrectionInfo lintErrorWithCorrectionInfo = (LintErrorWithCorrectionInfo)object;
                                if (!Intrinsics.areEqual((Object)this.err, (Object)lintErrorWithCorrectionInfo.err) || !(this.corrected == lintErrorWithCorrectionInfo.corrected)) break block3;
                            }
                            return true;
                        }
                        return false;
                    }
                }
                ArrayList<LintErrorWithCorrectionInfo> result = new ArrayList<LintErrorWithCorrectionInfo>();
                if (KtlintCommandLine.access$getFormat$p(this.this$0)) {
                    Object object;
                    String $this$map$iv2;
                    Object object2;
                    String string;
                    try {
                        void $this$mapTo$iv$iv;
                        Iterable iterable = this.$ruleSetProviders;
                        string = fileContent;
                        object2 = fileName;
                        boolean $i$f$map = false;
                        void var7_14 = $this$map$iv2;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv2), (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv2 : $this$mapTo$iv$iv) {
                            void it;
                            Pair pair = (Pair)item$iv$iv2;
                            object = destination$iv$iv;
                            boolean bl = false;
                            RuleSet ruleSet = ((RuleSetProvider)it.getSecond()).get();
                            object.add(ruleSet);
                        }
                        object = (List)destination$iv$iv;
                        $this$map$iv2 = FileUtilsKt.formatFile((String)object2, string, (Iterable)object, this.$userData, KtlintCommandLine.access$getEditorConfigPath$p(this.this$0), this.this$0.getDebug(), (Function2<? super LintError, ? super Boolean, Unit>)((Function2)new Function2<LintError, Boolean, Unit>(this, result){
                            final /* synthetic */ run.2 this$0;
                            final /* synthetic */ ArrayList $result;

                            public final void invoke(@NotNull LintError err, boolean corrected) {
                                Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                                if (!corrected) {
                                    this.$result.add(new LintErrorWithCorrectionInfo(err, corrected));
                                    this.this$0.$tripped.set(true);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$result = arrayList;
                                super(2);
                            }
                        }));
                    }
                    catch (Exception e) {
                        result.add(new LintErrorWithCorrectionInfo(KtlintCommandLine.access$toLintError(this.this$0, e), false));
                        this.$tripped.set(true);
                        $this$map$iv2 = fileContent;
                    }
                    String formattedFileContent2 = $this$map$iv2;
                    if (KtlintCommandLine.access$getStdin$p(this.this$0)) {
                        boolean $this$map$iv2 = false;
                        System.out.print((Object)formattedFileContent2);
                    } else if (fileContent != formattedFileContent2) {
                        $this$map$iv2 = "UTF-8";
                        string = formattedFileContent2;
                        object2 = new File(fileName);
                        boolean e = false;
                        Charset charset = Charset.forName($this$map$iv2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                        object = charset;
                        FilesKt.writeText((File)object2, (String)string, (Charset)object);
                    }
                } else {
                    try {
                        Collection<RuleSet> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable formattedFileContent2 = this.$ruleSetProviders;
                        String string = fileContent;
                        String string2 = fileName;
                        boolean $i$f$map = false;
                        void e = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Pair item$iv$iv2 = (Pair)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            RuleSet ruleSet = ((RuleSetProvider)it.getSecond()).get();
                            collection.add(ruleSet);
                        }
                        collection = (List)destination$iv$iv;
                        FileUtilsKt.lintFile(string2, string, (List<RuleSet>)collection, this.$userData, KtlintCommandLine.access$getEditorConfigPath$p(this.this$0), this.this$0.getDebug(), (Function1<? super LintError, Unit>)((Function1)new Function1<LintError, Unit>(this, result){
                            final /* synthetic */ run.2 this$0;
                            final /* synthetic */ ArrayList $result;

                            public final void invoke(@NotNull LintError err) {
                                Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                                this.$result.add(new LintErrorWithCorrectionInfo(err, false));
                                this.this$0.$tripped.set(true);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$result = arrayList;
                                super(1);
                            }
                        }));
                    }
                    catch (Exception e) {
                        result.add(new LintErrorWithCorrectionInfo(KtlintCommandLine.access$toLintError(this.this$0, e), false));
                        this.$tripped.set(true);
                    }
                }
                return result;
            }
            {
                this.this$0 = ktlintCommandLine;
                this.$ruleSetProviders = list;
                this.$userData = map;
                this.$tripped = atomicBoolean;
                super(2);
            }
        };
        element$iv$iv = new Pair((Object)new AtomicInteger(), (Object)new AtomicInteger());
        AtomicInteger it22 = (AtomicInteger)element$iv$iv.component1();
        AtomicInteger errorNumber = (AtomicInteger)element$iv$iv.component2();
        Function2<String, List<? extends run.LintErrorWithCorrectionInfo>, Unit> $fun$report$3 = new Function2<String, List<? extends run.LintErrorWithCorrectionInfo>, Unit>(this, (AtomicInteger)fileNumber, errorNumber, reporter2){
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ AtomicInteger $fileNumber;
            final /* synthetic */ AtomicInteger $errorNumber;
            final /* synthetic */ Reporter $reporter;

            public final void invoke(@NotNull String fileName, @NotNull List<run.LintErrorWithCorrectionInfo> errList) {
                Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
                Intrinsics.checkParameterIsNotNull(errList, (String)"errList");
                this.$fileNumber.incrementAndGet();
                int n = errList.size();
                int n2 = KtlintCommandLine.access$getLimit$p(this.this$0) - this.$errorNumber.get();
                int n3 = 0;
                boolean bl = false;
                n2 = Math.max(n2, n3);
                n3 = 0;
                int errListLimit = Math.min(n, n2);
                this.$errorNumber.addAndGet(errListLimit);
                this.$reporter.before(fileName);
                Iterable $this$forEach$iv = KtlintCommandLine.access$head(this.this$0, errList, errListLimit);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    LintErrorWithCorrectionInfo $dstr$err$corrected = (LintErrorWithCorrectionInfo)element$iv;
                    boolean bl2 = false;
                    LintError err = $dstr$err$corrected.component1();
                    boolean corrected = $dstr$err$corrected.component2();
                    this.$reporter.onLintError(fileName, !err.getCanBeAutoCorrected() ? LintError.copy$default((LintError)err, (int)0, (int)0, null, (String)(err.getDetail() + " (cannot be auto-corrected)"), (int)7, null) : err, corrected);
                }
                this.$reporter.after(fileName);
            }
            {
                this.this$0 = ktlintCommandLine;
                this.$fileNumber = atomicInteger;
                this.$errorNumber = atomicInteger2;
                this.$reporter = reporter2;
                super(2);
            }
        };
        reporter2.beforeAll();
        if (this.stdin) {
            InputStream inputStream = System.in;
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"System.`in`");
            object3 = ByteStreamsKt.readBytes((InputStream)inputStream);
            String string = "<stdin>";
            Function2<String, String, List<? extends run.LintErrorWithCorrectionInfo>> function2 = $fun$process$2;
            object = "<stdin>";
            object2 = $fun$report$3;
            bl = false;
            String string2 = new String((byte[])object3, Charsets.UTF_8);
            object2.invoke((String)object, function2.invoke(string, string2));
        } else {
            KtlintCommandLine.parallel$default(this, SequencesKt.map((Sequence)SequencesKt.takeWhile(FileUtilsKt.fileSequence((List<String>)this.patterns), (Function1)((Function1)new Function1<File, Boolean>(this, errorNumber){
                final /* synthetic */ KtlintCommandLine this$0;
                final /* synthetic */ AtomicInteger $errorNumber;

                public final boolean invoke(@NotNull File it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$errorNumber.get() < KtlintCommandLine.access$getLimit$p(this.this$0);
                }
                {
                    this.this$0 = ktlintCommandLine;
                    this.$errorNumber = atomicInteger;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<File, Callable<Pair<? extends File, ? extends List<? extends run.LintErrorWithCorrectionInfo>>>>($fun$process$2){
                final /* synthetic */ run.2 $process$2;

                @NotNull
                public final Callable<Pair<File, List<run.LintErrorWithCorrectionInfo>>> invoke(@NotNull File file) {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    return new Callable<Pair<? extends File, ? extends List<? extends run.LintErrorWithCorrectionInfo>>>(this, file){
                        final /* synthetic */ run.5 this$0;
                        final /* synthetic */ File $file;

                        @NotNull
                        public final Pair<File, List<run.LintErrorWithCorrectionInfo>> call() {
                            run.2 v0 = this.this$0.$process$2;
                            String string = this.$file.getPath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
                            return TuplesKt.to((Object)this.$file, v0.invoke(string, FilesKt.readText$default((File)this.$file, null, (int)1, null)));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$file = file;
                        }
                    };
                }
                {
                    this.$process$2 = var1_1;
                    super(1);
                }
            })), (Function1)new Function1<Pair<? extends File, ? extends List<? extends run.LintErrorWithCorrectionInfo>>, Unit>(this, $fun$report$3){
                final /* synthetic */ KtlintCommandLine this$0;
                final /* synthetic */ run.3 $report$3;

                public final void invoke(Pair<? extends File, ? extends List<run.LintErrorWithCorrectionInfo>> $dstr$file$errList) {
                    File file = (File)$dstr$file$errList.component1();
                    List errList = (List)$dstr$file$errList.component2();
                    String string = FileUtilsKt.location(file, this.this$0.getRelative());
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.location(relative)");
                    this.$report$3.invoke(string, errList);
                }
                {
                    this.this$0 = ktlintCommandLine;
                    this.$report$3 = var2_2;
                    super(1);
                }
            }, 0, 2, null);
        }
        reporter2.afterAll();
        if (this.debug) {
            System.err.println("[DEBUG] " + (System.currentTimeMillis() - start) + "ms / " + fileNumber + " file(s) / " + errorNumber + " error(s)");
        }
        if (tripped.get()) {
            int n2 = 1;
            bl = false;
            System.exit(n2);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Reporter loadReporter(Lazy<MavenDependencyResolver> dependencyResolver2, Function0<Boolean> tripped) {
        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000+\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JF\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"com/pinterest/ktlint/KtlintCommandLine$loadReporter$ReporterTemplate", "", "id", "", "artifact", "config", "", "output", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "getArtifact", "()Ljava/lang/String;", "getConfig", "()Ljava/util/Map;", "getId", "getOutput", "setOutput", "(Ljava/lang/String;)V", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)Lcom/pinterest/ktlint/KtlintCommandLine$loadReporter$ReporterTemplate;", "equals", "", "other", "hashCode", "", "toString", "ktlint"})
        public final class ReporterTemplate {
            @NotNull
            private final String id;
            @Nullable
            private final String artifact;
            @NotNull
            private final Map<String, String> config;
            @Nullable
            private String output;

            @NotNull
            public final String getId() {
                return this.id;
            }

            @Nullable
            public final String getArtifact() {
                return this.artifact;
            }

            @NotNull
            public final Map<String, String> getConfig() {
                return this.config;
            }

            @Nullable
            public final String getOutput() {
                return this.output;
            }

            public final void setOutput(@Nullable String string) {
                this.output = string;
            }

            public ReporterTemplate(@NotNull String id, @Nullable String artifact, @NotNull Map<String, String> config, @Nullable String output) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull(config, (String)"config");
                this.id = id;
                this.artifact = artifact;
                this.config = config;
                this.output = output;
            }

            @NotNull
            public final String component1() {
                return this.id;
            }

            @Nullable
            public final String component2() {
                return this.artifact;
            }

            @NotNull
            public final Map<String, String> component3() {
                return this.config;
            }

            @Nullable
            public final String component4() {
                return this.output;
            }

            @NotNull
            public final ReporterTemplate copy(@NotNull String id, @Nullable String artifact, @NotNull Map<String, String> config, @Nullable String output) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                Intrinsics.checkParameterIsNotNull(config, (String)"config");
                return new ReporterTemplate(id, artifact, config, output);
            }

            public static /* synthetic */ ReporterTemplate copy$default(ReporterTemplate reporterTemplate, String string, String string2, Map map, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = reporterTemplate.id;
                }
                if ((n & 2) != 0) {
                    string2 = reporterTemplate.artifact;
                }
                if ((n & 4) != 0) {
                    map = reporterTemplate.config;
                }
                if ((n & 8) != 0) {
                    string3 = reporterTemplate.output;
                }
                return reporterTemplate.copy(string, string2, map, string3);
            }

            @NotNull
            public String toString() {
                return "ReporterTemplate(id=" + this.id + ", artifact=" + this.artifact + ", config=" + this.config + ", output=" + this.output + ")";
            }

            public int hashCode() {
                String string = this.id;
                String string2 = this.artifact;
                Map<String, String> map = this.config;
                String string3 = this.output;
                return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ReporterTemplate)) break block3;
                        ReporterTemplate reporterTemplate = (ReporterTemplate)object;
                        if (!Intrinsics.areEqual((Object)this.id, (Object)reporterTemplate.id) || !Intrinsics.areEqual((Object)this.artifact, (Object)reporterTemplate.artifact) || !Intrinsics.areEqual(this.config, reporterTemplate.config) || !Intrinsics.areEqual((Object)this.output, (Object)reporterTemplate.output)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Object object;
        Object $this$associateTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Object element$iv$iv2;
        void $this$associateTo$iv$iv2;
        ServiceLoader<ReporterProvider> reporterLoader;
        Reporter[] reporterArray;
        Pair pair;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2 = this.reporters.isEmpty() ? CollectionsKt.listOf((Object)"plain") : (List)this.reporters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            String string;
            String string2;
            Map map;
            String string3;
            Object $this$lastOrNull$iv;
            boolean $i$f$lastOrNull;
            block18: {
                String string4;
                String string5;
                String rawReporterConfig;
                List split;
                block17: {
                    void reporterId;
                    void reporter2;
                    String string6 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    split = StringsKt.split$default((CharSequence)((CharSequence)reporter2), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                    Object object2 = new String[]{"?"};
                    boolean bl2 = false;
                    int n = 2;
                    List list = CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)((CharSequence)split.get(0)), (String[])object2, (boolean)bl2, (int)n, (int)2, null), (Iterable)CollectionsKt.listOf((Object)""));
                    object2 = list;
                    bl2 = false;
                    String string7 = (String)object2.get(0);
                    object2 = list;
                    bl2 = false;
                    rawReporterConfig = (String)object2.get(1);
                    list = split;
                    pair = reporterId;
                    $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        String it2 = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.startsWith$default((String)it2, (String)"artifact=", (boolean)false, (int)2, null)) continue;
                        string5 = (String)element$iv;
                        break block17;
                    }
                    string5 = null;
                }
                string3 = string5;
                void v1 = pair;
                String string8 = string3;
                if (string8 != null) {
                    $this$lastOrNull$iv = string8;
                    pair = v1;
                    $i$f$lastOrNull = false;
                    boolean iterator$iv = false;
                    String it3 = $this$lastOrNull$iv;
                    boolean bl = false;
                    string3 = (String)StringsKt.split$default((CharSequence)it3, (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null).get(1);
                    v1 = pair;
                    string4 = string3;
                } else {
                    string4 = null;
                }
                $this$lastOrNull$iv = split;
                map = MapsKt.plus((Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"verbose", (Object)String.valueOf(this.verbose)), TuplesKt.to((Object)"color", (Object)String.valueOf(this.color))}), (Map)this.parseQuery(rawReporterConfig));
                string3 = string4;
                pair = v1;
                $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    String it4 = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it4, (String)"output=", (boolean)false, (int)2, null)) continue;
                    string2 = (String)element$iv;
                    break block18;
                }
                string2 = null;
            }
            String string9 = string2;
            Pair pair2 = pair;
            String string10 = string3;
            Map map2 = map;
            String string11 = string9;
            if (string11 != null) {
                $this$lastOrNull$iv = string11;
                map = map2;
                string3 = string10;
                pair = pair2;
                $i$f$lastOrNull = false;
                boolean iterator$iv = false;
                Object it5 = $this$lastOrNull$iv;
                boolean bl = false;
                string9 = (String)StringsKt.split$default((CharSequence)((CharSequence)it5), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null).get(1);
                pair2 = pair;
                string10 = string3;
                map2 = map;
                string = string9;
            } else {
                string = null;
            }
            String string12 = string;
            Map map3 = map2;
            String string13 = string10;
            void var36_86 = pair2;
            reporterArray = new ReporterTemplate((String)var36_86, string13, map3, string12);
            collection.add(reporterArray);
        }
        List tpls = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        ServiceLoader<ReporterProvider> serviceLoader = reporterLoader = ServiceLoader.load(ReporterProvider.class);
        Intrinsics.checkExpressionValueIsNotNull(serviceLoader, (String)"reporterLoader");
        Object $this$associate$iv = serviceLoader;
        boolean $i$f$associate = false;
        int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Object object3 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv3);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv2 : $this$associateTo$iv$iv2) {
            Map $i$f$lastOrNull = destination$iv$iv2;
            ReporterProvider it6 = (ReporterProvider)element$iv$iv2;
            boolean bl = false;
            it6 = TuplesKt.to((Object)it6.getId(), (Object)it6);
            bl = false;
            $i$f$lastOrNull.put(it6.getFirst(), it6.getSecond());
        }
        $this$associate$iv = destination$iv$iv2;
        $i$f$associate = false;
        capacity$iv3 = 0;
        Object map5 = $this$associate$iv;
        boolean bl12 = false;
        Iterable $this$filter$iv = tpls;
        boolean $i$f$filter = false;
        element$iv$iv2 = $this$filter$iv;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
            it = (ReporterTemplate)element$iv$iv3;
            boolean bl4 = false;
            if (!(!map5.containsKey(((ReporterTemplate)it).getId()))) continue;
            destination$iv$iv3.add(element$iv$iv3);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv3;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv4 = element$iv$iv$iv = it.next();
            boolean bl5 = false;
            ReporterTemplate it7 = (ReporterTemplate)element$iv$iv4;
            boolean bl6 = false;
            if (it7.getArtifact() == null) continue;
            boolean bl7 = false;
            boolean bl8 = false;
            String it$iv$iv = string;
            boolean bl9 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        List missingReporters = CollectionsKt.distinct((Iterable)((List)destination$iv$iv3));
        if (!missingReporters.isEmpty()) {
            this.loadJARs(dependencyResolver2, missingReporters);
            reporterLoader.reload();
            Iterable $this$associate$iv2 = reporterLoader;
            boolean $i$f$associate2 = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
            destination$iv$iv3 = $this$associate$iv2;
            Map destination$iv$iv4 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateTo2 = false;
            Iterator iterator = $this$associateTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv5 = iterator.next();
                Map map4 = destination$iv$iv4;
                ReporterProvider it8 = (ReporterProvider)element$iv$iv5;
                boolean bl10 = false;
                pair = TuplesKt.to((Object)it8.getId(), (Object)it8);
                boolean bl11 = false;
                map4.put(pair.getFirst(), pair.getSecond());
            }
            object = destination$iv$iv4;
        } else {
            object = map5;
        }
        Object reporterProviderById = object;
        if (this.debug) {
            Object $this$forEach$iv = reporterProviderById;
            boolean $i$f$forEach2 = false;
            Object capacity$iv3 = $this$forEach$iv;
            boolean map5 = false;
            Iterator bl12 = capacity$iv3.entrySet().iterator();
            while (bl12.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$id = element$iv = bl12.next();
                boolean bl13 = false;
                $this$associateTo$iv$iv = $dstr$id;
                boolean destination$iv$iv4 = false;
                String id = (String)$this$associateTo$iv$iv.getKey();
                System.err.println("[DEBUG] Discovered reporter \"" + id + '\"');
            }
        }
        Function1<ReporterTemplate, Reporter> $fun$toReporter$2 = new Function1<ReporterTemplate, Reporter>(this, (Map)reporterProviderById, tripped){
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ Map $reporterProviderById;
            final /* synthetic */ Function0 $tripped;

            @NotNull
            public final Reporter invoke(@NotNull ReporterTemplate $this$toReporter) {
                PrintStream stream;
                PrintStream printStream;
                boolean bl;
                ReporterProvider reporterProvider;
                block7: {
                    String string;
                    StringBuilder stringBuilder;
                    PrintStream printStream2;
                    block9: {
                        block8: {
                            Intrinsics.checkParameterIsNotNull((Object)$this$toReporter, (String)"$this$toReporter");
                            reporterProvider = (ReporterProvider)this.$reporterProviderById.get($this$toReporter.getId());
                            if (reporterProvider == null) {
                                System.err.println("Error: reporter \"" + $this$toReporter.getId() + "\" wasn't found (available: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)this.$reporterProviderById.keySet()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')');
                                int n = 1;
                                boolean bl2 = false;
                                System.exit(n);
                                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                            }
                            if (!this.this$0.getDebug()) break block7;
                            printStream2 = System.err;
                            stringBuilder = new StringBuilder().append("[DEBUG] Initializing \"").append($this$toReporter.getId()).append("\" reporter with ").append($this$toReporter.getConfig());
                            string = $this$toReporter.getOutput();
                            if (string == null) break block8;
                            String string2 = string;
                            StringBuilder stringBuilder2 = stringBuilder;
                            PrintStream printStream3 = printStream2;
                            boolean bl3 = false;
                            bl = false;
                            String it = string2;
                            boolean bl4 = false;
                            String string3 = ", output=" + it;
                            printStream2 = printStream3;
                            stringBuilder = stringBuilder2;
                            string = string3;
                            if (string != null) break block9;
                        }
                        string = "";
                    }
                    printStream2.println(stringBuilder.append((Object)string).toString());
                }
                if ($this$toReporter.getOutput() != null) {
                    File file = new File($this$toReporter.getOutput()).getParentFile();
                    if (file != null) {
                        KtlintCommandLine.access$mkdirsOrFail(this.this$0, file);
                    }
                    printStream = new PrintStream($this$toReporter.getOutput(), "UTF-8");
                } else {
                    printStream = KtlintCommandLine.access$getStdin$p(this.this$0) ? System.err : System.out;
                }
                PrintStream printStream4 = stream = printStream;
                Intrinsics.checkExpressionValueIsNotNull((Object)printStream4, (String)"stream");
                Reporter reporter2 = reporterProvider.get(printStream4, $this$toReporter.getConfig());
                bl = false;
                boolean bl5 = false;
                Reporter reporter3 = reporter2;
                boolean bl6 = false;
                return $this$toReporter.getOutput() != null ? (Reporter)new Reporter(reporter3, this, $this$toReporter, stream){
                    private final /* synthetic */ Reporter $$delegate_0;
                    final /* synthetic */ Reporter $reporter;
                    final /* synthetic */ loadReporter.2 this$0;
                    final /* synthetic */ ReporterTemplate $this_toReporter$inlined;
                    final /* synthetic */ PrintStream $stream$inlined;
                    {
                        this.$reporter = $captured_local_variable$1;
                        this.this$0 = var2_2;
                        this.$this_toReporter$inlined = reporterTemplate;
                        this.$stream$inlined = printStream;
                        this.$$delegate_0 = $captured_local_variable$1;
                    }

                    public void afterAll() {
                        this.$reporter.afterAll();
                        this.$stream$inlined.close();
                        if (((Boolean)this.this$0.$tripped.invoke()).booleanValue()) {
                            File file = new File(this.$this_toReporter$inlined.getOutput()).getAbsoluteFile();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File(output).absoluteFile");
                            String outputLocation = FileUtilsKt.location(file, this.this$0.this$0.getRelative());
                            System.err.println('\"' + this.$this_toReporter$inlined.getId() + "\" report written to " + outputLocation);
                        }
                    }

                    public void after(@NotNull String file) {
                        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                        this.$$delegate_0.after(file);
                    }

                    public void before(@NotNull String file) {
                        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                        this.$$delegate_0.before(file);
                    }

                    public void beforeAll() {
                        this.$$delegate_0.beforeAll();
                    }

                    public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
                        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                        Intrinsics.checkParameterIsNotNull((Object)err, (String)"err");
                        this.$$delegate_0.onLintError(file, err, corrected);
                    }
                } : reporter3;
            }
            {
                this.this$0 = ktlintCommandLine;
                this.$reporterProviderById = map;
                this.$tripped = function0;
                super(1);
            }
        };
        Iterable $i$f$forEach2 = tpls;
        collection = Reporter.Companion;
        boolean $i$f$map2 = false;
        void map5 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it9;
            $this$associateTo$iv$iv = (ReporterTemplate)item$iv$iv;
            reporterArray = destination$iv$iv22;
            boolean bl14 = false;
            Reporter reporter3 = $fun$toReporter$2.invoke((ReporterTemplate)it9);
            reporterArray.add(reporter3);
        }
        reporterArray = (List)destination$iv$iv22;
        $this$map$iv = (Collection)reporterArray;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Reporter[] reporterArray2 = thisCollection$iv.toArray(new Reporter[0]);
        if (reporterArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Reporter[] reporterArray3 = reporterArray = reporterArray2;
        return collection.from(Arrays.copyOf(reporterArray3, reporterArray3.length));
    }

    private final LintError toLintError(@NotNull Exception $this$toLintError) {
        LintError lintError;
        Exception exception = $this$toLintError;
        boolean bl = false;
        boolean bl2 = false;
        Exception e = exception;
        boolean bl3 = false;
        Exception exception2 = e;
        if (exception2 instanceof ParseException) {
            String string;
            int n = ((ParseException)e).getLine();
            int n2 = ((ParseException)e).getCol();
            String string2 = "";
            StringBuilder stringBuilder = new StringBuilder().append("Not a valid Kotlin file (");
            String string3 = e.getMessage();
            if (string3 != null) {
                String string4 = string3;
                StringBuilder stringBuilder2 = stringBuilder;
                String string5 = string2;
                int n3 = n2;
                int n4 = n;
                boolean bl4 = false;
                String string6 = string4;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
                String string8 = string7;
                n = n4;
                n2 = n3;
                string2 = string5;
                stringBuilder = stringBuilder2;
                string = string8;
            } else {
                string = null;
            }
            String string9 = stringBuilder.append(string).append(')').toString();
            String string10 = string2;
            int n5 = n2;
            int n6 = n;
            lintError = new LintError(n6, n5, string10, string9);
        } else if (exception2 instanceof RuleExecutionException) {
            if (this.debug) {
                System.err.println("[DEBUG] Internal Error (" + ((RuleExecutionException)e).getRuleId() + ')');
                e.printStackTrace(System.err);
            }
            lintError = new LintError(((RuleExecutionException)e).getLine(), ((RuleExecutionException)e).getCol(), "", "Internal Error (" + ((RuleExecutionException)e).getRuleId() + "). " + "Please create a ticket at https://github.com/pinterest/ktlint/issue " + "(if possible, provide the source code that triggered an error)");
        } else {
            throw (Throwable)e;
        }
        return lintError;
    }

    private final void applyToIDEA() {
        try {
            Path workDir = Paths.get(".", new String[0]);
            if (!this.forceApply) {
                Path path = workDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"workDir");
                Object[] fileList = IntellijIDEAIntegration.INSTANCE.apply(path, true, this.android, this.applyToProject);
                System.err.println("The following files are going to be updated:\n\n\t" + ArraysKt.joinToString$default((Object[])fileList, (CharSequence)"\n\t", null, null, (int)0, null, null, (int)62, null) + "\n\nDo you wish to proceed? [y/n]\n" + "(in future, use -y flag if you wish to skip confirmation)");
                Scanner scanner = new Scanner(System.in);
                String res2 = (String)SequencesKt.first((Sequence)SequencesKt.filter((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<String>(scanner){
                    final /* synthetic */ Scanner $scanner;

                    @Nullable
                    public final String invoke() {
                        String string;
                        try {
                            string = this.$scanner.next();
                        }
                        catch (NoSuchElementException e) {
                            string = null;
                        }
                        return string;
                    }
                    {
                        this.$scanner = scanner;
                        super(0);
                    }
                })), (Function1)applyToIDEA.res.2.INSTANCE));
                if (!StringsKt.equals((String)"y", (String)res2, (boolean)true)) {
                    System.err.println("(update canceled)");
                    int n = 1;
                    boolean bl = false;
                    System.exit(n);
                    throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
            }
            Path path = workDir;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"workDir");
            IntellijIDEAIntegration.INSTANCE.apply(path, false, this.android, this.applyToProject);
        }
        catch (IntellijIDEAIntegration.ProjectNotFoundException e) {
            System.err.println(".idea directory not found. Are you sure you are inside project root directory?");
            int n = 1;
            boolean bl = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        System.err.println("(updated)");
        System.err.println("\nPlease restart your IDE");
        System.err.println("(if you experience any issues please report them at https://github.com/pinterest/ktlint)");
    }

    private final <T> List<T> head(@NotNull List<? extends T> $this$head, int limit) {
        return limit == $this$head.size() ? $this$head : $this$head.subList(0, limit);
    }

    /*
     * WARNING - void declaration
     */
    private final MavenDependencyResolver buildDependencyResolver() {
        Collection<RemoteRepository> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File mavenLocal = new File(new File(System.getProperty("user.home"), ".m2"), "repository");
        this.mkdirsOrFail(mavenLocal);
        Iterable iterable = this.repositories;
        Collection collection2 = CollectionsKt.listOf((Object[])new RemoteRepository[]{new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").setSnapshotPolicy(new RepositoryPolicy(false, "never", "ignore")).build(), new RemoteRepository.Builder("bintray", "default", "https://jcenter.bintray.com").setSnapshotPolicy(new RepositoryPolicy(false, "never", "ignore")).build(), new RemoteRepository.Builder("jitpack", "default", "https://jitpack.io").build()});
        File file = mavenLocal;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String url;
            String id;
            void repository;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            int n = StringsKt.indexOf$default((CharSequence)((CharSequence)repository), (String)"=", (int)0, (boolean)false, (int)6, null);
            boolean bl2 = false;
            int n2 = 0;
            int $this$apply = n;
            boolean bl3 = false;
            if ($this$apply == -1) {
                throw (Throwable)new RuntimeException((String)repository + " is not a valid repository entry " + "(make sure it's provided as <id>=<url>");
            }
            int colon = n;
            void var13_15 = repository;
            n2 = 0;
            int n3 = 0;
            void v0 = var13_15;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)v0.substring(n2, colon), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            void var14_17 = repository;
            n3 = colon + 1;
            boolean bl4 = false;
            void v1 = var14_17;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)v1.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
            RemoteRepository remoteRepository = new RemoteRepository.Builder(id, "default", url).build();
            collection.add(remoteRepository);
        }
        collection = (List)destination$iv$iv;
        boolean bl = Intrinsics.areEqual((Object)this.forceUpdate, (Object)true);
        Iterable iterable2 = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        File file2 = file;
        MavenDependencyResolver dependencyResolver2 = new MavenDependencyResolver(file2, iterable2, bl);
        if (this.debug) {
            dependencyResolver2.setTransferEventListener((Function1<? super TransferEvent, Unit>)((Function1)buildDependencyResolver.1.INSTANCE));
        }
        return dependencyResolver2;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadJARs(Lazy<MavenDependencyResolver> dependencyResolver2, List<String> artifacts) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.URLClassLoader");
        }
        Iterable iterable = artifacts;
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
        KtlintCommandLine ktlintCommandLine = this;
        boolean $i$f$flatMap = false;
        void var5_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            boolean $i$f$mapTo;
            Iterable $this$map$iv;
            String artifact = (String)element$iv$iv;
            boolean bl = false;
            if (this.debug) {
                System.err.println("[DEBUG] Resolving " + artifact);
            }
            try {
                void $this$mapTo$iv$iv;
                $this$map$iv = ((MavenDependencyResolver)dependencyResolver2.getValue()).resolve((Artifact)new DefaultArtifact(artifact));
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    URL uRL = it.toURI().toURL();
                    collection.add(uRL);
                }
                $this$map$iv = (List)destination$iv$iv2;
            }
            catch (IllegalArgumentException e) {
                File file = new File(FileUtilsKt.expandTilde(artifact));
                if (!file.exists()) {
                    System.err.println("Error: " + artifact + " does not exist");
                    int destination$iv$iv2 = 1;
                    $i$f$mapTo = false;
                    System.exit(destination$iv$iv2);
                    throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                $this$map$iv = CollectionsKt.listOf((Object)file.toURI().toURL());
            }
            catch (RepositoryException e) {
                if (this.debug) {
                    e.printStackTrace();
                }
                System.err.println("Error: " + artifact + " wasn't found");
                int n = 1;
                boolean destination$iv$iv2 = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            Iterable result = $this$map$iv;
            if (this.debug) {
                Iterable $this$forEach$iv = result;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    URL url = (URL)element$iv;
                    boolean bl3 = false;
                    System.err.println("[DEBUG] Loading " + url);
                }
            }
            if (!this.skipClasspathCheck) {
                boolean bl4;
                block21: {
                    boolean bl5;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    block20: {
                        $this$any$iv = result;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                URL it = (URL)element$iv;
                                boolean bl6 = false;
                                String string = it.toString();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toString()");
                                if (!StringsKt.startsWith$default((String)StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null), (String)"ktlint-core-", (boolean)false, (int)2, null)) continue;
                                bl5 = true;
                                break block20;
                            }
                            bl5 = false;
                        }
                    }
                    if (bl5) {
                        System.err.println('\"' + artifact + "\" appears to have a runtime/compile dependency on \"ktlint-core\".\n" + "Please inform the author that \"com.pinterest:ktlint*\" should be marked " + "compileOnly (Gradle) / provided (Maven).\n" + "(to suppress this warning use --skip-classpath-check)");
                    }
                    $this$any$iv = result;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            URL it = (URL)element$iv;
                            boolean bl7 = false;
                            String string = it.toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toString()");
                            if (!StringsKt.startsWith$default((String)StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null), (String)"kotlin-stdlib-", (boolean)false, (int)2, null)) continue;
                            bl4 = true;
                            break block21;
                        }
                        bl4 = false;
                    }
                }
                if (bl4) {
                    System.err.println('\"' + artifact + "\" appears to have a runtime/compile dependency on \"kotlin-stdlib\".\n" + "Please inform the author that \"org.jetbrains.kotlin:kotlin-stdlib*\" should be marked " + "compileOnly (Gradle) / provided (Maven).\n" + "(to suppress this warning use --skip-classpath-check)");
                }
            }
            Iterable list$iv$iv = result;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        ktlintCommandLine.addURLs(uRLClassLoader, list);
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedHashMap<String, String> parseQuery(String query) {
        void $this$fold$iv;
        Iterable iterable = StringsKt.split$default((CharSequence)query, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
        LinkedHashMap<String, String> initial$iv = new LinkedHashMap<String, String>();
        boolean $i$f$fold = false;
        LinkedHashMap<String, String> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void s;
            String string = (String)element$iv;
            LinkedHashMap<String, String> map = accumulator$iv;
            boolean bl = false;
            Object object = (String[])s;
            boolean bl2 = false;
            if (!(object.length() == 0)) {
                Object object2;
                object = new String[]{"="};
                bl2 = false;
                int n = 2;
                object = StringsKt.split$default((CharSequence)((CharSequence)s), (String[])object, (boolean)bl2, (int)n, (int)2, null);
                bl2 = false;
                n = 0;
                Object e = object;
                boolean bl3 = false;
                Object object3 = e;
                int n2 = 1;
                Object e2 = e.get(0);
                LinkedHashMap<String, String> linkedHashMap = map;
                boolean bl4 = false;
                if (n2 <= CollectionsKt.getLastIndex((List)object3)) {
                    object2 = object3.get(n2);
                } else {
                    int it = n2;
                    boolean bl5 = false;
                    object2 = "true";
                }
                Object e3 = object2;
                linkedHashMap.put((String)e2, URLDecoder.decode((String)e3, "UTF-8"));
            }
            accumulator$iv = map;
        }
        return accumulator$iv;
    }

    private final void addURLs(@NotNull URLClassLoader $this$addURLs, Iterable<URL> url) {
        Method method;
        Method method2 = method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
        method2.setAccessible(true);
        Iterable<URL> $this$forEach$iv = url;
        boolean $i$f$forEach = false;
        Iterator<URL> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            URL element$iv;
            URL it = element$iv = iterator.next();
            boolean bl = false;
            method.invoke((Object)$this$addURLs, it);
        }
    }

    private final void mkdirsOrFail(@NotNull File $this$mkdirsOrFail) {
        if (!$this$mkdirsOrFail.mkdirs() && !$this$mkdirsOrFail.isDirectory()) {
            throw (Throwable)new IOException("Unable to create \"" + $this$mkdirsOrFail + "\" directory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void parallel(@NotNull Sequence<? extends Callable<T>> $this$parallel, Function1<? super T, Unit> cb, int numberOfThreads) {
        Future pill2 = new Future<T>(){

            public boolean isDone() {
                throw (Throwable)new UnsupportedOperationException();
            }

            public T get(long timeout, @NotNull TimeUnit unit) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
                throw (Throwable)new UnsupportedOperationException();
            }

            public T get() {
                throw (Throwable)new UnsupportedOperationException();
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                throw (Throwable)new UnsupportedOperationException();
            }

            public boolean isCancelled() {
                throw (Throwable)new UnsupportedOperationException();
            }
        };
        ArrayBlockingQueue q = new ArrayBlockingQueue(numberOfThreads);
        Thread producer2 = ThreadsKt.thread$default((boolean)true, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>($this$parallel, q, pill2){
            final /* synthetic */ Sequence $this_parallel;
            final /* synthetic */ ArrayBlockingQueue $q;
            final /* synthetic */ parallel.pill.1 $pill;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                ExecutorService executorService = Executors.newCachedThreadPool();
                try {
                    for (Callable task : this.$this_parallel) {
                        this.$q.put(executorService.submit(task));
                    }
                    this.$q.put(this.$pill);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    executorService.shutdown();
                }
            }
            {
                this.$this_parallel = sequence;
                this.$q = arrayBlockingQueue;
                this.$pill = var3_3;
                super(0);
            }
        }), (int)30, null);
        try {
            Future result;
            while (Intrinsics.areEqual((Object)(result = (Future)q.take()), (Object)pill2) ^ true) {
                cb.invoke(result.get());
            }
        }
        finally {
            producer2.interrupt();
            producer2.join();
        }
    }

    static /* synthetic */ void parallel$default(KtlintCommandLine ktlintCommandLine, Sequence sequence, Function1 function1, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        ktlintCommandLine.parallel(sequence, function1, n);
    }

    public static final /* synthetic */ MavenDependencyResolver access$buildDependencyResolver(KtlintCommandLine $this) {
        return $this.buildDependencyResolver();
    }

    public static final /* synthetic */ boolean access$getFormat$p(KtlintCommandLine $this) {
        return $this.format;
    }

    public static final /* synthetic */ void access$setFormat$p(KtlintCommandLine $this, boolean bl) {
        $this.format = bl;
    }

    public static final /* synthetic */ String access$getEditorConfigPath$p(KtlintCommandLine $this) {
        return $this.editorConfigPath;
    }

    public static final /* synthetic */ void access$setEditorConfigPath$p(KtlintCommandLine $this, String string) {
        $this.editorConfigPath = string;
    }

    public static final /* synthetic */ LintError access$toLintError(KtlintCommandLine $this, Exception $this$access_u24toLintError) {
        return $this.toLintError($this$access_u24toLintError);
    }

    public static final /* synthetic */ boolean access$getStdin$p(KtlintCommandLine $this) {
        return $this.stdin;
    }

    public static final /* synthetic */ void access$setStdin$p(KtlintCommandLine $this, boolean bl) {
        $this.stdin = bl;
    }

    public static final /* synthetic */ int access$getLimit$p(KtlintCommandLine $this) {
        return $this.getLimit();
    }

    public static final /* synthetic */ void access$setLimit$p(KtlintCommandLine $this, int n) {
        $this.limit = n;
    }

    public static final /* synthetic */ List access$head(KtlintCommandLine $this, List $this$access_u24head, int limit) {
        return $this.head($this$access_u24head, limit);
    }

    public static final /* synthetic */ void access$mkdirsOrFail(KtlintCommandLine $this, File $this$access_u24mkdirsOrFail) {
        $this.mkdirsOrFail($this$access_u24mkdirsOrFail);
    }
}

