/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.androidyoutubeplayer.core.player.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.RequiresApi;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.utils.NetworkBroadcastReceiver;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.utils.NetworkObserver;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0003J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/utils/NetworkObserver;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "listeners", "", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/utils/NetworkObserver$Listener;", "getListeners", "()Ljava/util/List;", "networkBroadcastReceiver", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/utils/NetworkBroadcastReceiver;", "networkCallback", "Landroid/net/ConnectivityManager$NetworkCallback;", "observeNetwork", "", "destroy", "doObserveNetwork", "doObserveNetworkLegacy", "Listener", "core_release"})
@SourceDebugExtension(value={"SMAP\nNetworkObserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkObserver.kt\ncom/pierfrancescosoffritti/androidyoutubeplayer/core/player/utils/NetworkObserver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1#2:123\n1863#3,2:124\n1863#3,2:126\n*S KotlinDebug\n*F\n+ 1 NetworkObserver.kt\ncom/pierfrancescosoffritti/androidyoutubeplayer/core/player/utils/NetworkObserver\n*L\n81#1:124,2\n82#1:126,2\n*E\n"})
public final class NetworkObserver {
    @NotNull
    private final Context context;
    @NotNull
    private final List<Listener> listeners;
    @Nullable
    private NetworkBroadcastReceiver networkBroadcastReceiver;
    @Nullable
    private ConnectivityManager.NetworkCallback networkCallback;

    public NetworkObserver(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.listeners = new ArrayList();
    }

    @NotNull
    public final List<Listener> getListeners() {
        return this.listeners;
    }

    public final void observeNetwork() {
        if (Build.VERSION.SDK_INT >= 24) {
            this.doObserveNetwork(this.context);
        } else {
            this.doObserveNetworkLegacy(this.context);
        }
    }

    public final void destroy() {
        if (Build.VERSION.SDK_INT >= 24) {
            ConnectivityManager.NetworkCallback networkCallback = this.networkCallback;
            if (networkCallback == null) {
                return;
            }
            ConnectivityManager.NetworkCallback callback2 = networkCallback;
            Object object = this.context.getSystemService("connectivity");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
            ConnectivityManager connectivityManager = (ConnectivityManager)object;
            connectivityManager.unregisterNetworkCallback(callback2);
        } else {
            Object object;
            NetworkBroadcastReceiver networkBroadcastReceiver = this.networkBroadcastReceiver;
            if (networkBroadcastReceiver == null) {
                return;
            }
            NetworkBroadcastReceiver receiver = networkBroadcastReceiver;
            NetworkObserver networkObserver = this;
            try {
                NetworkObserver $this$destroy_u24lambda_u240 = networkObserver;
                boolean bl = false;
                $this$destroy_u24lambda_u240.context.unregisterReceiver((BroadcastReceiver)receiver);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Result.box-impl((Object)object);
        }
        this.listeners.clear();
        this.networkCallback = null;
        this.networkBroadcastReceiver = null;
    }

    @RequiresApi(value=24)
    private final void doObserveNetwork(Context context) {
        ConnectivityManager.NetworkCallback callback2 = new ConnectivityManager.NetworkCallback(this){
            private final Handler mainThreadHandler;
            final /* synthetic */ NetworkObserver this$0;
            {
                this.this$0 = $receiver;
                this.mainThreadHandler = new Handler(Looper.getMainLooper());
            }

            public void onAvailable(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                this.mainThreadHandler.post(() -> doObserveNetwork.callback.1.onAvailable$lambda$1(this.this$0));
            }

            public void onLost(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                this.mainThreadHandler.post(() -> doObserveNetwork.callback.1.onLost$lambda$3(this.this$0));
            }

            private static final void onAvailable$lambda$1(NetworkObserver this$0) {
                Iterable $this$forEach$iv = this$0.getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Listener it = (Listener)element$iv;
                    boolean bl = false;
                    it.onNetworkAvailable();
                }
            }

            private static final void onLost$lambda$3(NetworkObserver this$0) {
                Iterable $this$forEach$iv = this$0.getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Listener it = (Listener)element$iv;
                    boolean bl = false;
                    it.onNetworkUnavailable();
                }
            }
        };
        this.networkCallback = callback2;
        Object object = context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        connectivityManager.registerDefaultNetworkCallback(callback2);
    }

    private final void doObserveNetworkLegacy(Context context) {
        this.networkBroadcastReceiver = new NetworkBroadcastReceiver((Function0<Unit>)((Function0)() -> NetworkObserver.doObserveNetworkLegacy$lambda$2(this)), (Function0<Unit>)((Function0)() -> NetworkObserver.doObserveNetworkLegacy$lambda$4(this)));
        context.registerReceiver((BroadcastReceiver)this.networkBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    private static final Unit doObserveNetworkLegacy$lambda$2(NetworkObserver this$0) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.onNetworkAvailable();
        }
        return Unit.INSTANCE;
    }

    private static final Unit doObserveNetworkLegacy$lambda$4(NetworkObserver this$0) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.onNetworkUnavailable();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/utils/NetworkObserver$Listener;", "", "onNetworkAvailable", "", "onNetworkUnavailable", "core_release"})
    public static interface Listener {
        public void onNetworkAvailable();

        public void onNetworkUnavailable();
    }
}

