/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.androidyoutubeplayer.core.player;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import androidx.annotation.RestrictTo;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.PlayerConstants;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.YouTubePlayer;
import com.pierfrancescosoffritti.androidyoutubeplayer.core.player.listeners.YouTubePlayerListener;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000 $2\u00020\u0001:\u0002$%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\nH\u0007J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\nH\u0007J\b\u0010\u001a\u001a\u00020\u0015H\u0007J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\nH\u0007J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\nH\u0007J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\nH\u0007J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\nH\u0007J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\nH\u0007J\b\u0010#\u001a\u00020\u0015H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/YouTubePlayerBridge;", "", "youTubePlayerOwner", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/YouTubePlayerBridge$YouTubePlayerBridgeCallbacks;", "(Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/YouTubePlayerBridge$YouTubePlayerBridgeCallbacks;)V", "mainThreadHandler", "Landroid/os/Handler;", "parsePlaybackQuality", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/PlayerConstants$PlaybackQuality;", "quality", "", "parsePlaybackRate", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/PlayerConstants$PlaybackRate;", "rate", "parsePlayerError", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/PlayerConstants$PlayerError;", "error", "parsePlayerState", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/PlayerConstants$PlayerState;", "state", "sendApiChange", "", "sendError", "", "sendPlaybackQualityChange", "sendPlaybackRateChange", "sendReady", "sendStateChange", "sendVideoCurrentTime", "seconds", "sendVideoDuration", "sendVideoId", "videoId", "sendVideoLoadedFraction", "fraction", "sendYouTubeIFrameAPIReady", "Companion", "YouTubePlayerBridgeCallbacks", "core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nYouTubePlayerBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YouTubePlayerBridge.kt\ncom/pierfrancescosoffritti/androidyoutubeplayer/core/player/YouTubePlayerBridge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n1855#2,2:210\n1855#2,2:212\n1855#2,2:214\n1855#2,2:216\n1855#2,2:218\n1855#2,2:220\n1855#2,2:222\n1855#2,2:224\n1855#2,2:226\n1855#2,2:228\n*S KotlinDebug\n*F\n+ 1 YouTubePlayerBridge.kt\ncom/pierfrancescosoffritti/androidyoutubeplayer/core/player/YouTubePlayerBridge\n*L\n63#1:210,2\n71#1:212,2\n80#1:214,2\n89#1:216,2\n98#1:218,2\n104#1:220,2\n117#1:222,2\n132#1:224,2\n146#1:226,2\n152#1:228,2\n*E\n"})
public final class YouTubePlayerBridge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final YouTubePlayerBridgeCallbacks youTubePlayerOwner;
    @NotNull
    private final Handler mainThreadHandler;
    @NotNull
    private static final String STATE_UNSTARTED = "UNSTARTED";
    @NotNull
    private static final String STATE_ENDED = "ENDED";
    @NotNull
    private static final String STATE_PLAYING = "PLAYING";
    @NotNull
    private static final String STATE_PAUSED = "PAUSED";
    @NotNull
    private static final String STATE_BUFFERING = "BUFFERING";
    @NotNull
    private static final String STATE_CUED = "CUED";
    @NotNull
    private static final String QUALITY_SMALL = "small";
    @NotNull
    private static final String QUALITY_MEDIUM = "medium";
    @NotNull
    private static final String QUALITY_LARGE = "large";
    @NotNull
    private static final String QUALITY_HD720 = "hd720";
    @NotNull
    private static final String QUALITY_HD1080 = "hd1080";
    @NotNull
    private static final String QUALITY_HIGH_RES = "highres";
    @NotNull
    private static final String QUALITY_DEFAULT = "default";
    @NotNull
    private static final String RATE_0_25 = "0.25";
    @NotNull
    private static final String RATE_0_5 = "0.5";
    @NotNull
    private static final String RATE_0_75 = "0.75";
    @NotNull
    private static final String RATE_1 = "1";
    @NotNull
    private static final String RATE_1_25 = "1.25";
    @NotNull
    private static final String RATE_1_5 = "1.5";
    @NotNull
    private static final String RATE_1_75 = "1.75";
    @NotNull
    private static final String RATE_2 = "2";
    @NotNull
    private static final String ERROR_INVALID_PARAMETER_IN_REQUEST = "2";
    @NotNull
    private static final String ERROR_HTML_5_PLAYER = "5";
    @NotNull
    private static final String ERROR_VIDEO_NOT_FOUND = "100";
    @NotNull
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1 = "101";
    @NotNull
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2 = "150";

    public YouTubePlayerBridge(@NotNull YouTubePlayerBridgeCallbacks youTubePlayerOwner) {
        Intrinsics.checkNotNullParameter((Object)youTubePlayerOwner, (String)"youTubePlayerOwner");
        this.youTubePlayerOwner = youTubePlayerOwner;
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
    }

    @JavascriptInterface
    public final boolean sendYouTubeIFrameAPIReady() {
        return this.mainThreadHandler.post(() -> YouTubePlayerBridge.sendYouTubeIFrameAPIReady$lambda$0(this));
    }

    @JavascriptInterface
    public final boolean sendReady() {
        return this.mainThreadHandler.post(() -> YouTubePlayerBridge.sendReady$lambda$2(this));
    }

    @JavascriptInterface
    public final void sendStateChange(@NotNull String state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        PlayerConstants.PlayerState playerState = this.parsePlayerState(state);
        this.mainThreadHandler.post(() -> YouTubePlayerBridge.sendStateChange$lambda$4(this, playerState));
    }

    @JavascriptInterface
    public final void sendPlaybackQualityChange(@NotNull String quality) {
        Intrinsics.checkNotNullParameter((Object)quality, (String)"quality");
        PlayerConstants.PlaybackQuality playbackQuality = this.parsePlaybackQuality(quality);
        this.mainThreadHandler.post(() -> YouTubePlayerBridge.sendPlaybackQualityChange$lambda$6(this, playbackQuality));
    }

    @JavascriptInterface
    public final void sendPlaybackRateChange(@NotNull String rate) {
        Intrinsics.checkNotNullParameter((Object)rate, (String)"rate");
        PlayerConstants.PlaybackRate playbackRate = this.parsePlaybackRate(rate);
        this.mainThreadHandler.post(() -> YouTubePlayerBridge.sendPlaybackRateChange$lambda$8(this, playbackRate));
    }

    @JavascriptInterface
    public final void sendError(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        PlayerConstants.PlayerError playerError = this.parsePlayerError(error);
        this.mainThreadHandler.post(() -> YouTubePlayerBridge.sendError$lambda$10(this, playerError));
    }

    @JavascriptInterface
    public final boolean sendApiChange() {
        return this.mainThreadHandler.post(() -> YouTubePlayerBridge.sendApiChange$lambda$12(this));
    }

    @JavascriptInterface
    public final void sendVideoCurrentTime(@NotNull String seconds) {
        float f;
        Intrinsics.checkNotNullParameter((Object)seconds, (String)"seconds");
        try {
            f = Float.parseFloat(seconds);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        float currentTimeSeconds = f;
        this.mainThreadHandler.post(() -> YouTubePlayerBridge.sendVideoCurrentTime$lambda$14(this, currentTimeSeconds));
    }

    @JavascriptInterface
    public final void sendVideoDuration(@NotNull String seconds) {
        float f;
        Intrinsics.checkNotNullParameter((Object)seconds, (String)"seconds");
        try {
            String finalSeconds = TextUtils.isEmpty((CharSequence)seconds) ? "0" : seconds;
            f = Float.parseFloat(finalSeconds);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        float videoDuration = f;
        this.mainThreadHandler.post(() -> YouTubePlayerBridge.sendVideoDuration$lambda$16(this, videoDuration));
    }

    @JavascriptInterface
    public final void sendVideoLoadedFraction(@NotNull String fraction) {
        float f;
        Intrinsics.checkNotNullParameter((Object)fraction, (String)"fraction");
        try {
            f = Float.parseFloat(fraction);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        float loadedFraction = f;
        this.mainThreadHandler.post(() -> YouTubePlayerBridge.sendVideoLoadedFraction$lambda$18(this, loadedFraction));
    }

    @JavascriptInterface
    public final boolean sendVideoId(@NotNull String videoId) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        return this.mainThreadHandler.post(() -> YouTubePlayerBridge.sendVideoId$lambda$20(this, videoId));
    }

    private final PlayerConstants.PlayerState parsePlayerState(String state) {
        return StringsKt.equals((String)state, (String)STATE_UNSTARTED, (boolean)true) ? PlayerConstants.PlayerState.UNSTARTED : (StringsKt.equals((String)state, (String)STATE_ENDED, (boolean)true) ? PlayerConstants.PlayerState.ENDED : (StringsKt.equals((String)state, (String)STATE_PLAYING, (boolean)true) ? PlayerConstants.PlayerState.PLAYING : (StringsKt.equals((String)state, (String)STATE_PAUSED, (boolean)true) ? PlayerConstants.PlayerState.PAUSED : (StringsKt.equals((String)state, (String)STATE_BUFFERING, (boolean)true) ? PlayerConstants.PlayerState.BUFFERING : (StringsKt.equals((String)state, (String)STATE_CUED, (boolean)true) ? PlayerConstants.PlayerState.VIDEO_CUED : PlayerConstants.PlayerState.UNKNOWN)))));
    }

    private final PlayerConstants.PlaybackQuality parsePlaybackQuality(String quality) {
        return StringsKt.equals((String)quality, (String)QUALITY_SMALL, (boolean)true) ? PlayerConstants.PlaybackQuality.SMALL : (StringsKt.equals((String)quality, (String)QUALITY_MEDIUM, (boolean)true) ? PlayerConstants.PlaybackQuality.MEDIUM : (StringsKt.equals((String)quality, (String)QUALITY_LARGE, (boolean)true) ? PlayerConstants.PlaybackQuality.LARGE : (StringsKt.equals((String)quality, (String)QUALITY_HD720, (boolean)true) ? PlayerConstants.PlaybackQuality.HD720 : (StringsKt.equals((String)quality, (String)QUALITY_HD1080, (boolean)true) ? PlayerConstants.PlaybackQuality.HD1080 : (StringsKt.equals((String)quality, (String)QUALITY_HIGH_RES, (boolean)true) ? PlayerConstants.PlaybackQuality.HIGH_RES : (StringsKt.equals((String)quality, (String)QUALITY_DEFAULT, (boolean)true) ? PlayerConstants.PlaybackQuality.DEFAULT : PlayerConstants.PlaybackQuality.UNKNOWN))))));
    }

    private final PlayerConstants.PlaybackRate parsePlaybackRate(String rate) {
        return StringsKt.equals((String)rate, (String)RATE_0_25, (boolean)true) ? PlayerConstants.PlaybackRate.RATE_0_25 : (StringsKt.equals((String)rate, (String)RATE_0_5, (boolean)true) ? PlayerConstants.PlaybackRate.RATE_0_5 : (StringsKt.equals((String)rate, (String)RATE_0_75, (boolean)true) ? PlayerConstants.PlaybackRate.RATE_0_75 : (StringsKt.equals((String)rate, (String)RATE_1, (boolean)true) ? PlayerConstants.PlaybackRate.RATE_1 : (StringsKt.equals((String)rate, (String)RATE_1_25, (boolean)true) ? PlayerConstants.PlaybackRate.RATE_1_25 : (StringsKt.equals((String)rate, (String)RATE_1_5, (boolean)true) ? PlayerConstants.PlaybackRate.RATE_1_5 : (StringsKt.equals((String)rate, (String)RATE_1_75, (boolean)true) ? PlayerConstants.PlaybackRate.RATE_1_75 : (StringsKt.equals((String)rate, (String)"2", (boolean)true) ? PlayerConstants.PlaybackRate.RATE_2 : PlayerConstants.PlaybackRate.UNKNOWN)))))));
    }

    private final PlayerConstants.PlayerError parsePlayerError(String error) {
        return StringsKt.equals((String)error, (String)"2", (boolean)true) ? PlayerConstants.PlayerError.INVALID_PARAMETER_IN_REQUEST : (StringsKt.equals((String)error, (String)ERROR_HTML_5_PLAYER, (boolean)true) ? PlayerConstants.PlayerError.HTML_5_PLAYER : (StringsKt.equals((String)error, (String)ERROR_VIDEO_NOT_FOUND, (boolean)true) ? PlayerConstants.PlayerError.VIDEO_NOT_FOUND : (StringsKt.equals((String)error, (String)ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1, (boolean)true) ? PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER : (StringsKt.equals((String)error, (String)ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2, (boolean)true) ? PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER : PlayerConstants.PlayerError.UNKNOWN))));
    }

    private static final void sendYouTubeIFrameAPIReady$lambda$0(YouTubePlayerBridge this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.youTubePlayerOwner.onYouTubeIFrameAPIReady();
    }

    private static final void sendReady$lambda$2(YouTubePlayerBridge this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = this$0.youTubePlayerOwner.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YouTubePlayerListener it = (YouTubePlayerListener)element$iv;
            boolean bl = false;
            it.onReady(this$0.youTubePlayerOwner.getInstance());
        }
    }

    private static final void sendStateChange$lambda$4(YouTubePlayerBridge this$0, PlayerConstants.PlayerState $playerState) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$playerState), (String)"$playerState");
        Iterable $this$forEach$iv = this$0.youTubePlayerOwner.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YouTubePlayerListener it = (YouTubePlayerListener)element$iv;
            boolean bl = false;
            it.onStateChange(this$0.youTubePlayerOwner.getInstance(), $playerState);
        }
    }

    private static final void sendPlaybackQualityChange$lambda$6(YouTubePlayerBridge this$0, PlayerConstants.PlaybackQuality $playbackQuality) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$playbackQuality), (String)"$playbackQuality");
        Iterable $this$forEach$iv = this$0.youTubePlayerOwner.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YouTubePlayerListener it = (YouTubePlayerListener)element$iv;
            boolean bl = false;
            it.onPlaybackQualityChange(this$0.youTubePlayerOwner.getInstance(), $playbackQuality);
        }
    }

    private static final void sendPlaybackRateChange$lambda$8(YouTubePlayerBridge this$0, PlayerConstants.PlaybackRate $playbackRate) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$playbackRate), (String)"$playbackRate");
        Iterable $this$forEach$iv = this$0.youTubePlayerOwner.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YouTubePlayerListener it = (YouTubePlayerListener)element$iv;
            boolean bl = false;
            it.onPlaybackRateChange(this$0.youTubePlayerOwner.getInstance(), $playbackRate);
        }
    }

    private static final void sendError$lambda$10(YouTubePlayerBridge this$0, PlayerConstants.PlayerError $playerError) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$playerError), (String)"$playerError");
        Iterable $this$forEach$iv = this$0.youTubePlayerOwner.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YouTubePlayerListener it = (YouTubePlayerListener)element$iv;
            boolean bl = false;
            it.onError(this$0.youTubePlayerOwner.getInstance(), $playerError);
        }
    }

    private static final void sendApiChange$lambda$12(YouTubePlayerBridge this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = this$0.youTubePlayerOwner.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YouTubePlayerListener it = (YouTubePlayerListener)element$iv;
            boolean bl = false;
            it.onApiChange(this$0.youTubePlayerOwner.getInstance());
        }
    }

    private static final void sendVideoCurrentTime$lambda$14(YouTubePlayerBridge this$0, float $currentTimeSeconds) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = this$0.youTubePlayerOwner.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YouTubePlayerListener it = (YouTubePlayerListener)element$iv;
            boolean bl = false;
            it.onCurrentSecond(this$0.youTubePlayerOwner.getInstance(), $currentTimeSeconds);
        }
    }

    private static final void sendVideoDuration$lambda$16(YouTubePlayerBridge this$0, float $videoDuration) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = this$0.youTubePlayerOwner.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YouTubePlayerListener it = (YouTubePlayerListener)element$iv;
            boolean bl = false;
            it.onVideoDuration(this$0.youTubePlayerOwner.getInstance(), $videoDuration);
        }
    }

    private static final void sendVideoLoadedFraction$lambda$18(YouTubePlayerBridge this$0, float $loadedFraction) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = this$0.youTubePlayerOwner.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YouTubePlayerListener it = (YouTubePlayerListener)element$iv;
            boolean bl = false;
            it.onVideoLoadedFraction(this$0.youTubePlayerOwner.getInstance(), $loadedFraction);
        }
    }

    private static final void sendVideoId$lambda$20(YouTubePlayerBridge this$0, String $videoId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$videoId, (String)"$videoId");
        Iterable $this$forEach$iv = this$0.youTubePlayerOwner.getListeners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YouTubePlayerListener it = (YouTubePlayerListener)element$iv;
            boolean bl = false;
            it.onVideoId(this$0.youTubePlayerOwner.getInstance(), $videoId);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0007\u001a\u00020\bH&J\b\u0010\t\u001a\u00020\nH&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/YouTubePlayerBridge$YouTubePlayerBridgeCallbacks;", "", "listeners", "", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/listeners/YouTubePlayerListener;", "getListeners", "()Ljava/util/Collection;", "getInstance", "Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/YouTubePlayer;", "onYouTubeIFrameAPIReady", "", "core_release"})
    public static interface YouTubePlayerBridgeCallbacks {
        @NotNull
        public Collection<YouTubePlayerListener> getListeners();

        @NotNull
        public YouTubePlayer getInstance();

        public void onYouTubeIFrameAPIReady();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001a\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/pierfrancescosoffritti/androidyoutubeplayer/core/player/YouTubePlayerBridge$Companion;", "", "()V", "ERROR_HTML_5_PLAYER", "", "ERROR_INVALID_PARAMETER_IN_REQUEST", "ERROR_VIDEO_NOT_FOUND", "ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1", "ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2", "QUALITY_DEFAULT", "QUALITY_HD1080", "QUALITY_HD720", "QUALITY_HIGH_RES", "QUALITY_LARGE", "QUALITY_MEDIUM", "QUALITY_SMALL", "RATE_0_25", "RATE_0_5", "RATE_0_75", "RATE_1", "RATE_1_25", "RATE_1_5", "RATE_1_75", "RATE_2", "STATE_BUFFERING", "STATE_CUED", "STATE_ENDED", "STATE_PAUSED", "STATE_PLAYING", "STATE_UNSTARTED", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

