/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.spi;

import com.pi4j.io.spi.Spi;

public enum SpiMode {
    MODE_0(0),
    MODE_1(1),
    MODE_2(2),
    MODE_3(3);

    private final int mode;

    private SpiMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public static SpiMode getByNumber(short modeNumber) {
        return SpiMode.getByNumber((int)modeNumber);
    }

    public static SpiMode getByNumber(int modeNumber) {
        for (SpiMode item : SpiMode.values()) {
            if (item.getMode() != modeNumber) continue;
            return item;
        }
        return null;
    }

    public static SpiMode parse(String mode) {
        if (mode.equalsIgnoreCase("0")) {
            return MODE_0;
        }
        if (mode.equalsIgnoreCase("1")) {
            return MODE_1;
        }
        if (mode.equalsIgnoreCase("2")) {
            return MODE_2;
        }
        if (mode.equalsIgnoreCase("3")) {
            return MODE_3;
        }
        return Spi.DEFAULT_MODE;
    }
}

