/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.pwm.impl;

import com.pi4j.io.pwm.PwmPreset;

public class DefaultPwmPreset
implements PwmPreset {
    protected final String name;
    protected final Float dutyCycle;
    protected final Integer frequency;

    public DefaultPwmPreset(String name, Number dutyCycle) {
        this.name = name.toLowerCase().trim();
        this.dutyCycle = Float.valueOf(dutyCycle.floatValue());
        this.frequency = null;
    }

    public DefaultPwmPreset(String name, Number dutyCycle, Integer frequency) {
        this.name = name.toLowerCase().trim();
        if (dutyCycle != null) {
            float dc = dutyCycle.floatValue();
            if (dc < 0.0f) {
                dc = 0.0f;
            }
            if (dc > 100.0f) {
                dc = 100.0f;
            }
            this.dutyCycle = Float.valueOf(dc);
        } else {
            this.dutyCycle = null;
        }
        this.frequency = frequency;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Float dutyCycle() {
        return this.dutyCycle;
    }

    @Override
    public Integer frequency() {
        return this.frequency;
    }
}

