/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.pwm;

import com.pi4j.context.Context;
import com.pi4j.exception.InitializeException;
import com.pi4j.exception.ShutdownException;
import com.pi4j.io.IOBase;
import com.pi4j.io.exception.IOException;
import com.pi4j.io.pwm.Pwm;
import com.pi4j.io.pwm.PwmConfig;
import com.pi4j.io.pwm.PwmPolarity;
import com.pi4j.io.pwm.PwmPreset;
import com.pi4j.io.pwm.PwmProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class PwmBase
extends IOBase<Pwm, PwmConfig, PwmProvider>
implements Pwm {
    protected int frequency = 100;
    protected float dutyCycle = 50.0f;
    protected boolean onState = false;
    protected PwmPolarity polarity = PwmPolarity.NORMAL;
    protected Map<String, PwmPreset> presets = Collections.synchronizedMap(new HashMap());

    public PwmBase(PwmProvider provider, PwmConfig config) {
        super(provider, config);
        this.name = config.name();
        this.id = config.id();
        this.description = config.description();
        for (PwmPreset preset : config.presets()) {
            this.presets.put(preset.name().toLowerCase().trim(), preset);
        }
    }

    @Override
    public float getDutyCycle() throws IOException {
        return this.dutyCycle;
    }

    @Override
    public int getFrequency() throws IOException {
        return this.frequency;
    }

    @Override
    public int getActualFrequency() throws IOException {
        return this.frequency;
    }

    @Override
    public void setDutyCycle(Number dutyCycle) throws IOException {
        float dc = dutyCycle.floatValue();
        if (dc < 0.0f) {
            dc = 0.0f;
        }
        if (dc > 100.0f) {
            dc = 100.0f;
        }
        this.dutyCycle = dc;
    }

    @Override
    public void setFrequency(int frequency) throws IOException {
        this.frequency = frequency;
    }

    @Override
    public boolean isOn() {
        return this.onState;
    }

    @Override
    public Pwm initialize(Context context) throws InitializeException {
        if (((PwmConfig)this.config).frequency() != null) {
            this.frequency = ((PwmConfig)this.config).frequency();
        }
        this.dutyCycle = ((PwmConfig)this.config).dutyCycle() != null ? ((PwmConfig)this.config).dutyCycle().floatValue() : 50.0f;
        this.polarity = ((PwmConfig)this.config).polarity() != null ? ((PwmConfig)this.config).polarity() : PwmPolarity.NORMAL;
        if (((PwmConfig)this.config).initialValue() != null) {
            try {
                if (((PwmConfig)this.config).initialValue().floatValue() <= 0.0f) {
                    this.off();
                } else {
                    this.on(((PwmConfig)this.config).initialValue());
                }
            }
            catch (IOException e) {
                throw new InitializeException(e);
            }
        }
        return this;
    }

    @Override
    public Pwm shutdown(Context context) throws ShutdownException {
        if (((PwmConfig)this.config).shutdownValue() != null) {
            try {
                if (((PwmConfig)this.config).shutdownValue().floatValue() <= 0.0f) {
                    this.off();
                } else {
                    this.on(((PwmConfig)this.config).shutdownValue());
                }
            }
            catch (IOException e) {
                throw new ShutdownException(e);
            }
        }
        return this;
    }

    @Override
    public Map<String, PwmPreset> getPresets() {
        return Collections.unmodifiableMap(this.presets);
    }

    @Override
    public PwmPreset getPreset(String name) {
        String key = name.toLowerCase().trim();
        if (this.presets.containsKey(key)) {
            return this.presets.get(key);
        }
        return null;
    }

    @Override
    public PwmPreset deletePreset(String name) {
        String key = name.toLowerCase().trim();
        if (this.presets.containsKey(key)) {
            return this.presets.remove(key);
        }
        return null;
    }

    @Override
    public Pwm addPreset(PwmPreset preset) {
        String key = preset.name().toLowerCase().trim();
        this.presets.put(key, preset);
        return this;
    }

    @Override
    public Pwm applyPreset(String name) throws IOException {
        String key = name.toLowerCase().trim();
        if (this.presets.containsKey(key)) {
            PwmPreset preset = this.presets.get(key);
            if (preset.dutyCycle() != null) {
                this.setDutyCycle(Float.valueOf(preset.dutyCycle().floatValue()));
            }
            if (preset.frequency() != null) {
                this.setFrequency(preset.frequency());
            }
        } else {
            throw new IOException("PWM PRESET NOT FOUND: " + name);
        }
        this.on();
        return this;
    }
}

