/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.context;

import com.pi4j.common.Describable;
import com.pi4j.common.Descriptor;
import com.pi4j.util.StringUtil;
import java.util.Map;

public interface ContextProperties
extends Describable {
    public boolean has(String var1);

    public String get(String var1);

    public Map<String, String> all();

    public int count();

    default public String get(String key, String defaultValue) {
        String value = this.get(key);
        if (StringUtil.isNotNullOrEmpty(value)) {
            return value;
        }
        return defaultValue;
    }

    default public boolean exists(String key) {
        return this.has(key);
    }

    default public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    default public Integer getInteger(String key, Integer defaultValue) {
        if (this.has(key)) {
            return StringUtil.parseInteger(this.get(key), defaultValue);
        }
        return defaultValue;
    }

    @Override
    default public Descriptor describe() {
        Descriptor descriptor = Descriptor.create().category("PROPERTIES").name("Properties").quantity(this.count()).type(this.getClass());
        for (Map.Entry<String, String> e : this.all().entrySet()) {
            descriptor.add(Descriptor.create().name(e.getKey().toString()).category("PROPERTY").description(e.getValue().toString()));
        }
        return descriptor;
    }
}

