/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial;

public enum FlowControl {
    NONE(0),
    HARDWARE(1),
    SOFTWARE(2);

    private int index = 0;

    private FlowControl(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public static FlowControl getInstance(String flow_control) {
        return FlowControl.valueOf(flow_control.toUpperCase());
    }

    public static FlowControl getInstance(int control) {
        for (FlowControl fc : FlowControl.values()) {
            if (fc.getIndex() != control) continue;
            return fc;
        }
        return null;
    }

    public static FlowControl parse(String parity) {
        if (parity.equalsIgnoreCase("0")) {
            return NONE;
        }
        if (parity.equalsIgnoreCase("1")) {
            return HARDWARE;
        }
        if (parity.equalsIgnoreCase("2")) {
            return SOFTWARE;
        }
        if (parity.toLowerCase().startsWith("n")) {
            return NONE;
        }
        if (parity.toLowerCase().startsWith("h")) {
            return HARDWARE;
        }
        if (parity.toLowerCase().startsWith("s")) {
            return SOFTWARE;
        }
        return NONE;
    }
}

