/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.sax;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class ReadableResourceSAXInputSource
extends InputSource {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ReadableResourceSAXInputSource.class);
    private final IInputStreamProvider m_aISP;

    public ReadableResourceSAXInputSource(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource, iReadableResource.getResourceID());
    }

    public ReadableResourceSAXInputSource(@Nonnull IInputStreamProvider iInputStreamProvider, @Nullable String string) {
        this.m_aISP = ValueEnforcer.notNull(iInputStreamProvider, "InputStreamProvider");
        this.setSystemId(string);
    }

    @Override
    public InputStream getByteStream() {
        InputStream inputStream = this.m_aISP.getInputStream();
        if (inputStream == null) {
            s_aLogger.warn("Failed to open input stream for " + this.m_aISP);
        }
        return inputStream;
    }

    public String toString() {
        return new ToStringGenerator(this).append("resource", this.m_aISP).append("systemID", this.getSystemId()).toString();
    }
}

