/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class WrappedReader
extends Reader {
    private final Reader m_aWrappedReader;

    public WrappedReader(@Nonnull Reader reader) {
        this.m_aWrappedReader = ValueEnforcer.notNull(reader, "WrappedReader");
    }

    @Nonnull
    public Reader getWrappedReader() {
        return this.m_aWrappedReader;
    }

    @Override
    public int read(@Nonnull CharBuffer charBuffer) throws IOException {
        return this.m_aWrappedReader.read(charBuffer);
    }

    @Override
    public int read() throws IOException {
        return this.m_aWrappedReader.read();
    }

    @Override
    public int read(@Nonnull char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public int read(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        return this.m_aWrappedReader.read(cArray, n, n2);
    }

    @Override
    public long skip(@Nonnegative long l) throws IOException {
        return this.m_aWrappedReader.skip(l);
    }

    @Override
    public boolean ready() throws IOException {
        return this.m_aWrappedReader.ready();
    }

    @Override
    public boolean markSupported() {
        return this.m_aWrappedReader.markSupported();
    }

    @Override
    public void mark(@Nonnegative int n) throws IOException {
        this.m_aWrappedReader.mark(n);
    }

    @Override
    public void reset() throws IOException {
        this.m_aWrappedReader.reset();
    }

    @Override
    public void close() throws IOException {
        this.m_aWrappedReader.close();
    }

    public String toString() {
        return new ToStringGenerator(this).append("wrappedReader", this.m_aWrappedReader).toString();
    }
}

