/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.error;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceLocation;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.name.IHasDisplayText;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.text.impl.ConstantTextProvider;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ResourceError
implements IResourceError {
    private final IResourceLocation m_aLocation;
    private final EErrorLevel m_eErrorLevel;
    private final IHasDisplayText m_aErrorText;
    private final Throwable m_aLinkedException;

    public ResourceError(@Nonnull IResourceLocation iResourceLocation, @Nonnull EErrorLevel eErrorLevel, @Nonnull String string) {
        this(iResourceLocation, eErrorLevel, string, null);
    }

    public ResourceError(@Nonnull IResourceLocation iResourceLocation, @Nonnull EErrorLevel eErrorLevel, @Nonnull String string, @Nullable Throwable throwable) {
        this(iResourceLocation, eErrorLevel, new ConstantTextProvider(string), throwable);
    }

    public ResourceError(@Nonnull IResourceLocation iResourceLocation, @Nonnull EErrorLevel eErrorLevel, @Nonnull IHasDisplayText iHasDisplayText) {
        this(iResourceLocation, eErrorLevel, iHasDisplayText, null);
    }

    public ResourceError(@Nonnull IResourceLocation iResourceLocation, @Nonnull EErrorLevel eErrorLevel, @Nonnull IHasDisplayText iHasDisplayText, @Nullable Throwable throwable) {
        this.m_aLocation = ValueEnforcer.notNull(iResourceLocation, "Location");
        this.m_eErrorLevel = ValueEnforcer.notNull(eErrorLevel, "ErrorLevel");
        this.m_aErrorText = ValueEnforcer.notNull(iHasDisplayText, "ErrorText");
        this.m_aLinkedException = throwable;
    }

    @Override
    @Nonnull
    public final IResourceLocation getLocation() {
        return this.m_aLocation;
    }

    @Override
    @Nonnull
    public final EErrorLevel getErrorLevel() {
        return this.m_eErrorLevel;
    }

    @Override
    @Nullable
    @OverrideOnDemand
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aErrorText.getDisplayText(locale);
    }

    @Override
    @Nullable
    public final Throwable getLinkedException() {
        return this.m_aLinkedException;
    }

    @Override
    @Nonnull
    @OverrideOnDemand
    public String getAsString(@Nonnull Locale locale) {
        String string = "[" + this.m_eErrorLevel.getID() + "] ";
        String string2 = this.m_aLocation.getAsString();
        if (StringHelper.hasText(string2)) {
            string = string + string2 + ": ";
        }
        string = string + this.getDisplayText(locale);
        if (this.m_aLinkedException != null) {
            string = string + " (" + this.m_aLinkedException.getMessage() + ")";
        }
        return string;
    }

    @Override
    public boolean isSuccess() {
        return this.m_eErrorLevel.isSuccess();
    }

    @Override
    public boolean isFailure() {
        return this.m_eErrorLevel.isFailure();
    }

    @Override
    public boolean isError() {
        return this.m_eErrorLevel.isError();
    }

    @Override
    public boolean isNoError() {
        return this.m_eErrorLevel.isNoError();
    }

    @Override
    public boolean isEqualSevereThan(@Nonnull IResourceError iResourceError) {
        return this.m_eErrorLevel.isEqualSevereThan(iResourceError.getErrorLevel());
    }

    @Override
    public boolean isLessSevereThan(@Nonnull IResourceError iResourceError) {
        return this.m_eErrorLevel.isLessSevereThan(iResourceError.getErrorLevel());
    }

    @Override
    public boolean isLessOrEqualSevereThan(@Nonnull IResourceError iResourceError) {
        return this.m_eErrorLevel.isLessOrEqualSevereThan(iResourceError.getErrorLevel());
    }

    @Override
    public boolean isMoreSevereThan(@Nonnull IResourceError iResourceError) {
        return this.m_eErrorLevel.isMoreSevereThan(iResourceError.getErrorLevel());
    }

    @Override
    public boolean isMoreOrEqualSevereThan(@Nonnull IResourceError iResourceError) {
        return this.m_eErrorLevel.isMoreOrEqualSevereThan(iResourceError.getErrorLevel());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ResourceError resourceError = (ResourceError)object;
        return this.m_aLocation.equals(resourceError.m_aLocation) && this.m_eErrorLevel.equals(resourceError.m_eErrorLevel) && this.m_aErrorText.equals(resourceError.m_aErrorText);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aLocation).append((Enum)this.m_eErrorLevel)).append(this.m_aErrorText).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("location", this.m_aLocation).append("errorLevel", this.m_eErrorLevel).append("errorText", this.m_aErrorText).appendIfNotNull("linkedException", this.m_aLinkedException).toString();
    }
}

