/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.multimap.AbstractMultiHashMapSetBased;
import com.phloc.commons.id.IHasID;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LockedContainerHelper {
    private LockedContainerHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <K, T> T getByKey(K k, @Nonnull Map<K, T> map, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            T t = map.get(k);
            return t;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    public static <K, T, R> R getByKeyCasted(K k, @Nonnull Map<K, T> map, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        return (R)LockedContainerHelper.getByKey(k, map, reentrantReadWriteLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReturnsMutableCopy
    public static <T> Collection<T> getCollection(@Nonnull Collection<T> collection, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            Set<T> set = ContainerHelper.newSet(collection);
            return set;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReturnsMutableCopy
    public static <T> List<T> getList(@Nonnull Collection<T> collection, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            List<T> list = ContainerHelper.newList(collection);
            return list;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReturnsMutableCopy
    public static <K, V> Map<K, V> getMap(@Nonnull Map<K, V> map, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            Map<K, V> map2 = ContainerHelper.newMap(map);
            return map2;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T get(@Nonnull List<T> list, int n, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            T t = list.get(n);
            return t;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            T t = null;
            return t;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReturnsMutableCopy
    public static <K, V> Set<V> getValues(@Nonnull Map<K, V> map, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            Set<V> set = ContainerHelper.newSet(map.values());
            return set;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReturnsMutableCopy
    public static <K, V> Collection<K> getKeys(@Nonnull Map<K, V> map, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            if (map instanceof LinkedHashMap) {
                List<K> list = ContainerHelper.newList(map.keySet());
                return list;
            }
            Set<K> set = ContainerHelper.newSet(map.keySet());
            return set;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static <K, T> Set<T> getMultiMapEntry(@Nonnull AbstractMultiHashMapSetBased<K, T> abstractMultiHashMapSetBased, @Nonnull K k, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        if (abstractMultiHashMapSetBased == null) {
            throw new NullPointerException("aMap");
        }
        reentrantReadWriteLock.readLock().lock();
        try {
            Set set = ContainerHelper.newSet((Collection)abstractMultiHashMapSetBased.get(k));
            return set;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ReturnsMutableCopy
    public static <T> Set<T> getSet(@Nonnull Set<T> set, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            Set<T> set2 = ContainerHelper.newSet(set);
            return set2;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static <T> Stack<T> getStack(@Nonnull Stack<T> stack, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        Stack<T> stack2 = new Stack<T>();
        reentrantReadWriteLock.readLock().lock();
        try {
            stack2.addAll(stack);
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
        return stack2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean remove(@Nonnull Collection<T> collection, @Nonnull T t, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.writeLock().lock();
        try {
            if (t != null) {
                boolean bl = collection.remove(t);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            reentrantReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean contains(@Nonnull Collection<T> collection, @Nonnull T t, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.writeLock().lock();
        try {
            if (t != null) {
                boolean bl = collection.contains(t);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            reentrantReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean containsAll(@Nullable Collection<T> collection, @Nonnull Collection<T> collection2, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.writeLock().lock();
        try {
            if (collection != null) {
                boolean bl = collection.containsAll(collection2);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            reentrantReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void clear(@Nonnull Collection<T> collection, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.writeLock().lock();
        try {
            collection.clear();
        }
        finally {
            reentrantReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean add(@Nonnull Collection<T> collection, @Nonnull T t, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.writeLock().lock();
        try {
            if (t != null) {
                boolean bl = collection.add(t);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            reentrantReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean addAll(@Nonnull Collection<T> collection, @Nullable Collection<T> collection2, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        if (collection != null && collection2 != null) {
            reentrantReadWriteLock.writeLock().lock();
            try {
                boolean bl = collection.addAll(collection2);
                return bl;
            }
            finally {
                reentrantReadWriteLock.writeLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean removeAll(@Nonnull Collection<T> collection, @Nullable Collection<T> collection2, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        if (collection != null && collection2 != null) {
            reentrantReadWriteLock.writeLock().lock();
            try {
                boolean bl = collection.removeAll(collection2);
                return bl;
            }
            finally {
                reentrantReadWriteLock.writeLock().unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V put(@Nonnull Map<K, V> map, @Nonnull K k, @Nonnull V v, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.writeLock().lock();
        try {
            if (map != null) {
                V v2 = map.put(k, v);
                return v2;
            }
            V v3 = null;
            return v3;
        }
        finally {
            reentrantReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> void putAll(@Nonnull Map<K, V> map, @Nullable Map<K, V> map2, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.writeLock().lock();
        try {
            if (map != null && map2 != null) {
                map.putAll(map2);
            }
        }
        finally {
            reentrantReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V remove(@Nonnull Map<K, V> map, @Nonnull K k, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.writeLock().lock();
        try {
            if (map != null) {
                V v = map.remove(k);
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            reentrantReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> void clear(@Nonnull Map<K, V> map, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.writeLock().lock();
        try {
            map.clear();
        }
        finally {
            reentrantReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> boolean isEmpty(@Nonnull Collection<T> collection, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            boolean bl = ContainerHelper.isEmpty(collection);
            return bl;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> boolean isEmpty(@Nonnull Map<K, V> map, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            boolean bl = ContainerHelper.isEmpty(map);
            return bl;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> int getSize(@Nonnull Map<K, V> map, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            int n = ContainerHelper.getSize(map);
            return n;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int getSize(@Nonnull Collection<T> collection, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            int n = ContainerHelper.getSize(collection);
            return n;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getFirst(@Nonnull Collection<T> collection, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            T t = ContainerHelper.getFirstElement(collection);
            return t;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getFirstValue(@Nonnull Map<?, T> map, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        reentrantReadWriteLock.readLock().lock();
        try {
            T t = ContainerHelper.getFirstValue(map);
            return t;
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Set<String> getIDs(@Nonnull Collection<? extends IHasID<String>> collection, @Nonnull ReentrantReadWriteLock reentrantReadWriteLock) {
        if (collection == null) {
            throw new NullPointerException("aElements");
        }
        Set<String> set = ContainerHelper.newSet();
        reentrantReadWriteLock.readLock().lock();
        try {
            for (IHasID<String> iHasID : collection) {
                set.add(iHasID.getID());
            }
        }
        finally {
            reentrantReadWriteLock.readLock().unlock();
        }
        return set;
    }
}

