/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public final class HTMLdtd {
    private static final Map<String, Integer> s_aElemDefs = new HashMap<String, Integer>();
    private static final Map<String, String[]> s_aBoolAttrs = new HashMap<String, String[]>();
    private static final int ONLY_OPENING = 1;
    private static final int ELEM_CONTENT = 2;
    private static final int PRESERVE = 4;
    private static final int OPT_CLOSING = 8;
    private static final int EMPTY = 17;
    private static final int ALLOWED_HEAD = 32;
    private static final int CLOSE_P = 64;
    private static final int CLOSE_DD_DT = 128;
    private static final int CLOSE_SELF = 256;
    private static final int CLOSE_TABLE = 512;
    private static final int CLOSE_TH_TD = 16384;

    private HTMLdtd() {
    }

    private static boolean _isElement(@Nonnull String string, int n) {
        Integer n2 = s_aElemDefs.get(string.toUpperCase(Locale.US));
        return n2 != null && (n2 & n) == n;
    }

    public static boolean isEmptyTag(@Nonnull String string) {
        return HTMLdtd._isElement(string, 17);
    }

    public static boolean isElementContent(@Nonnull String string) {
        return HTMLdtd._isElement(string, 2);
    }

    public static boolean isPreserveSpace(@Nonnull String string) {
        return HTMLdtd._isElement(string, 4);
    }

    public static boolean isOptionalClosing(@Nonnull String string) {
        return HTMLdtd._isElement(string, 8);
    }

    public static boolean isOnlyOpening(@Nonnull String string) {
        return HTMLdtd._isElement(string, 1);
    }

    public static boolean isClosing(@Nonnull String string, @Nonnull String string2) {
        if (string2.equalsIgnoreCase("HEAD")) {
            return !HTMLdtd._isElement(string, 32);
        }
        if (string2.equalsIgnoreCase("P")) {
            return HTMLdtd._isElement(string, 64);
        }
        if (string2.equalsIgnoreCase("DT") || string2.equalsIgnoreCase("DD")) {
            return HTMLdtd._isElement(string, 128);
        }
        if (string2.equalsIgnoreCase("LI") || string2.equalsIgnoreCase("OPTION")) {
            return HTMLdtd._isElement(string, 256);
        }
        if (string2.equalsIgnoreCase("THEAD") || string2.equalsIgnoreCase("TFOOT") || string2.equalsIgnoreCase("TBODY") || string2.equalsIgnoreCase("TR") || string2.equalsIgnoreCase("COLGROUP")) {
            return HTMLdtd._isElement(string, 512);
        }
        if (string2.equalsIgnoreCase("TH") || string2.equalsIgnoreCase("TD")) {
            return HTMLdtd._isElement(string, 16384);
        }
        return false;
    }

    public static boolean isURI(@Nonnull String string, @Nonnull String string2) {
        return string2.equalsIgnoreCase("href") || string2.equalsIgnoreCase("src");
    }

    public static boolean isBoolean(@Nonnull String string, @Nonnull String string2) {
        String[] stringArray = s_aBoolAttrs.get(string.toUpperCase(Locale.US));
        if (stringArray != null) {
            for (String string3 : stringArray) {
                if (!string3.equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private static void _defineElement(@Nonnull String string, int n) {
        s_aElemDefs.put(string, n);
    }

    private static void _defineBoolean(@Nonnull String string, String ... stringArray) {
        s_aBoolAttrs.put(string, stringArray);
    }

    static {
        HTMLdtd._defineElement("ADDRESS", 64);
        HTMLdtd._defineElement("AREA", 17);
        HTMLdtd._defineElement("BASE", 49);
        HTMLdtd._defineElement("BASEFONT", 17);
        HTMLdtd._defineElement("BLOCKQUOTE", 64);
        HTMLdtd._defineElement("BODY", 8);
        HTMLdtd._defineElement("BR", 17);
        HTMLdtd._defineElement("COL", 17);
        HTMLdtd._defineElement("COLGROUP", 522);
        HTMLdtd._defineElement("DD", 137);
        HTMLdtd._defineElement("DIV", 64);
        HTMLdtd._defineElement("DL", 66);
        HTMLdtd._defineElement("DT", 137);
        HTMLdtd._defineElement("FIELDSET", 64);
        HTMLdtd._defineElement("FORM", 64);
        HTMLdtd._defineElement("FRAME", 25);
        HTMLdtd._defineElement("H1", 64);
        HTMLdtd._defineElement("H2", 64);
        HTMLdtd._defineElement("H3", 64);
        HTMLdtd._defineElement("H4", 64);
        HTMLdtd._defineElement("H5", 64);
        HTMLdtd._defineElement("H6", 64);
        HTMLdtd._defineElement("HEAD", 10);
        HTMLdtd._defineElement("HR", 81);
        HTMLdtd._defineElement("HTML", 10);
        HTMLdtd._defineElement("IMG", 17);
        HTMLdtd._defineElement("INPUT", 17);
        HTMLdtd._defineElement("ISINDEX", 49);
        HTMLdtd._defineElement("LI", 265);
        HTMLdtd._defineElement("LINK", 49);
        HTMLdtd._defineElement("MAP", 32);
        HTMLdtd._defineElement("META", 49);
        HTMLdtd._defineElement("OL", 66);
        HTMLdtd._defineElement("OPTGROUP", 2);
        HTMLdtd._defineElement("OPTION", 265);
        HTMLdtd._defineElement("P", 328);
        HTMLdtd._defineElement("PARAM", 17);
        HTMLdtd._defineElement("PRE", 68);
        HTMLdtd._defineElement("SCRIPT", 36);
        HTMLdtd._defineElement("NOSCRIPT", 36);
        HTMLdtd._defineElement("SELECT", 2);
        HTMLdtd._defineElement("STYLE", 36);
        HTMLdtd._defineElement("TABLE", 66);
        HTMLdtd._defineElement("TBODY", 522);
        HTMLdtd._defineElement("TD", 16392);
        HTMLdtd._defineElement("TEXTAREA", 4);
        HTMLdtd._defineElement("TFOOT", 522);
        HTMLdtd._defineElement("TH", 16392);
        HTMLdtd._defineElement("THEAD", 522);
        HTMLdtd._defineElement("TITLE", 32);
        HTMLdtd._defineElement("TR", 522);
        HTMLdtd._defineElement("UL", 66);
        HTMLdtd._defineBoolean("AREA", "href");
        HTMLdtd._defineBoolean("BUTTON", "disabled");
        HTMLdtd._defineBoolean("DIR", "compact");
        HTMLdtd._defineBoolean("DL", "compact");
        HTMLdtd._defineBoolean("FRAME", "noresize");
        HTMLdtd._defineBoolean("HR", "noshade");
        HTMLdtd._defineBoolean("IMAGE", "ismap");
        HTMLdtd._defineBoolean("INPUT", "defaultchecked", "checked", "readonly", "disabled");
        HTMLdtd._defineBoolean("LINK", "link");
        HTMLdtd._defineBoolean("MENU", "compact");
        HTMLdtd._defineBoolean("OBJECT", "declare");
        HTMLdtd._defineBoolean("OL", "compact");
        HTMLdtd._defineBoolean("OPTGROUP", "disabled");
        HTMLdtd._defineBoolean("OPTION", "default-selected", "selected", "disabled");
        HTMLdtd._defineBoolean("SCRIPT", "defer");
        HTMLdtd._defineBoolean("SELECT", "multiple", "disabled");
        HTMLdtd._defineBoolean("STYLE", "disabled");
        HTMLdtd._defineBoolean("TD", "nowrap");
        HTMLdtd._defineBoolean("TH", "nowrap");
        HTMLdtd._defineBoolean("TEXTAREA", "disabled", "readonly");
        HTMLdtd._defineBoolean("UL", "compact");
    }
}

