/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.simple;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.tree.simple.ITree;
import com.phloc.commons.tree.simple.ITreeItem;
import com.phloc.commons.tree.simple.ITreeItemFactory;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTree<DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>>
implements ITree<DATATYPE, ITEMTYPE> {
    private final ITEMTYPE m_aRoot;

    public BasicTree(@Nonnull ITreeItemFactory<DATATYPE, ITEMTYPE> iTreeItemFactory) {
        ValueEnforcer.notNull(iTreeItemFactory, "Factory");
        this.m_aRoot = iTreeItemFactory.createRoot();
        if (this.m_aRoot == null) {
            throw new IllegalStateException("Failed to create root item!");
        }
    }

    @Override
    @Nonnull
    public final ITEMTYPE getRootItem() {
        return this.m_aRoot;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BasicTree basicTree = (BasicTree)object;
        return this.m_aRoot.equals(basicTree.m_aRoot);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aRoot).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("root", this.m_aRoot).toString();
    }
}

