/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.parent.impl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.parent.IChildrenProvider;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ChildrenProviderSorting<CHILDTYPE>
implements IChildrenProvider<CHILDTYPE> {
    protected final IChildrenProvider<CHILDTYPE> m_aCR;
    private final Comparator<? super CHILDTYPE> m_aComparator;

    public ChildrenProviderSorting(@Nonnull IChildrenProvider<CHILDTYPE> iChildrenProvider, @Nonnull Comparator<? super CHILDTYPE> comparator) {
        this.m_aCR = ValueEnforcer.notNull(iChildrenProvider, "ChildrenProvider");
        this.m_aComparator = ValueEnforcer.notNull(comparator, "Comparator");
    }

    @Override
    public final boolean hasChildren(@Nullable CHILDTYPE CHILDTYPE) {
        return this.m_aCR.hasChildren(CHILDTYPE);
    }

    @Override
    public final int getChildCount(@Nullable CHILDTYPE CHILDTYPE) {
        return this.m_aCR.getChildCount(CHILDTYPE);
    }

    @Override
    @Nullable
    public List<? extends CHILDTYPE> getChildren(@Nullable CHILDTYPE CHILDTYPE) {
        Collection<CHILDTYPE> collection = this.m_aCR.getChildren(CHILDTYPE);
        return collection == null ? null : ContainerHelper.getSorted(collection, this.m_aComparator);
    }
}

