/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.reader;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IOutputStreamProvider;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.impl.MicroDocument;
import com.phloc.commons.microdom.serialize.MicroReader;
import com.phloc.commons.microdom.serialize.MicroWriter;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.xml.serialize.XMLWriterSettings;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class XMLMapHandler {
    public static final String ELEMENT_MAPPING = "mapping";
    public static final String ELEMENT_MAP = "map";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_VALUE = "value";
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLMapHandler.class);
    private static final XMLMapHandler s_aInstance = new XMLMapHandler();

    private XMLMapHandler() {
    }

    @Nullable
    @ReturnsMutableCopy
    public static Map<String, String> readMap(@Nonnull IInputStreamProvider iInputStreamProvider) {
        ValueEnforcer.notNull(iInputStreamProvider, "InputStreamProvider");
        return XMLMapHandler.readMap(iInputStreamProvider.getInputStream());
    }

    @Nonnull
    public static ESuccess readMap(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(iInputStreamProvider, "InputStreamProvider");
        return XMLMapHandler.readMap(iInputStreamProvider.getInputStream(), map);
    }

    @Nullable
    @ReturnsMutableCopy
    public static Map<String, String> readMap(@Nonnull @WillClose InputStream inputStream) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (XMLMapHandler.readMap(inputStream, hashMap).isFailure()) {
            return null;
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess readMap(@Nonnull @WillClose InputStream inputStream, @Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.notNull(map, "TargetMap");
        try {
            IMicroDocument iMicroDocument = MicroReader.readMicroXML(inputStream);
            if (iMicroDocument != null) {
                XMLMapHandler.readMap(iMicroDocument.getDocumentElement(), map);
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
        }
        catch (Throwable throwable) {
            s_aLogger.warn("Failed to read mapping resource '" + inputStream + "'", throwable);
        }
        finally {
            StreamUtils.close(inputStream);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess readMap(@Nonnull IMicroElement iMicroElement, @Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(iMicroElement, "ParentElement");
        ValueEnforcer.notNull(map, "TargetMap");
        try {
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_MAP)) {
                String string = iMicroElement2.getAttribute(ATTR_KEY);
                if (string == null) {
                    s_aLogger.warn("Ignoring mapping element because key is null");
                    continue;
                }
                String string2 = iMicroElement2.getAttribute(ATTR_VALUE);
                if (string2 == null) {
                    s_aLogger.warn("Ignoring mapping element because value is null");
                    continue;
                }
                if (map.containsKey(string)) {
                    s_aLogger.warn("Key '" + string + "' is already contained - overwriting!");
                }
                map.put(string, string2);
            }
            return ESuccess.SUCCESS;
        }
        catch (Throwable throwable) {
            s_aLogger.warn("Failed to read mapping document", throwable);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public static IMicroDocument createMapDocument(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, "Map");
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement(ELEMENT_MAPPING);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            IMicroElement iMicroElement2 = iMicroElement.appendElement(ELEMENT_MAP);
            iMicroElement2.setAttribute(ATTR_KEY, entry.getKey());
            iMicroElement2.setAttribute(ATTR_VALUE, entry.getValue());
        }
        return microDocument;
    }

    @Nonnull
    public static ESuccess writeMap(@Nonnull Map<String, String> map, @Nonnull IOutputStreamProvider iOutputStreamProvider) {
        ValueEnforcer.notNull(iOutputStreamProvider, "OutputStreamProvider");
        return XMLMapHandler.writeMap(map, iOutputStreamProvider.getOutputStream(EAppend.DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeMap(@Nonnull Map<String, String> map, @Nonnull @WillClose OutputStream outputStream) {
        ValueEnforcer.notNull(map, "Map");
        ValueEnforcer.notNull(outputStream, "OutputStream");
        try {
            IMicroDocument iMicroDocument = XMLMapHandler.createMapDocument(map);
            ESuccess eSuccess = MicroWriter.writeToStream(iMicroDocument, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
            return eSuccess;
        }
        finally {
            StreamUtils.close(outputStream);
        }
    }
}

