/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.jaxb.utils;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.error.IResourceErrorGroup;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.IWritableResource;
import com.phloc.commons.io.streams.NonBlockingStringWriter;
import com.phloc.commons.jaxb.JAXBContextCache;
import com.phloc.commons.jaxb.JAXBMarshallerUtils;
import com.phloc.commons.jaxb.validation.AbstractValidationEventHandler;
import com.phloc.commons.jaxb.validation.CollectingLoggingValidationEventHandlerFactory;
import com.phloc.commons.jaxb.validation.CollectingValidationEventHandler;
import com.phloc.commons.jaxb.validation.IValidationEventHandlerFactory;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.xml.XMLFactory;
import com.phloc.commons.xml.schema.XMLSchemaCache;
import com.phloc.commons.xml.transform.TransformResultFactory;
import com.phloc.commons.xml.transform.TransformSourceFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

@NotThreadSafe
public abstract class AbstractJAXBMarshaller<JAXBTYPE> {
    public static final boolean DEFAULT_FORMATTED = false;
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractJAXBMarshaller.class);
    private final Class<JAXBTYPE> m_aType;
    private final List<IReadableResource> m_aXSDs = new ArrayList<IReadableResource>();
    private IValidationEventHandlerFactory m_aVEHFactory = new CollectingLoggingValidationEventHandlerFactory();
    private ValidationEventHandler m_aLastEventHandler;
    private boolean m_bWriteFormatted = false;

    protected AbstractJAXBMarshaller(@Nonnull Class<JAXBTYPE> clazz, @Nullable IReadableResource iReadableResource) {
        this.m_aType = ValueEnforcer.notNull(clazz, "Type");
        if (iReadableResource != null) {
            this.m_aXSDs.add(iReadableResource);
        }
    }

    protected AbstractJAXBMarshaller(@Nonnull Class<JAXBTYPE> clazz, @Nullable List<? extends IReadableResource> list) {
        this.m_aType = ValueEnforcer.notNull(clazz, "Type");
        if (list != null) {
            ValueEnforcer.notEmptyNoNullValue(list, "XSDs");
            this.m_aXSDs.addAll(list);
        }
    }

    protected AbstractJAXBMarshaller(@Nonnull Class<JAXBTYPE> clazz, IReadableResource ... iReadableResourceArray) {
        this.m_aType = ValueEnforcer.notNull(clazz, "Type");
        if (iReadableResourceArray != null) {
            ValueEnforcer.notEmptyNoNullValue(iReadableResourceArray, "XSDs");
            for (IReadableResource iReadableResource : iReadableResourceArray) {
                this.m_aXSDs.add(iReadableResource);
            }
        }
    }

    public final void setValidationEventHandlerFactory(@Nullable IValidationEventHandlerFactory iValidationEventHandlerFactory) {
        this.m_aVEHFactory = iValidationEventHandlerFactory;
    }

    @Nullable
    public final IValidationEventHandlerFactory getValidationEventHandlerFactory() {
        return this.m_aVEHFactory;
    }

    @Nullable
    public final ValidationEventHandler getLastValidationEventHandler() {
        return this.m_aLastEventHandler;
    }

    @Nullable
    public final CollectingValidationEventHandler getCollectingValidationEventHandler() {
        ValidationEventHandler validationEventHandler = this.m_aLastEventHandler;
        while (validationEventHandler != null) {
            if (validationEventHandler instanceof CollectingValidationEventHandler) {
                return (CollectingValidationEventHandler)validationEventHandler;
            }
            if (validationEventHandler instanceof AbstractValidationEventHandler) {
                validationEventHandler = ((AbstractValidationEventHandler)validationEventHandler).getWrappedHandler();
                continue;
            }
            validationEventHandler = null;
        }
        return null;
    }

    @Nullable
    public final IResourceErrorGroup getLastValidationErrors() {
        CollectingValidationEventHandler collectingValidationEventHandler = this.getCollectingValidationEventHandler();
        return collectingValidationEventHandler == null ? null : collectingValidationEventHandler.getResourceErrors();
    }

    @Nonnull
    public final EChange clearLastValidationErrors() {
        CollectingValidationEventHandler collectingValidationEventHandler = this.getCollectingValidationEventHandler();
        return collectingValidationEventHandler == null ? EChange.UNCHANGED : collectingValidationEventHandler.clearResourceErrors();
    }

    @Nonnull
    public final EChange setWriteFormatted(boolean bl) {
        if (bl == this.m_bWriteFormatted) {
            return EChange.UNCHANGED;
        }
        this.m_bWriteFormatted = bl;
        return EChange.CHANGED;
    }

    public final boolean isWriteFormatted() {
        return this.m_bWriteFormatted;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public final List<IReadableResource> getOriginalXSDs() {
        return ContainerHelper.newList(this.m_aXSDs);
    }

    @OverrideOnDemand
    protected boolean useJAXBContextCache() {
        return true;
    }

    @Nullable
    @OverrideOnDemand
    protected Schema createValidationSchema() {
        return this.m_aXSDs.isEmpty() ? null : XMLSchemaCache.getInstance().getSchema(this.m_aXSDs);
    }

    @Nonnull
    private Unmarshaller _createUnmarshaller() throws JAXBException {
        Package package_ = this.m_aType.getPackage();
        JAXBContext jAXBContext = this.useJAXBContextCache() ? (JAXBContext)JAXBContextCache.getInstance().getFromCache(package_) : JAXBContext.newInstance((String)package_.getName());
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        if (this.m_aVEHFactory != null) {
            this.m_aLastEventHandler = this.m_aVEHFactory.create(unmarshaller.getEventHandler());
            unmarshaller.setEventHandler(this.m_aLastEventHandler);
        } else {
            this.m_aLastEventHandler = null;
        }
        Schema schema = this.createValidationSchema();
        if (schema != null) {
            unmarshaller.setSchema(schema);
        }
        return unmarshaller;
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        return this.read(TransformSourceFactory.create(file));
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull(iReadableResource, "Resource");
        return this.read(TransformSourceFactory.create(iReadableResource));
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull InputStream inputStream) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        return this.read(TransformSourceFactory.create(inputStream));
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull Node node) {
        ValueEnforcer.notNull(node, "Node");
        return this.read(TransformSourceFactory.create(node));
    }

    @OverrideOnDemand
    protected void customizeUnmarshaller(@Nonnull Unmarshaller unmarshaller) {
    }

    @OverrideOnDemand
    protected void handleReadException(@Nonnull JAXBException jAXBException) {
        if (jAXBException instanceof UnmarshalException) {
            Throwable throwable = ((UnmarshalException)jAXBException).getLinkedException();
            if (throwable instanceof SAXParseException) {
                s_aLogger.error("Failed to parse XML document: " + throwable.getMessage());
            } else {
                s_aLogger.error("Unmarshal exception reading document", (Throwable)jAXBException);
            }
        } else {
            s_aLogger.warn("JAXB Exception reading document", (Throwable)jAXBException);
        }
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull Source source) {
        ValueEnforcer.notNull(source, "Source");
        try {
            Unmarshaller unmarshaller = this._createUnmarshaller();
            this.customizeUnmarshaller(unmarshaller);
            return (JAXBTYPE)unmarshaller.unmarshal(source, this.m_aType).getValue();
        }
        catch (JAXBException jAXBException) {
            this.handleReadException(jAXBException);
            return null;
        }
    }

    @Nonnull
    private Marshaller _createMarshaller() throws JAXBException {
        Package package_ = this.m_aType.getPackage();
        JAXBContext jAXBContext = this.useJAXBContextCache() ? (JAXBContext)JAXBContextCache.getInstance().getFromCache(package_) : JAXBContext.newInstance((String)package_.getName());
        Marshaller marshaller = jAXBContext.createMarshaller();
        if (this.m_aVEHFactory != null) {
            this.m_aLastEventHandler = this.m_aVEHFactory.create(marshaller.getEventHandler());
            marshaller.setEventHandler(this.m_aLastEventHandler);
        } else {
            this.m_aLastEventHandler = null;
        }
        JAXBMarshallerUtils.setFormattedOutput(marshaller, this.m_bWriteFormatted);
        Schema schema = this.createValidationSchema();
        if (schema != null) {
            marshaller.setSchema(schema);
        }
        return marshaller;
    }

    @Nonnull
    protected abstract JAXBElement<JAXBTYPE> wrapObject(@Nonnull JAXBTYPE var1);

    @Nullable
    public final Document write(@Nonnull JAXBTYPE JAXBTYPE) {
        ValueEnforcer.notNull(JAXBTYPE, "Object");
        Document document = XMLFactory.newDocument();
        return this.write(JAXBTYPE, TransformResultFactory.create(document)).isSuccess() ? document : null;
    }

    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull File file) {
        return this.write(JAXBTYPE, TransformResultFactory.create(file));
    }

    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull IWritableResource iWritableResource) {
        return this.write(JAXBTYPE, TransformResultFactory.create(iWritableResource));
    }

    @OverrideOnDemand
    protected void customizeMarshaller(@Nonnull Marshaller marshaller) {
    }

    @OverrideOnDemand
    protected void handleWriteException(@Nonnull JAXBException jAXBException) {
        if (jAXBException instanceof MarshalException) {
            s_aLogger.error("Marshal exception writing object", (Throwable)jAXBException);
        } else {
            s_aLogger.warn("JAXB Exception writing object", (Throwable)jAXBException);
        }
    }

    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE JAXBTYPE, @Nonnull Result result) {
        ValueEnforcer.notNull(JAXBTYPE, "Object");
        ValueEnforcer.notNull(result, "Result");
        try {
            Marshaller marshaller = this._createMarshaller();
            this.customizeMarshaller(marshaller);
            JAXBElement<JAXBTYPE> jAXBElement = this.wrapObject(JAXBTYPE);
            marshaller.marshal(jAXBElement, result);
            return ESuccess.SUCCESS;
        }
        catch (JAXBException jAXBException) {
            this.handleWriteException(jAXBException);
            return ESuccess.FAILURE;
        }
    }

    @Nullable
    public final String getAsXMLString(@Nonnull JAXBTYPE JAXBTYPE) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter();
        return this.write(JAXBTYPE, new StreamResult(nonBlockingStringWriter)).isSuccess() ? nonBlockingStringWriter.getAsString() : null;
    }
}

