/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resource;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ClassPathResource
implements IReadableResource {
    public static final String CLASSPATH_PREFIX_LONG = "classpath:";
    public static final String CLASSPATH_PREFIX_SHORT = "cp:";
    private String m_sPath;
    private final WeakReference<ClassLoader> m_aClassLoader;
    private boolean m_bURLResolved = false;
    private URL m_aURL;

    public ClassPathResource(@Nonnull URL uRL) {
        this(uRL, null);
    }

    public ClassPathResource(@Nonnull URL uRL, @Nullable ClassLoader classLoader) {
        this(uRL.toExternalForm(), classLoader);
    }

    public ClassPathResource(@Nonnull @Nonempty String string) {
        this(string, null);
    }

    public ClassPathResource(@Nonnull @Nonempty String string, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notEmpty(string, "Path");
        this.m_sPath = ClassPathResource.getWithoutClassPathPrefix(string);
        if (StringHelper.hasNoText(this.m_sPath)) {
            throw new IllegalArgumentException("No path specified after prefix: " + string);
        }
        this.m_aClassLoader = classLoader == null ? null : new WeakReference<ClassLoader>(classLoader);
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        if (this.m_aClassLoader != null) {
            throw new IOException("Cannot serialize a ClassPathResource that has a specific ClassLoader!");
        }
        objectOutputStream.writeUTF(this.m_sPath);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
        this.m_sPath = objectInputStream.readUTF();
    }

    @Nullable
    public static String getWithoutClassPathPrefix(@Nullable String string) {
        if (StringHelper.startsWith((CharSequence)string, CLASSPATH_PREFIX_LONG)) {
            return string.substring(CLASSPATH_PREFIX_LONG.length());
        }
        if (StringHelper.startsWith((CharSequence)string, CLASSPATH_PREFIX_SHORT)) {
            return string.substring(CLASSPATH_PREFIX_SHORT.length());
        }
        return string;
    }

    public static boolean isExplicitClassPathResource(@Nullable String string) {
        return StringHelper.startsWith((CharSequence)string, CLASSPATH_PREFIX_LONG) || StringHelper.startsWith((CharSequence)string, CLASSPATH_PREFIX_SHORT);
    }

    @Nullable
    private ClassLoader _getSpecifiedClassLoader() {
        return this.m_aClassLoader == null ? null : (ClassLoader)this.m_aClassLoader.get();
    }

    @Override
    @Nonnull
    public String getResourceID() {
        URL uRL = this.getAsURL();
        return uRL == null ? this.m_sPath : uRL.toExternalForm();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getPath() {
        return this.m_sPath;
    }

    @Nullable
    private static InputStream _asInputStream(@Nullable URL uRL) {
        return uRL == null ? null : URLResource.getInputStream(uRL);
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull @Nonempty String string) {
        URL uRL = ClassPathResource.getAsURL(string);
        return ClassPathResource._asInputStream(uRL);
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull @Nonempty String string, @Nonnull ClassLoader classLoader) {
        URL uRL = ClassPathResource.getAsURL(string, classLoader);
        return ClassPathResource._asInputStream(uRL);
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        URL uRL = this.getAsURL();
        return ClassPathResource._asInputStream(uRL);
    }

    @Nullable
    public InputStream getInputStreamNoCache(@Nonnull ClassLoader classLoader) {
        URL uRL = this.getAsURLNoCache(classLoader);
        return ClassPathResource._asInputStream(uRL);
    }

    @Override
    @Nullable
    @Deprecated
    public Reader getReader(@Nonnull String string) {
        return StreamUtils.createReader(this.getInputStream(), string);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull Charset charset) {
        return StreamUtils.createReader(this.getInputStream(), charset);
    }

    @Nullable
    @Deprecated
    public Reader getReaderNoCache(@Nonnull ClassLoader classLoader, @Nonnull String string) {
        return StreamUtils.createReader(this.getInputStreamNoCache(classLoader), string);
    }

    @Nullable
    public Reader getReaderNoCache(@Nonnull ClassLoader classLoader, @Nonnull Charset charset) {
        return StreamUtils.createReader(this.getInputStreamNoCache(classLoader), charset);
    }

    @Override
    public boolean exists() {
        return this.getAsURL() != null;
    }

    public boolean existsNoCacheUsage() {
        return ClassPathResource.getAsURL(this.m_sPath) != null;
    }

    @Nullable
    public static URL getAsURL(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = string.startsWith("/") ? string : '/' + string;
        URL uRL = ClassHelper.getDefaultClassLoader().getResource(string2);
        if (uRL == null && (uRL = ClassPathResource.class.getResource(string2)) == null) {
            uRL = ClassLoader.getSystemClassLoader().getResource(string2);
        }
        return uRL;
    }

    @Nullable
    public static URL getAsURL(@Nonnull @Nonempty String string, @Nonnull ClassLoader classLoader) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = string.startsWith("/") ? string : '/' + string;
        return classLoader.getResource(string2);
    }

    @Override
    @Nullable
    public URL getAsURL() {
        if (!this.m_bURLResolved) {
            ClassLoader classLoader = this._getSpecifiedClassLoader();
            this.m_aURL = classLoader == null ? ClassPathResource.getAsURL(this.m_sPath) : ClassPathResource.getAsURL(this.m_sPath, classLoader);
            this.m_bURLResolved = true;
        }
        return this.m_aURL;
    }

    @Nullable
    public URL getAsURLNoCache(@Nonnull ClassLoader classLoader) {
        return ClassPathResource.getAsURL(this.m_sPath, classLoader);
    }

    @Nullable
    private static File _getAsFile(@Nullable URL uRL) {
        if (uRL != null) {
            try {
                return URLResource.getAsFile(uRL);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static File getAsFile(@Nonnull @Nonempty String string) {
        URL uRL = ClassPathResource.getAsURL(string);
        return ClassPathResource._getAsFile(uRL);
    }

    @Nullable
    public static File getAsFile(@Nonnull @Nonempty String string, @Nonnull ClassLoader classLoader) {
        URL uRL = ClassPathResource.getAsURL(string, classLoader);
        return ClassPathResource._getAsFile(uRL);
    }

    @Override
    @Nullable
    public File getAsFile() {
        URL uRL = this.getAsURL();
        return ClassPathResource._getAsFile(uRL);
    }

    @Nullable
    public File getAsFileNoCache(@Nonnull ClassLoader classLoader) {
        URL uRL = this.getAsURLNoCache(classLoader);
        return ClassPathResource._getAsFile(uRL);
    }

    public static boolean canRead(@Nonnull @Nonempty String string) {
        return ClassPathResource.getAsURL(string) != null;
    }

    public static boolean canRead(@Nonnull @Nonempty String string, @Nonnull ClassLoader classLoader) {
        return ClassPathResource.getAsURL(string, classLoader) != null;
    }

    public boolean canRead() {
        return this.getAsURL() != null;
    }

    public boolean canReadNoCache(@Nonnull ClassLoader classLoader) {
        return this.getAsURLNoCache(classLoader) != null;
    }

    @Override
    @Nonnull
    public ClassPathResource getReadableCloneForPath(@Nonnull String string) {
        return new ClassPathResource(string, this._getSpecifiedClassLoader());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ClassPathResource)) {
            return false;
        }
        ClassPathResource classPathResource = (ClassPathResource)object;
        return EqualsUtils.equals(this.m_sPath, classPathResource.m_sPath) && EqualsUtils.equals(this._getSpecifiedClassLoader(), classPathResource._getSpecifiedClassLoader());
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPath).append(this.m_aClassLoader).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("cpPath", this.m_sPath).appendIfNotNull("classLoader", this._getSpecifiedClassLoader()).append("urlResolved", this.m_bURLResolved).append("URL", this.m_aURL).toString();
    }
}

