/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FilenameFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterEqualsIgnoreCase
implements FilenameFilter {
    private final String m_sFilename;

    public FilenameFilterEqualsIgnoreCase(@Nonnull @Nonempty String string) {
        this.m_sFilename = ValueEnforcer.notEmpty(string, "Filename");
    }

    @Nonnull
    public String getFilename() {
        return this.m_sFilename;
    }

    @Override
    public boolean accept(@Nullable File file, @Nullable String string) {
        String string2 = FilenameHelper.getSecureFilename(string);
        return string2 != null && string2.equalsIgnoreCase(this.m_sFilename);
    }

    public String toString() {
        return new ToStringGenerator(this).append("filename", this.m_sFilename).toString();
    }
}

