/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.idfactory;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.idfactory.ILongIDFactory;
import com.phloc.commons.idfactory.IStringIDFactory;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;

public class StringIDFromLongIDFactory
implements IStringIDFactory {
    private final ILongIDFactory m_aLongIDFactory;
    private final String m_sPrefix;

    public StringIDFromLongIDFactory(@Nonnull ILongIDFactory iLongIDFactory) {
        this(iLongIDFactory, "id");
    }

    public StringIDFromLongIDFactory(@Nonnull ILongIDFactory iLongIDFactory, @Nonnull String string) {
        this.m_aLongIDFactory = ValueEnforcer.notNull(iLongIDFactory, "LongIDFactory");
        this.m_sPrefix = ValueEnforcer.notNull(string, "Prefix");
    }

    @Nonnull
    public ILongIDFactory getLongIDFactory() {
        return this.m_aLongIDFactory;
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    @Nonnull
    public String getNewID() {
        return this.m_sPrefix + Long.toString(this.m_aLongIDFactory.getNewID());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StringIDFromLongIDFactory stringIDFromLongIDFactory = (StringIDFromLongIDFactory)object;
        return this.m_aLongIDFactory.equals(stringIDFromLongIDFactory.m_aLongIDFactory) && this.m_sPrefix.equals(stringIDFromLongIDFactory.m_sPrefix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aLongIDFactory).append(this.m_sPrefix).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("longIDFactory", this.m_aLongIDFactory).append("prefix", this.m_sPrefix).toString();
    }
}

