/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.support;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.readystatesoftware.chuck.R;
import com.readystatesoftware.chuck.internal.data.HttpHeader;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.support.JsonConvertor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.InputSource;

public class FormatUtils {
    public static String formatHeaders(List<HttpHeader> httpHeaders, boolean withMarkup) {
        String out = "";
        if (httpHeaders != null) {
            for (HttpHeader header : httpHeaders) {
                out = out + (withMarkup ? "<b>" : "") + header.getName() + ": " + (withMarkup ? "</b>" : "") + header.getValue() + (withMarkup ? "<br />" : "\n");
            }
        }
        return out;
    }

    public static JSONObject getJsonFormattedHeaders(List<HttpHeader> httpHeaders) {
        JSONObject out = new JSONObject();
        if (httpHeaders != null) {
            for (HttpHeader header : httpHeaders) {
                try {
                    out.put(header.getName(), (Object)header.getValue());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return out;
    }

    public static String formatByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format(Locale.US, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String formatJson(String json) {
        try {
            JsonParser jp = new JsonParser();
            JsonElement je = jp.parse(json);
            return JsonConvertor.getInstance().toJson(je);
        }
        catch (Exception e) {
            return json;
        }
    }

    public static String formatXml(String xml) {
        try {
            Transformer serializer = SAXTransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            SAXSource xmlSource = new SAXSource(new InputSource(new ByteArrayInputStream(xml.getBytes())));
            StreamResult res = new StreamResult(new ByteArrayOutputStream());
            serializer.transform(xmlSource, res);
            return new String(((ByteArrayOutputStream)res.getOutputStream()).toByteArray());
        }
        catch (Exception e) {
            return xml;
        }
    }

    public static String getShareText(Context context, HttpTransaction transaction) {
        String text = "";
        text = text + context.getString(R.string.chuck_url) + ": " + FormatUtils.v(transaction.getUrl()) + "\n";
        text = text + context.getString(R.string.chuck_method) + ": " + FormatUtils.v(transaction.getMethod()) + "\n";
        text = text + context.getString(R.string.chuck_protocol) + ": " + FormatUtils.v(transaction.getProtocol()) + "\n";
        text = text + context.getString(R.string.chuck_status) + ": " + FormatUtils.v(transaction.getStatus().toString()) + "\n";
        text = text + context.getString(R.string.chuck_response) + ": " + FormatUtils.v(transaction.getResponseSummaryText()) + "\n";
        text = text + context.getString(R.string.chuck_ssl) + ": " + FormatUtils.v(context.getString(transaction.isSsl() ? R.string.chuck_yes : R.string.chuck_no)) + "\n";
        text = text + "\n";
        text = text + context.getString(R.string.chuck_request_time) + ": " + FormatUtils.v(transaction.getRequestDateString()) + "\n";
        text = text + context.getString(R.string.chuck_response_time) + ": " + FormatUtils.v(transaction.getResponseDateString()) + "\n";
        text = text + context.getString(R.string.chuck_duration) + ": " + FormatUtils.v(transaction.getDurationString()) + "\n";
        text = text + "\n";
        text = text + context.getString(R.string.chuck_request_size) + ": " + FormatUtils.v(transaction.getRequestSizeString()) + "\n";
        text = text + context.getString(R.string.chuck_response_size) + ": " + FormatUtils.v(transaction.getResponseSizeString()) + "\n";
        text = text + context.getString(R.string.chuck_total_size) + ": " + FormatUtils.v(transaction.getTotalSizeString()) + "\n";
        text = text + "\n";
        text = text + "---------- " + context.getString(R.string.chuck_request) + " ----------\n\n";
        String headers = FormatUtils.formatHeaders(transaction.getRequestHeaders(), false);
        if (!TextUtils.isEmpty((CharSequence)headers)) {
            text = text + headers + "\n";
        }
        text = text + (transaction.requestBodyIsPlainText() ? FormatUtils.v(transaction.getFormattedRequestBody()) : context.getString(R.string.chuck_body_omitted));
        text = text + "\n\n";
        text = text + "---------- " + context.getString(R.string.chuck_response) + " ----------\n\n";
        headers = FormatUtils.formatHeaders(transaction.getResponseHeaders(), false);
        if (!TextUtils.isEmpty((CharSequence)headers)) {
            text = text + headers + "\n";
        }
        text = text + (transaction.responseBodyIsPlainText() ? FormatUtils.v(transaction.getFormattedResponseBody()) : context.getString(R.string.chuck_body_omitted));
        return text;
    }

    public static JSONObject getJsonFormattedShareText(Context context, HttpTransaction transaction) {
        JSONObject root = new JSONObject();
        try {
            JSONObject info = new JSONObject();
            info.put(context.getString(R.string.chuck_url), (Object)FormatUtils.v(transaction.getUrl()));
            info.put(context.getString(R.string.chuck_method), (Object)FormatUtils.v(transaction.getMethod()));
            info.put(context.getString(R.string.chuck_protocol), (Object)FormatUtils.v(transaction.getProtocol()));
            info.put(context.getString(R.string.chuck_status), (Object)FormatUtils.v(transaction.getStatus().toString()));
            info.put(context.getString(R.string.chuck_response), (Object)FormatUtils.v(transaction.getResponseSummaryText()));
            info.put(context.getString(R.string.chuck_ssl), (Object)FormatUtils.v(context.getString(transaction.isSsl() ? R.string.chuck_yes : R.string.chuck_no)));
            info.put(context.getString(R.string.chuck_request_time), (Object)FormatUtils.v(transaction.getRequestDateString()));
            info.put(context.getString(R.string.chuck_response_time), (Object)FormatUtils.v(transaction.getResponseDateString()));
            info.put(context.getString(R.string.chuck_duration), (Object)FormatUtils.v(transaction.getDurationString()));
            info.put(context.getString(R.string.chuck_request_size), (Object)FormatUtils.v(transaction.getRequestSizeString()));
            info.put(context.getString(R.string.chuck_response_size), (Object)FormatUtils.v(transaction.getResponseSizeString()));
            info.put(context.getString(R.string.chuck_total_size), (Object)FormatUtils.v(transaction.getTotalSizeString()));
            root.put("info", (Object)info);
            JSONObject request = new JSONObject();
            request.put("request_headers", (Object)FormatUtils.getJsonFormattedHeaders(transaction.getRequestHeaders()));
            request.put("request_body", transaction.requestBodyIsPlainText() && !TextUtils.isEmpty((CharSequence)transaction.getRequestBody()) ? new JSONObject(FormatUtils.v(transaction.getRequestBody())) : context.getString(R.string.chuck_body_omitted));
            root.put("request", (Object)request);
            JSONObject response = new JSONObject();
            response.put("response_headers", (Object)FormatUtils.getJsonFormattedHeaders(transaction.getResponseHeaders()));
            response.put("response_body", transaction.responseBodyIsPlainText() && !TextUtils.isEmpty((CharSequence)transaction.getResponseBody()) ? new JSONObject(FormatUtils.v(transaction.getResponseBody())) : context.getString(R.string.chuck_body_omitted));
            root.put("response", (Object)response);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return root;
    }

    public static String getShareCurlCommand(HttpTransaction transaction) {
        boolean compressed = false;
        String curlCmd = "curl";
        curlCmd = curlCmd + " -X " + transaction.getMethod();
        List<HttpHeader> headers = transaction.getRequestHeaders();
        int count = headers.size();
        for (int i = 0; i < count; ++i) {
            String name = headers.get(i).getName();
            String value = headers.get(i).getValue();
            if ("Accept-Encoding".equalsIgnoreCase(name) && "gzip".equalsIgnoreCase(value)) {
                compressed = true;
            }
            curlCmd = curlCmd + " -H \"" + name + ": " + value + "\"";
        }
        String requestBody = transaction.getHashedRequestBody();
        if (requestBody != null && requestBody.length() > 0) {
            curlCmd = curlCmd + " --data $'" + requestBody.replace("\n", "\\n") + "'";
        }
        curlCmd = curlCmd + (compressed ? " --compressed " : " ") + transaction.getUrl();
        return curlCmd;
    }

    private static String v(String string2) {
        return string2 != null ? string2 : "";
    }

    public static String encodeBase64(byte[] bytes) {
        try {
            return Base64.encodeToString((byte[])bytes, (int)0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] decodeBase64(String value) {
        try {
            return Base64.decode((String)value, (int)0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}

