/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.support;

import android.content.Context;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.widget.Toast;
import com.readystatesoftware.chuck.internal.data.ChuckContentProvider;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.data.LocalCupboard;
import com.readystatesoftware.chuck.internal.support.AppExecutors;
import com.readystatesoftware.chuck.internal.support.ExportUtils;
import com.readystatesoftware.chuck.internal.support.FormatUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJG\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\f2\u000e\b\u0001\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\fH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/readystatesoftware/chuck/internal/support/ExportUtils;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "delete", "", "appExecutors", "Lcom/readystatesoftware/chuck/internal/support/AppExecutors;", "export", "mProjection", "", "", "mSelection", "mSelectionArgs", "mSortOrder", "(Lcom/readystatesoftware/chuck/internal/support/AppExecutors;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)V", "getPrivateStorageDirectory", "Ljava/io/File;", "directoryName", "isExternalStorageWritable", "", "library_release"})
public final class ExportUtils {
    private final Context context;

    public final void export(@NotNull AppExecutors appExecutors, @Nullable @NotNull String[] mProjection, @Nullable @NotNull String mSelection, @Nullable @NotNull String[] mSelectionArgs, @Nullable @NotNull String mSortOrder) {
        Intrinsics.checkParameterIsNotNull((Object)appExecutors, (String)"appExecutors");
        Intrinsics.checkParameterIsNotNull((Object)mProjection, (String)"mProjection");
        Intrinsics.checkParameterIsNotNull((Object)mSelection, (String)"mSelection");
        Intrinsics.checkParameterIsNotNull((Object)mSelectionArgs, (String)"mSelectionArgs");
        Intrinsics.checkParameterIsNotNull((Object)mSortOrder, (String)"mSortOrder");
        appExecutors.diskIO().execute(new Runnable(this, mProjection, mSelection, mSelectionArgs, mSortOrder, appExecutors){
            final /* synthetic */ ExportUtils this$0;
            final /* synthetic */ String[] $mProjection;
            final /* synthetic */ String $mSelection;
            final /* synthetic */ String[] $mSelectionArgs;
            final /* synthetic */ String $mSortOrder;
            final /* synthetic */ AppExecutors $appExecutors;

            /*
             * Unable to fully structure code
             */
            public final void run() {
                block7: {
                    block8: {
                        if (!ExportUtils.access$isExternalStorageWritable(this.this$0)) break block7;
                        v0 = ExportUtils.access$getContext$p(this.this$0).getContentResolver().query(ChuckContentProvider.TRANSACTION_URI, this.$mProjection, this.$mSelection, this.$mSelectionArgs, this.$mSortOrder);
                        if (v0 == null) {
                            return;
                        }
                        cursor = v0;
                        cursor.moveToFirst();
                        transactions = LocalCupboard.getInstance().withCursor(cursor).list(HttpTransaction.class);
                        v1 = directory = ExportUtils.access$getPrivateStorageDirectory(this.this$0, ExportUtils.access$getContext$p(this.this$0), "feeds-capture");
                        if (v1 == null) break block8;
                        it = var4_4 = v1;
                        $i$a$-let-ExportUtils$export$1$1 = false;
                        dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm", Locale.getDefault());
                        var8_8 = transactions.iterator();
                        while (var8_8.hasNext()) {
                            block12: {
                                block13: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                v2 = transaction = (HttpTransaction)var8_8.next();
                                                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"transaction");
                                                v3 = v2.getPath();
                                                if (v3 == null) break block9;
                                                var10_10 = v3;
                                                var11_11 = "[^a-zA-Z0-9\\.\\-]";
                                                var12_12 = "_";
                                                v3 = (var11_11 = new Regex(var11_11)).replace(var10_10, var12_12);
                                                if (v3 != null) break block10;
                                            }
                                            v3 = "";
                                        }
                                        formattedUrl = v3;
                                        prefix = dateFormat.format(new Date()) + '_' + formattedUrl;
                                        if (transaction.getResponseCode() == null || Intrinsics.compare((int)transaction.getResponseCode(), (int)500) < 0) break block11;
                                        v4 = prefix + "_ERROR_500";
                                        break block12;
                                    }
                                    if (transaction.getResponseCode() == null || Intrinsics.compare((int)transaction.getResponseCode(), (int)400) < 0) break block13;
                                    v4 = prefix + "_ERROR_400";
                                    break block12;
                                }
                                if (transaction.getResponseCode() == null) ** GOTO lbl-1000
                                v5 = transaction.getMalformedJson();
                                if (v5 != null && v5 == 1) {
                                    v4 = prefix + "_MALFORMED";
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v4 = prefix;
                                }
                            }
                            fileName = v4;
                            file = new File(it, fileName + ".json");
                            v6 = FormatUtils.getJsonFormattedShareText(ExportUtils.access$getContext$p(this.this$0), transaction).toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"FormatUtils.getJsonForma\u2026, transaction).toString()");
                            FilesKt.writeText$default((File)file, (String)v6, null, (int)2, null);
                        }
                        this.$appExecutors.mainThread().execute(new Runnable(this, transactions){
                            final /* synthetic */ export.1 this$0;
                            final /* synthetic */ List $transactions$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$transactions$inlined = list;
                            }

                            public final void run() {
                                Toast.makeText((Context)ExportUtils.access$getContext$p(this.this$0.this$0), (CharSequence)"All transactions logged successfully: check your 'feeds-capture' folder", (int)1).show();
                            }
                        });
                    }
                    cursor.close();
                }
            }
            {
                this.this$0 = exportUtils;
                this.$mProjection = stringArray;
                this.$mSelection = string2;
                this.$mSelectionArgs = stringArray2;
                this.$mSortOrder = string3;
                this.$appExecutors = appExecutors;
            }
        });
    }

    public final void delete(@NotNull AppExecutors appExecutors) {
        Intrinsics.checkParameterIsNotNull((Object)appExecutors, (String)"appExecutors");
        appExecutors.diskIO().execute(new Runnable(this, appExecutors){
            final /* synthetic */ ExportUtils this$0;
            final /* synthetic */ AppExecutors $appExecutors;

            public final void run() {
                if (ExportUtils.access$isExternalStorageWritable(this.this$0)) {
                    File directory;
                    File file = directory = ExportUtils.access$getPrivateStorageDirectory(this.this$0, ExportUtils.access$getContext$p(this.this$0), "feeds-capture");
                    if (file != null) {
                        FilesKt.deleteRecursively((File)file);
                    }
                    this.$appExecutors.mainThread().execute(new Runnable(this){
                        final /* synthetic */ delete.1 this$0;

                        public final void run() {
                            Toast.makeText((Context)ExportUtils.access$getContext$p(this.this$0.this$0), (CharSequence)"All transactions logs deleted", (int)0).show();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = exportUtils;
                this.$appExecutors = appExecutors;
            }
        });
    }

    private final boolean isExternalStorageWritable() {
        return Intrinsics.areEqual((Object)Environment.getExternalStorageState(), (Object)"mounted");
    }

    private final File getPrivateStorageDirectory(Context context, String directoryName) {
        File file = new File(context.getExternalFilesDir(null), directoryName);
        if (file.mkdirs()) {
            // empty if block
        }
        return file;
    }

    public ExportUtils(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    public static final /* synthetic */ boolean access$isExternalStorageWritable(ExportUtils $this) {
        return $this.isExternalStorageWritable();
    }

    public static final /* synthetic */ Context access$getContext$p(ExportUtils $this) {
        return $this.context;
    }

    public static final /* synthetic */ File access$getPrivateStorageDirectory(ExportUtils $this, Context context, String directoryName) {
        return $this.getPrivateStorageDirectory(context, directoryName);
    }
}

