/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.support;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.readystatesoftware.chuck.ChuckInterceptor;
import com.readystatesoftware.chuck.internal.data.ChuckContentProvider;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class RetentionManager {
    private static final String LOG_TAG = "Chuck";
    private static final String PREFS_NAME = "chuck_preferences";
    private static final String KEY_LAST_CLEANUP = "last_cleanup";
    private static long lastCleanup;
    private final Context context;
    private final long period;
    private final long cleanupFrequency;
    private final SharedPreferences prefs;

    public RetentionManager(Context context, ChuckInterceptor.Period retentionPeriod) {
        this.context = context;
        this.period = this.toMillis(retentionPeriod);
        this.prefs = context.getSharedPreferences(PREFS_NAME, 0);
        this.cleanupFrequency = retentionPeriod == ChuckInterceptor.Period.ONE_HOUR ? TimeUnit.MINUTES.toMillis(30L) : TimeUnit.HOURS.toMillis(2L);
    }

    public synchronized void doMaintenance() {
        long now;
        if (this.period > 0L && this.isCleanupDue(now = new Date().getTime())) {
            Log.i((String)LOG_TAG, (String)"Performing data retention maintenance...");
            this.deleteSince(this.getThreshold(now));
            this.updateLastCleanup(now);
        }
    }

    private long getLastCleanup(long fallback) {
        if (lastCleanup == 0L) {
            lastCleanup = this.prefs.getLong(KEY_LAST_CLEANUP, fallback);
        }
        return lastCleanup;
    }

    private void updateLastCleanup(long time) {
        lastCleanup = time;
        this.prefs.edit().putLong(KEY_LAST_CLEANUP, time).apply();
    }

    private void deleteSince(long threshold) {
        int rows = this.context.getContentResolver().delete(ChuckContentProvider.TRANSACTION_URI, "requestDate <= ?", new String[]{String.valueOf(threshold)});
        Log.i((String)LOG_TAG, (String)(rows + " transactions deleted"));
    }

    private boolean isCleanupDue(long now) {
        return now - this.getLastCleanup(now) > this.cleanupFrequency;
    }

    private long getThreshold(long now) {
        return this.period == 0L ? now : now - this.period;
    }

    private long toMillis(ChuckInterceptor.Period period) {
        switch (period) {
            case ONE_HOUR: {
                return TimeUnit.HOURS.toMillis(1L);
            }
            case ONE_DAY: {
                return TimeUnit.DAYS.toMillis(1L);
            }
            case ONE_WEEK: {
                return TimeUnit.DAYS.toMillis(7L);
            }
        }
        return 0L;
    }
}

