/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.data;

import android.net.Uri;
import com.google.gson.reflect.TypeToken;
import com.readystatesoftware.chuck.internal.data.HttpHeader;
import com.readystatesoftware.chuck.internal.support.FormatUtils;
import com.readystatesoftware.chuck.internal.support.JsonConvertor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import nl.qbusict.cupboard.annotation.Index;
import okhttp3.Headers;

public class HttpTransaction {
    public static final String[] PARTIAL_PROJECTION = new String[]{"_id", "requestDate", "tookMs", "method", "host", "path", "scheme", "requestContentLength", "responseCode", "error", "responseContentLength", "malformedJson"};
    private static final SimpleDateFormat TIME_ONLY_FMT = new SimpleDateFormat("HH:mm:ss", Locale.US);
    private Long _id;
    @Index
    private Date requestDate;
    private Date responseDate;
    private Long tookMs;
    private String protocol;
    private String method;
    private String url;
    private String host;
    private String path;
    private String scheme;
    private Long requestContentLength;
    private String requestContentType;
    private String requestHeaders;
    private String hashedRequestBody;
    private boolean requestBodyIsPlainText = true;
    private Integer responseCode;
    private String responseMessage;
    private String error;
    private Long responseContentLength;
    private String responseContentType;
    private String responseHeaders;
    private String hashedResponseBody;
    private boolean responseBodyIsPlainText = true;
    private Integer malformedJson = 0;

    public Long getId() {
        return this._id;
    }

    public void setId(long id) {
        this._id = id;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(Date requestDate) {
        this.requestDate = requestDate;
    }

    public Date getResponseDate() {
        return this.responseDate;
    }

    public void setResponseDate(Date responseDate) {
        this.responseDate = responseDate;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHashedRequestBody() {
        return this.hashedRequestBody;
    }

    public String getFormattedRequestBody() {
        String body = new String(FormatUtils.decodeBase64(this.hashedRequestBody));
        return this.formatBody(body, this.requestContentType);
    }

    public void setHashedRequestBody(String hashedRequestBody) {
        this.hashedRequestBody = hashedRequestBody;
    }

    public boolean requestBodyIsPlainText() {
        return this.requestBodyIsPlainText;
    }

    public void setRequestBodyIsPlainText(boolean requestBodyIsPlainText) {
        this.requestBodyIsPlainText = requestBodyIsPlainText;
    }

    public Long getRequestContentLength() {
        return this.requestContentLength;
    }

    public void setRequestContentLength(Long requestContentLength) {
        this.requestContentLength = requestContentLength;
    }

    public String getRequestContentType() {
        return this.requestContentType;
    }

    public void setRequestContentType(String requestContentType) {
        this.requestContentType = requestContentType;
    }

    public String getHashedResponseBody() {
        return this.hashedResponseBody;
    }

    public String getFormattedResponseBody() {
        String body = new String(FormatUtils.decodeBase64(this.hashedResponseBody));
        return this.formatBody(body, this.responseContentType);
    }

    public void setHashedResponseBody(String hashedResponseBody) {
        this.hashedResponseBody = hashedResponseBody;
    }

    public boolean responseBodyIsPlainText() {
        return this.responseBodyIsPlainText;
    }

    public void setResponseBodyIsPlainText(boolean responseBodyIsPlainText) {
        this.responseBodyIsPlainText = responseBodyIsPlainText;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    public Long getResponseContentLength() {
        return this.responseContentLength;
    }

    public void setResponseContentLength(Long responseContentLength) {
        this.responseContentLength = responseContentLength;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public Long getTookMs() {
        return this.tookMs;
    }

    public void setTookMs(Long tookMs) {
        this.tookMs = tookMs;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        Uri uri = Uri.parse((String)url);
        this.host = uri.getHost();
        this.path = uri.getPath() + (uri.getQuery() != null ? "?" + uri.getQuery() : "");
        this.scheme = uri.getScheme();
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setRequestHeaders(Headers headers) {
        this.setRequestHeaders(this.toHttpHeaderList(headers));
    }

    public void setRequestHeaders(List<HttpHeader> headers) {
        this.requestHeaders = JsonConvertor.getInstance().toJson(headers);
    }

    public Integer getMalformedJson() {
        return this.malformedJson;
    }

    public void setMalformedJson(Integer malformedJson) {
        this.malformedJson = malformedJson;
    }

    public List<HttpHeader> getRequestHeaders() {
        return (List)JsonConvertor.getInstance().fromJson(this.requestHeaders, new TypeToken<List<HttpHeader>>(){}.getType());
    }

    public String getRequestHeadersString(boolean withMarkup) {
        return FormatUtils.formatHeaders(this.getRequestHeaders(), withMarkup);
    }

    public void setResponseHeaders(Headers headers) {
        this.setResponseHeaders(this.toHttpHeaderList(headers));
    }

    public void setResponseHeaders(List<HttpHeader> headers) {
        this.responseHeaders = JsonConvertor.getInstance().toJson(headers);
    }

    public List<HttpHeader> getResponseHeaders() {
        return (List)JsonConvertor.getInstance().fromJson(this.responseHeaders, new TypeToken<List<HttpHeader>>(){}.getType());
    }

    public String getResponseHeadersString(boolean withMarkup) {
        return FormatUtils.formatHeaders(this.getResponseHeaders(), withMarkup);
    }

    public Status getStatus() {
        if (this.error != null) {
            return Status.Failed;
        }
        if (this.responseCode == null) {
            return Status.Requested;
        }
        return Status.Complete;
    }

    public String getRequestStartTimeString() {
        return this.requestDate != null ? TIME_ONLY_FMT.format(this.requestDate) : null;
    }

    public String getRequestDateString() {
        return this.requestDate != null ? this.requestDate.toString() : null;
    }

    public String getResponseDateString() {
        return this.responseDate != null ? this.responseDate.toString() : null;
    }

    public String getDurationString() {
        return this.tookMs != null ? this.tookMs + " ms" : null;
    }

    public String getRequestSizeString() {
        return this.formatBytes(this.requestContentLength != null ? this.requestContentLength : 0L);
    }

    public String getResponseSizeString() {
        return this.responseContentLength != null ? this.formatBytes(this.responseContentLength) : null;
    }

    public String getTotalSizeString() {
        long reqBytes = this.requestContentLength != null ? this.requestContentLength : 0L;
        long resBytes = this.responseContentLength != null ? this.responseContentLength : 0L;
        return this.formatBytes(reqBytes + resBytes);
    }

    public String getResponseSummaryText() {
        switch (this.getStatus()) {
            case Failed: {
                return this.error;
            }
            case Requested: {
                return null;
            }
        }
        return String.valueOf(this.responseCode) + " " + this.responseMessage;
    }

    public String getNotificationText() {
        switch (this.getStatus()) {
            case Failed: {
                return " ! ! !  " + this.path;
            }
            case Requested: {
                return " . . .  " + this.path;
            }
        }
        return String.valueOf(this.responseCode) + " " + this.path;
    }

    public boolean isSsl() {
        return this.scheme.toLowerCase().equals("https");
    }

    private List<HttpHeader> toHttpHeaderList(Headers headers) {
        ArrayList<HttpHeader> httpHeaders = new ArrayList<HttpHeader>();
        int count = headers.size();
        for (int i = 0; i < count; ++i) {
            httpHeaders.add(new HttpHeader(headers.name(i), headers.value(i)));
        }
        return httpHeaders;
    }

    private String formatBody(String body, String contentType) {
        if (contentType != null && contentType.toLowerCase().contains("json")) {
            return FormatUtils.formatJson(body);
        }
        if (contentType != null && contentType.toLowerCase().contains("xml")) {
            return FormatUtils.formatXml(body);
        }
        return body;
    }

    private String formatBytes(long bytes) {
        return FormatUtils.formatByteCount(bytes, true);
    }

    public static enum Status {
        Requested,
        Complete,
        Failed;

    }
}

