/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.ui;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.readystatesoftware.chuck.R;
import com.readystatesoftware.chuck.internal.data.ChuckContentProvider;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.support.AppExecutors;
import com.readystatesoftware.chuck.internal.support.ExportUtils;
import com.readystatesoftware.chuck.internal.support.NotificationHelper;
import com.readystatesoftware.chuck.internal.support.SQLiteUtils;
import com.readystatesoftware.chuck.internal.support.SettingsManager;
import com.readystatesoftware.chuck.internal.ui.SettingsActivity;
import com.readystatesoftware.chuck.internal.ui.TransactionAdapter;
import java.util.ArrayList;

public class TransactionListFragment
extends Fragment
implements SearchView.OnQueryTextListener,
LoaderManager.LoaderCallbacks<Cursor> {
    private static int ACTIVITY_REQUEST_CODE_SETTINGS = 1234;
    private String currentFilter;
    private OnListFragmentInteractionListener listener;
    private TransactionAdapter adapter;
    private SettingsManager settingsManager;
    private AppExecutors appExecutors;
    private ExportUtils exportUtils;

    public static TransactionListFragment newInstance() {
        return new TransactionListFragment();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
        this.settingsManager = new SettingsManager(this.getContext());
        this.appExecutors = new AppExecutors();
        this.exportUtils = new ExportUtils(this.getContext());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.chuck_fragment_transaction_list, container, false);
        if (view instanceof RecyclerView) {
            Context context = view.getContext();
            RecyclerView recyclerView = (RecyclerView)view;
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.getContext(), 1));
            this.adapter = new TransactionAdapter(this.getContext(), this.listener);
            recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        }
        return view;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof OnListFragmentInteractionListener)) {
            throw new RuntimeException(context.toString() + " must implement OnListFragmentInteractionListener");
        }
        this.listener = (OnListFragmentInteractionListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.chuck_main, menu2);
        MenuItem searchMenuItem = menu2.findItem(R.id.search);
        SearchView searchView = (SearchView)searchMenuItem.getActionView();
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        searchView.setIconifiedByDefault(true);
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.clear) {
            this.getContext().getContentResolver().delete(ChuckContentProvider.TRANSACTION_URI, null, null);
            NotificationHelper.clearBuffer();
            this.exportUtils.delete(this.appExecutors);
            return true;
        }
        if (item.getItemId() == R.id.browse_sql) {
            SQLiteUtils.browseDatabase(this.getContext());
            return true;
        }
        if (item.getItemId() == R.id.settings) {
            if (this.getContext() != null) {
                SettingsActivity.Companion.start(this, ACTIVITY_REQUEST_CODE_SETTINGS);
            }
            return true;
        }
        if (item.getItemId() == R.id.export) {
            this.exportUtils.export(this.appExecutors);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        CursorLoader loader = new CursorLoader(this.getContext());
        loader.setUri(ChuckContentProvider.TRANSACTION_URI);
        StringBuilder finalSelection = new StringBuilder();
        ArrayList<String> settingSelections = new ArrayList<String>();
        String searchSelection = "";
        ArrayList<String> selectionArgs = new ArrayList<String>();
        if (this.settingsManager != null) {
            if (this.settingsManager.isError400FilterEnabled()) {
                settingSelections.add("responseCode LIKE ? ");
                selectionArgs.add("4%");
            }
            if (this.settingsManager.isError500FilterEnabled()) {
                settingSelections.add("responseCode LIKE ? ");
                selectionArgs.add("5%");
            }
            if (this.settingsManager.isErrorMalformedJsonFilterEnabled()) {
                settingSelections.add("malformedJson LIKE ? ");
                selectionArgs.add("1");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.currentFilter)) {
            if (TextUtils.isDigitsOnly((CharSequence)this.currentFilter)) {
                searchSelection = "(responseCode LIKE ? OR path LIKE ?)";
                selectionArgs.add(this.currentFilter + "%");
                selectionArgs.add("%" + this.currentFilter + "%");
            } else {
                searchSelection = "(path LIKE ?)";
                selectionArgs.add("%" + this.currentFilter + "%");
            }
        }
        finalSelection.append(this.buildSettingsSelection(settingSelections));
        finalSelection.append(searchSelection);
        loader.setSelection(finalSelection.toString());
        loader.setSelectionArgs(selectionArgs.toArray(new String[0]));
        loader.setProjection(HttpTransaction.PARTIAL_PROJECTION);
        loader.setSortOrder("requestDate DESC");
        return loader;
    }

    private String buildSettingsSelection(ArrayList<String> settingSelections) {
        StringBuilder result = new StringBuilder();
        if (settingSelections.size() > 0) {
            result.append("(");
        }
        for (int i = 0; i < settingSelections.size(); ++i) {
            result.append(settingSelections.get(i));
            if (i >= settingSelections.size() - 1) continue;
            result.append(" OR ");
        }
        if (settingSelections.size() > 0) {
            result.append(")");
            if (!TextUtils.isEmpty((CharSequence)this.currentFilter)) {
                result.append(" AND ");
            }
        }
        return result.toString();
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        this.adapter.swapCursor(data);
    }

    public void onLoaderReset(Loader<Cursor> loader) {
        this.adapter.swapCursor(null);
    }

    public boolean onQueryTextSubmit(String query) {
        return true;
    }

    public boolean onQueryTextChange(String newText) {
        this.currentFilter = newText;
        this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this);
        return true;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == ACTIVITY_REQUEST_CODE_SETTINGS) {
            this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)this);
        }
    }

    public static interface OnListFragmentInteractionListener {
        public void onListFragmentInteraction(HttpTransaction var1);
    }
}

