/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.PSTFile;
import com.pff.PSTObject;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

class PSTTableItem {
    public static final int VALUE_TYPE_PT_UNICODE = 31;
    public static final int VALUE_TYPE_PT_STRING8 = 30;
    public static final int VALUE_TYPE_PT_BIN = 258;
    public int itemIndex = 0;
    public int entryType = 0;
    public int entryValueType = 0;
    public int entryValueReference = 0;
    public byte[] data = new byte[0];
    public boolean isExternalValueReference = false;
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static SimpleTimeZone utcTimeZone = new SimpleTimeZone(0, "UTC");

    PSTTableItem() {
    }

    public long getLongValue() {
        if (this.data.length > 0) {
            return PSTObject.convertLittleEndianBytesToLong(this.data);
        }
        return -1L;
    }

    public String getStringValue() {
        return this.getStringValue(this.entryValueType);
    }

    public String getStringValue(int stringType) {
        if (stringType == 31) {
            try {
                if (this.isExternalValueReference) {
                    return "External string reference!";
                }
                return new String(this.data, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Error decoding string: " + this.data.toString());
                return "";
            }
        }
        if (stringType == 30) {
            return new String(this.data, Charset.forName("UTF-8"));
        }
        StringBuffer outputBuffer = new StringBuffer();
        StringBuffer hexOut = new StringBuffer();
        for (int y = 0; y < this.data.length; ++y) {
            int valueChar = this.data[y] & 0xFF;
            if (Character.isLetterOrDigit((char)valueChar)) {
                outputBuffer.append((char)valueChar);
                outputBuffer.append(" ");
            } else {
                outputBuffer.append(". ");
            }
            String hexValue = Long.toHexString(valueChar);
            hexOut.append(hexValue);
            hexOut.append(" ");
            if (hexValue.length() <= 1) continue;
            outputBuffer.append(" ");
        }
        outputBuffer.append("\n");
        outputBuffer.append("\t");
        outputBuffer.append(hexOut);
        return new String(outputBuffer);
    }

    public String toString() {
        String ret = PSTFile.getPropertyDescription(this.entryType, this.entryValueType);
        if (this.entryValueType == 11) {
            return ret + (this.entryValueReference == 0 ? "false" : "true");
        }
        if (this.isExternalValueReference) {
            return ret + String.format("0x%08X (%d)", this.entryValueReference, this.entryValueReference);
        }
        if (this.entryValueType == 5 || this.entryValueType == 20) {
            if (this.data == null) {
                return ret + "no data";
            }
            if (this.data.length == 8) {
                long l = PSTObject.convertLittleEndianBytesToLong(this.data, 0, 8);
                return String.format("%s0x%016X (%d)", ret, l, l);
            }
            return String.format("%s invalid data length: %d", ret, this.data.length);
        }
        if (this.entryValueType == 64) {
            int high = (int)PSTObject.convertLittleEndianBytesToLong(this.data, 4, 8);
            int low = (int)PSTObject.convertLittleEndianBytesToLong(this.data, 0, 4);
            Date d = PSTObject.filetimeToDate(high, low);
            dateFormatter.setTimeZone(utcTimeZone);
            return ret + dateFormatter.format(d);
        }
        if (this.entryValueType == 31) {
            String s;
            try {
                s = new String(this.data, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Error decoding string: " + this.data.toString());
                s = "";
            }
            if (s.length() >= 2 && s.charAt(0) == '\u0001') {
                return String.format("%s [%04X][%04X]%s", ret, (short)s.charAt(0), (short)s.charAt(1), s.substring(2));
            }
            return ret + s;
        }
        return ret + this.getStringValue();
    }
}

