/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.util.jaxb;

import com.peterphi.std.util.jaxb.exception.SchemaValidationException;
import com.peterphi.std.util.jaxb.type.MultiXSDSchemaFile;
import com.peterphi.std.util.jaxb.type.MultiXSDSchemaFiles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XSDValidator {
    private static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private final Schema schema;

    public XSDValidator(MultiXSDSchemaFiles schemas) {
        this(XSDValidator.getSources(schemas));
    }

    public XSDValidator(Source ... sources) {
        this(XSDValidator.buildSchema(sources));
    }

    public XSDValidator(Schema schema) {
        this.schema = schema;
    }

    private static Schema buildSchema(Source ... sources) {
        try {
            SchemaFactory factory = SchemaFactory.newInstance(XML_SCHEMA_NAMESPACE);
            return factory.newSchema(sources);
        }
        catch (SAXException e) {
            throw new RuntimeException("Error creating Schema instance!", e);
        }
    }

    private static Source[] getSources(MultiXSDSchemaFiles schemas) {
        return XSDValidator.reorderDependencies(schemas.files).stream().map(XSDValidator::createSource).collect(Collectors.toList()).toArray(new Source[schemas.files.size()]);
    }

    private static List<MultiXSDSchemaFile> reorderDependencies(Collection<MultiXSDSchemaFile> input) {
        ArrayList<MultiXSDSchemaFile> output = new ArrayList<MultiXSDSchemaFile>(input.size());
        Map<MultiXSDSchemaFile, Collection<MultiXSDSchemaFile>> dependencies = XSDValidator.getDependencies(input);
        for (MultiXSDSchemaFile file : input) {
            XSDValidator.emit(output, new HashSet<MultiXSDSchemaFile>(), dependencies, file);
        }
        assert (output.size() == input.size());
        assert (output.containsAll(input));
        return output;
    }

    private static void emit(List<MultiXSDSchemaFile> emitted, Set<MultiXSDSchemaFile> emitting, Map<MultiXSDSchemaFile, Collection<MultiXSDSchemaFile>> dependencies, MultiXSDSchemaFile current) {
        if (!emitted.contains(current)) {
            if (emitting.contains(current)) {
                throw new IllegalArgumentException("Dependency flattening failed: there are loops in schema dependencies! Emitted " + emitted + ", emitting " + emitting + ", dependencies=" + dependencies);
            }
            emitting.add(current);
            for (MultiXSDSchemaFile dependency : dependencies.get(current)) {
                XSDValidator.emit(emitted, emitting, dependencies, dependency);
            }
            emitted.add(current);
        }
    }

    private static Map<MultiXSDSchemaFile, Collection<MultiXSDSchemaFile>> getDependencies(Collection<MultiXSDSchemaFile> input) {
        Map<String, MultiXSDSchemaFile> byName = input.stream().collect(Collectors.toMap(s -> s.name, s -> s));
        HashMap<MultiXSDSchemaFile, Collection<MultiXSDSchemaFile>> output = new HashMap<MultiXSDSchemaFile, Collection<MultiXSDSchemaFile>>();
        for (MultiXSDSchemaFile file : input) {
            Set dependencies = XSDValidator.getDependencies(file).stream().map(byName::get).collect(Collectors.toSet());
            output.put(file, dependencies);
        }
        return output;
    }

    private static Source createSource(MultiXSDSchemaFile schema) {
        return new DOMSource(schema.schemaElement());
    }

    private static List<String> getDependencies(MultiXSDSchemaFile schema) {
        ArrayList<String> dependencies = new ArrayList<String>();
        NodeList children = schema.schemaElement().getElementsByTagNameNS(XML_SCHEMA_NAMESPACE, "import");
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element element = (Element)children.item(i);
            dependencies.add(element.getAttribute("schemaLocation"));
        }
        return dependencies;
    }

    public void validate(Node document) throws SchemaValidationException {
        try {
            Validator validator = this.schema.newValidator();
            validator.validate(new DOMSource(document));
        }
        catch (IOException | SAXException e) {
            throw new SchemaValidationException(e.getMessage(), e);
        }
    }
}

