/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.util.jaxb;

import com.peterphi.std.util.DOMUtils;
import com.peterphi.std.util.jaxb.exception.JAXBRuntimeException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import org.apache.log4j.Logger;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JAXBSerialiser {
    private static final Logger log = Logger.getLogger(JAXBSerialiser.class);
    private final javax.xml.bind.JAXBContext context;
    private Schema schema;
    private boolean prettyOutput = false;
    private String encoding = "UTF-8";
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private boolean fragment = false;

    private JAXBSerialiser(String contextPath) {
        try {
            this.context = javax.xml.bind.JAXBContext.newInstance((String)contextPath);
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException("Error creating JAXB Context: " + e.getMessage(), e);
        }
    }

    private JAXBSerialiser(javax.xml.bind.JAXBContext context) {
        this.context = context;
    }

    private JAXBSerialiser(Class<?> ... classes) {
        try {
            this.context = javax.xml.bind.JAXBContext.newInstance((Class[])classes);
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException("Error creating JAXB Context: " + e.getMessage(), e);
        }
    }

    public javax.xml.bind.JAXBContext getContext() {
        return this.context;
    }

    public JAXBSerialiser setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public JAXBSerialiser setPrettyOutput(boolean pretty) {
        this.prettyOutput = pretty;
        return this;
    }

    public JAXBSerialiser setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public JAXBSerialiser setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
        return this;
    }

    public JAXBSerialiser setNoNamespaceSchemaLocation(String noNamespaceSchemaLocation) {
        this.noNamespaceSchemaLocation = noNamespaceSchemaLocation;
        return this;
    }

    public JAXBSerialiser setFragment(boolean fragment) {
        this.fragment = fragment;
        return this;
    }

    private Marshaller getMarshaller() {
        try {
            Marshaller jaxb = this.context.createMarshaller();
            jaxb.setSchema(this.schema);
            this.setJaxbProperties(jaxb);
            return jaxb;
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException("Error creating marshaller", e);
        }
    }

    private void setJaxbProperties(Marshaller jaxb) throws PropertyException {
        if (this.prettyOutput) {
            jaxb.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        if (this.encoding != null) {
            jaxb.setProperty("jaxb.encoding", (Object)this.encoding);
        }
        if (this.schemaLocation != null) {
            jaxb.setProperty("jaxb.schemaLocation", (Object)this.schemaLocation);
        }
        if (this.noNamespaceSchemaLocation != null) {
            jaxb.setProperty("jaxb.noNamespaceSchemaLocation", (Object)this.noNamespaceSchemaLocation);
        }
        if (this.fragment) {
            jaxb.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
    }

    private Unmarshaller getUnmarshaller() {
        try {
            Unmarshaller jaxb = this.context.createUnmarshaller();
            jaxb.setSchema(this.schema);
            return jaxb;
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException("Error creating unmarshaller", e);
        }
    }

    public Object deserialise(String xml) {
        return this.deserialise(new InputSource(new StringReader(xml)));
    }

    public Object deserialise(InputStream is) {
        return this.deserialise(new InputSource(is));
    }

    public Object deserialise(Reader reader) {
        return this.deserialise(new InputSource(reader));
    }

    public <T> T deserialise(Class<T> clazz, InputSource source) {
        Object obj = this.deserialise(source);
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        throw new JAXBRuntimeException("XML deserialised to " + obj.getClass() + ", could not cast to the expected " + clazz);
    }

    public <T> T deserialise(Class<T> clazz, String xml) {
        Object obj = this.deserialise(new InputSource(new StringReader(xml)));
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        throw new JAXBRuntimeException("XML deserialised to " + obj.getClass() + ", could not cast to the expected " + clazz);
    }

    public Object deserialise(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Null argument passed to deserialise!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file);
        }
        Unmarshaller unmarshaller = this.getUnmarshaller();
        try {
            Object obj = unmarshaller.unmarshal(file);
            if (obj == null) {
                throw new RuntimeException("Malformed XML from " + file);
            }
            return obj;
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException("Deserialisation failed: " + e.getMessage(), e);
        }
    }

    public Object deserialise(InputSource source) {
        if (source == null) {
            throw new IllegalArgumentException("Null argument passed to deserialise!");
        }
        Unmarshaller unmarshaller = this.getUnmarshaller();
        try {
            Object obj = unmarshaller.unmarshal(source);
            if (obj == null) {
                throw new RuntimeException("Malformed XML!");
            }
            return obj;
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException("Deserialisation failed: " + e.getMessage(), e);
        }
    }

    public Object deserialise(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Null argument passed to deserialise!");
        }
        Unmarshaller unmarshaller = this.getUnmarshaller();
        try {
            Object obj = unmarshaller.unmarshal(node);
            if (obj == null) {
                throw new RuntimeException("Error deserialising from " + node);
            }
            return obj;
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException("Deserialisation failed: " + e.getMessage(), e);
        }
    }

    public Document serialiseToDocument(Object obj) {
        Document document = DOMUtils.createDocumentBuilder().newDocument();
        this.serialise(obj, document);
        return document;
    }

    public String serialise(Object obj) {
        Marshaller marshaller = this.getMarshaller();
        try {
            StringWriter w = new StringWriter(1024);
            marshaller.marshal(obj, (Writer)w);
            return w.toString();
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException("serialisation failed: " + e.getMessage(), e);
        }
    }

    public void serialise(Object obj, Writer writer) {
        Marshaller marshaller = this.getMarshaller();
        try {
            marshaller.marshal(obj, writer);
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException("serialisation failed: " + e.getMessage(), e);
        }
    }

    public void serialise(Object obj, OutputStream os) {
        Marshaller marshaller = this.getMarshaller();
        try {
            marshaller.marshal(obj, os);
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException("serialisation failed: " + e.getMessage(), e);
        }
    }

    public void serialise(Object obj, File file) {
        Marshaller marshaller = this.getMarshaller();
        try {
            marshaller.marshal(obj, file);
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException("serialisation failed: " + e.getMessage(), e);
        }
    }

    public void serialise(Object obj, Node node) {
        Marshaller marshaller = this.getMarshaller();
        try {
            marshaller.marshal(obj, node);
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException("serialisation failed: " + e.getMessage(), e);
        }
    }

    public static JAXBSerialiser getInstance(javax.xml.bind.JAXBContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Create serialiser for context " + context));
        }
        return new JAXBSerialiser(context);
    }

    public static JAXBSerialiser getInstance(Class<?> ... classes) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Create serialiser for " + Arrays.asList(classes)));
        }
        return new JAXBSerialiser(classes);
    }

    public static JAXBSerialiser getInstance(String contextPath) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Create serialiser for " + contextPath));
        }
        return new JAXBSerialiser(contextPath);
    }

    public static JAXBSerialiser getMoxy(String contextPath) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Create moxy serialiser for " + contextPath));
        }
        try {
            javax.xml.bind.JAXBContext ctx = JAXBContext.newInstance((String)contextPath);
            return JAXBSerialiser.getInstance(ctx);
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException(e);
        }
    }

    public static JAXBSerialiser getMoxy(Class<?> ... classes) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Create moxy serialiser for " + Arrays.asList(classes)));
        }
        try {
            javax.xml.bind.JAXBContext ctx = JAXBContext.newInstance((Class[])classes);
            return JAXBSerialiser.getInstance(ctx);
        }
        catch (JAXBException e) {
            throw new JAXBRuntimeException(e);
        }
    }
}

