/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.util;

import com.peterphi.std.io.PropertyFile;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ClassManifestLocator {
    private static final Logger log = Logger.getLogger(ClassManifestLocator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyFile get(Class<?> clazz) {
        PropertyFile propertyFile;
        if (clazz.getName().contains("$$EnhancerByGuice$$")) {
            clazz = clazz.getSuperclass();
        }
        String classFileName = clazz.getSimpleName() + ".class";
        String classFilePathAndName = clazz.getName().replace('.', '/') + ".class";
        URL url = clazz.getResource(classFileName);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getResource(" + classFileName + ") = " + url));
        }
        if (url == null) {
            return null;
        }
        String classesUrl = url.toString();
        if ((classesUrl = classesUrl.replace(classFilePathAndName, "")).endsWith("WEB-INF/classes/")) {
            classesUrl = classesUrl.replace("WEB-INF/classes/", "");
        }
        URL manifestURL = new URL(classesUrl + "META-INF/MANIFEST.MF");
        InputStream is = manifestURL.openStream();
        try {
            PropertyFile props = new PropertyFile();
            Manifest manifest = new Manifest(is);
            for (Object key : manifest.getMainAttributes().keySet()) {
                Object value = manifest.getMainAttributes().get(key);
                props.set(key.toString(), value.toString());
            }
            propertyFile = props;
        }
        catch (Throwable throwable) {
            try {
                try {
                    IOUtils.closeQuietly((InputStream)is);
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    log.warn((Object)("Could not find: " + manifestURL), (Throwable)e);
                    return null;
                }
            }
            catch (Throwable t) {
                log.warn((Object)("Error acquiring MANIFEST.MF for " + clazz), t);
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return propertyFile;
    }
}

