/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.threading;

import com.peterphi.std.threading.Timeout;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public final class Deadline
implements Comparable<Deadline>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(Deadline.class);
    public static final Deadline MAX_VALUE = new Deadline(Long.MAX_VALUE);
    private final long deadline;

    public Deadline(Timeout timeout) {
        long now = System.currentTimeMillis();
        long proposed = now + timeout.getMilliseconds();
        this.deadline = proposed >= now ? proposed : Long.MAX_VALUE;
        if (this.deadline < 0L) {
            throw new IllegalStateException("Deadline has a negative value!");
        }
    }

    public Deadline(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Must provide a positive timestamp for deadline!");
        }
        this.deadline = timestamp;
    }

    public Deadline(long timeout, TimeUnit unit) {
        this(new Timeout(timeout, unit));
    }

    public Deadline(Calendar calendar) {
        this(calendar.getTimeInMillis());
    }

    public Deadline(Date date) {
        this(date.getTime());
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.deadline;
    }

    public boolean isValid() {
        return System.currentTimeMillis() < this.deadline;
    }

    public Timeout getTimeoutLeft() {
        long left = this.getTimeLeft();
        if (left != 0L) {
            return new Timeout(left, TimeUnit.MILLISECONDS);
        }
        return Timeout.ZERO;
    }

    public long getTimeLeft() {
        long left = this.deadline - System.currentTimeMillis();
        if (left > 0L) {
            return left;
        }
        return 0L;
    }

    public Date getDate() {
        return new Date(this.deadline);
    }

    public long getTimeLeft(TimeUnit unit) {
        long left = unit.convert(this.getTimeLeft(), TimeUnit.MILLISECONDS);
        if (left > 0L) {
            return left;
        }
        return 0L;
    }

    public Deadline sleep() {
        try {
            Thread.sleep(this.getTimeLeft(TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this;
    }

    public boolean sleep(boolean mayInterrupt) {
        while (this.isValid()) {
            try {
                Thread.sleep(this.getTimeLeft(TimeUnit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                if (!mayInterrupt) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(Object monitor, boolean ignoreInterrupts) {
        Object object = monitor;
        synchronized (object) {
            block5: {
                try {
                    monitor.wait(this.getTimeLeft(TimeUnit.MILLISECONDS));
                }
                catch (InterruptedException e) {
                    if (ignoreInterrupts) break block5;
                    return;
                }
            }
        }
    }

    public <T> T resolveFuture(Future<T> future) throws RuntimeException {
        return this.resolveFuture(future, true);
    }

    public <T> T resolveFuture(Future<T> future, boolean autocancel) throws RuntimeException {
        while (this.isValid() && !future.isCancelled()) {
            try {
                return future.get(this.getTimeLeft(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                try {
                    if (autocancel) {
                        future.cancel(true);
                    }
                }
                catch (Throwable t) {
                    log.info((Object)("{resolveFuture} Error auto-cancelling after ExecutionException: " + t.getMessage()), t);
                }
                throw new RuntimeException(e);
            }
            catch (TimeoutException e) {
                // empty catch block
                break;
            }
        }
        future.cancel(true);
        return null;
    }

    @Override
    public int compareTo(Deadline that) {
        Long thisDeadline = this.deadline;
        return thisDeadline.compareTo(that.deadline);
    }

    public int hashCode() {
        return (int)(this.deadline ^ this.deadline >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(Deadline.class)) {
            Deadline that = (Deadline)o;
            return this.deadline == that.deadline;
        }
        return false;
    }

    public String toString() {
        return "[Deadline " + new Date(this.deadline) + ", msLeft=" + this.getTimeLeft() + "]";
    }

    public static Deadline soonest(Deadline ... deadlines) {
        Deadline min = null;
        if (deadlines != null) {
            for (Deadline deadline : deadlines) {
                if (deadline == null) continue;
                if (min == null) {
                    min = deadline;
                    continue;
                }
                if (deadline.getTimeLeft() >= min.getTimeLeft()) continue;
                min = deadline;
            }
        }
        return min;
    }

    public static Deadline latest(Deadline ... deadlines) {
        Deadline max = null;
        if (deadlines != null) {
            for (Deadline deadline : deadlines) {
                if (max == null) {
                    max = deadline;
                    continue;
                }
                if (deadline.getTimeLeft() <= max.getTimeLeft()) continue;
                max = deadline;
            }
        }
        return max;
    }
}

