/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.threading;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class Daemon
implements Runnable {
    private static final Logger log = Logger.getLogger(Daemon.class);
    private transient Thread thisThread = null;
    private volatile boolean running = false;

    public synchronized Thread startThread() throws IllegalThreadStateException {
        return this.startThread(this.getThreadName());
    }

    protected String getThreadName() {
        return this.getClass().getSimpleName();
    }

    public synchronized Thread startThread(String name) throws IllegalThreadStateException {
        if (!this.running) {
            log.info((Object)("[Daemon] {startThread} Starting thread " + name));
            this.running = true;
            this.thisThread = new Thread((Runnable)this, name);
            this.thisThread.setDaemon(this.shouldStartAsDaemon());
            this.thisThread.start();
            return this.thisThread;
        }
        throw new IllegalThreadStateException("Daemon must be stopped before it may be started");
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopThread() {
        if (this.isRunning()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("[Daemon] {stopThread} Requesting termination of thread " + this.thisThread.getName()));
            }
            this.running = false;
            Daemon daemon = this;
            synchronized (daemon) {
                this.notifyAll();
            }
        } else {
            throw new IllegalThreadStateException("Daemon must be started before it may be stopped.");
        }
    }

    public synchronized boolean isThreadRunning() {
        if (this.thisThread != null) {
            return this.thisThread.isAlive();
        }
        return false;
    }

    protected boolean shouldStartAsDaemon() {
        return false;
    }

    public static void stopAll(List<? extends Daemon> daemons) {
        for (Daemon daemon : daemons) {
            if (!daemon.isRunning()) continue;
            daemon.stopThread();
        }
    }

    public static boolean waitForTermination(Daemon daemon, long timeoutMillis) {
        List<Daemon> v = Collections.singletonList(daemon);
        return Daemon.waitForTermination(v, timeoutMillis);
    }

    public static boolean waitForTermination(List<? extends Daemon> daemons, long timeoutMillis) {
        long timeout = timeoutMillis <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeoutMillis;
        int size = daemons.size();
        int terminated = 0;
        Vector<Daemon> terminatedDaemons = new Vector<Daemon>(daemons.size());
        Daemon.stopAll(daemons);
        while (System.currentTimeMillis() < timeout && terminated != size) {
            block4: {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    if (timeoutMillis != 0L) break block4;
                    return false;
                }
            }
            for (Daemon daemon : daemons) {
                if (terminatedDaemons.contains(daemon) || daemon.isThreadRunning()) continue;
                terminatedDaemons.add(daemon);
                ++terminated;
            }
        }
        return terminated == size;
    }
}

