/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.system.exec;

import com.peterphi.std.io.StreamUtil;
import com.peterphi.std.threading.Deadline;
import com.peterphi.std.threading.Timeout;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class AbstractProcessTracker {
    protected final List<String> cmd;
    protected final Process process;
    protected final boolean combinedOutput;
    protected boolean finished = false;
    protected int exitCode = Integer.MIN_VALUE;

    protected AbstractProcessTracker(List<String> cmd, Process p, boolean combinedOutput) {
        this.cmd = cmd;
        this.process = p;
        this.combinedOutput = combinedOutput;
    }

    public Process getProcess() {
        return this.process;
    }

    public final void kill() {
        this.kill(false);
    }

    public void kill(boolean force) {
        if (force) {
            this.process.destroyForcibly();
        } else {
            this.process.destroy();
        }
    }

    public boolean isFinished() {
        if (this.finished) {
            return true;
        }
        try {
            int code = this.exitCode();
            this.finished(code);
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public int exitCode() throws IllegalThreadStateException {
        if (this.finished) {
            return this.exitCode;
        }
        return this.process.exitValue();
    }

    public int waitForExit(int expected) {
        return this.waitForExit(Deadline.MAX_VALUE, expected);
    }

    public int waitForExit(Deadline deadline, int expected) {
        int code = this.waitForExit(deadline);
        if (code == Integer.MIN_VALUE) {
            throw new RuntimeException("Unexpected timeout while waiting for exit and expecting code " + expected, new TimeoutException("waitForExit timed out"));
        }
        if (code != expected) {
            throw new RuntimeException("Unexpected code: wanted " + expected + " but got " + code);
        }
        return code;
    }

    public int waitForExit() {
        return this.waitForExit(Deadline.MAX_VALUE);
    }

    public int waitForExit(Deadline deadline) {
        int intervalMax = 4500;
        int interval = 5;
        while (!this.isFinished() && deadline.isValid()) {
            try {
                boolean hasExited;
                if (interval != 4500) {
                    interval = Math.min(interval * 3, 4500);
                }
                if (!(hasExited = this.process.waitFor(Math.min(deadline.getTimeLeft(), (long)interval), TimeUnit.MILLISECONDS))) continue;
                while (deadline.isValid() && this.isStillReadingOutput()) {
                    new Timeout(10L, TimeUnit.MILLISECONDS).sleep();
                }
                return this.exitCode();
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (deadline.isExpired()) {
            return Integer.MIN_VALUE;
        }
        return this.exitCode();
    }

    protected abstract boolean isStillReadingOutput();

    public InputStream getStandardOutputStream() {
        return this.process.getInputStream();
    }

    public InputStream getStandardErrorStream() {
        return this.process.getErrorStream();
    }

    public OutputStream getStandardInputStream() {
        return this.process.getOutputStream();
    }

    public abstract void discardOutput();

    protected void finished(int exitCode) {
        this.exitCode = exitCode;
        this.finished = true;
    }

    protected void unexpectedFailure(IOException e) {
        if (this.finished) {
            return;
        }
        if (!this.isFinished()) {
            this.finished(Integer.MIN_VALUE);
        }
    }

    protected Thread copy(InputStream in, Writer out) {
        Runnable r = () -> {
            try {
                StreamUtil.streamCopy(in, out);
            }
            catch (IOException e) {
                try {
                    out.flush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.unexpectedFailure(e);
            }
        };
        Thread t = new Thread(r);
        t.setName(this + " - IOCopy " + in + " to " + out);
        t.setDaemon(true);
        t.start();
        return t;
    }

    protected Thread discard(InputStream in) {
        if (in == null) {
            return null;
        }
        Runnable r = () -> StreamUtil.eatInputStream(in);
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName(this + " - IODiscard " + in);
        t.start();
        return t;
    }
}

